/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.NoDragUnderEffect;
import org.eclipse.swt.dnd.TableDragUnderEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XmDragProcCallbackStruct;
import org.eclipse.swt.internal.motif.XmDropProcCallbackStruct;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private DragUnderEffect effect;
    private TransferData selectedDataType;
    private int selectedOperation;
    private long dragOverStart;
    private Runnable dragOverHeartbeat;
    private DNDEvent dragOverEvent;
    private XmDropProcCallbackStruct droppedEventData;
    private int dropTransferObject;
    private int selectionTimeout;
    private boolean registered = false;
    private static int DELETE_TYPE = Transfer.registerType("DELETE\u0000");
    private static int NULL_TYPE = Transfer.registerType("NULL\u0000");
    private static final String DROPTARGETID = "DropTarget";
    private static final int DRAGOVER_HYSTERESIS = 50;
    private static Callback DropProc = new Callback(class$org$eclipse$swt$dnd$DropTarget == null ? (class$org$eclipse$swt$dnd$DropTarget = DropTarget.class$("org.eclipse.swt.dnd.DropTarget")) : class$org$eclipse$swt$dnd$DropTarget, "DropProcCallback", 3);
    private static Callback DragProc = new Callback(class$org$eclipse$swt$dnd$DropTarget == null ? (class$org$eclipse$swt$dnd$DropTarget = DropTarget.class$("org.eclipse.swt.dnd.DropTarget")) : class$org$eclipse$swt$dnd$DropTarget, "DragProcCallback", 3);
    private static Callback TransferProc = new Callback(class$org$eclipse$swt$dnd$DropTarget == null ? (class$org$eclipse$swt$dnd$DropTarget = DropTarget.class$("org.eclipse.swt.dnd.DropTarget")) : class$org$eclipse$swt$dnd$DropTarget, "TransferProcCallback", 7);
    static /* synthetic */ Class class$org$eclipse$swt$dnd$DropTarget;

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (DropProc == null || DragProc == null || TransferProc == null) {
            DND.error(2001);
        }
        if (control.getData(DROPTARGETID) != null) {
            DND.error(2001);
        }
        control.setData(DROPTARGETID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (DropTarget.this.isDisposed()) break;
                        DropTarget.this.onDispose();
                        break;
                    }
                    case 22: {
                        if (!DropTarget.this.registered) {
                            DropTarget.this.registerDropTarget();
                            break;
                        }
                        int[] args = new int[]{OS.XmNdropSiteActivity, 0};
                        OS.XmDropSiteUpdate(((DropTarget)DropTarget.this).control.handle, args, args.length / 2);
                        break;
                    }
                    case 23: {
                        int[] args = new int[]{OS.XmNdropSiteActivity, 1};
                        OS.XmDropSiteUpdate(((DropTarget)DropTarget.this).control.handle, args, args.length / 2);
                        break;
                    }
                }
            }
        };
        control.addListener(12, this.controlListener);
        for (Control c = control; c != null; c = c.getParent()) {
            c.addListener(22, this.controlListener);
            c.addListener(23, this.controlListener);
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (DropTarget.this.control == null || DropTarget.this.control.isDisposed()) {
                    return;
                }
                DropTarget.this.unregisterDropTarget();
                DropTarget.this.onDispose();
            }
        });
        this.effect = control instanceof Tree ? new TreeDragUnderEffect((Tree)control) : (control instanceof Table ? new TableDragUnderEffect((Table)control) : new NoDragUnderEffect(control));
        if (control.isVisible()) {
            this.registerDropTarget();
        }
        this.dragOverHeartbeat = new Runnable(){

            public void run() {
                if (DropTarget.this.control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                    return;
                }
                long time = System.currentTimeMillis();
                int delay = 50;
                if (time < DropTarget.this.dragOverStart) {
                    delay = (int)(DropTarget.this.dragOverStart - time);
                } else {
                    int allowedOperations = ((DropTarget)DropTarget.this).dragOverEvent.operations;
                    TransferData[] allowedTypes = ((DropTarget)DropTarget.this).dragOverEvent.dataTypes;
                    TransferData[] dataTypes = new TransferData[allowedTypes.length];
                    System.arraycopy(allowedTypes, 0, dataTypes, 0, dataTypes.length);
                    DNDEvent event = new DNDEvent();
                    event.widget = ((DropTarget)DropTarget.this).dragOverEvent.widget;
                    event.x = ((DropTarget)DropTarget.this).dragOverEvent.x;
                    event.y = ((DropTarget)DropTarget.this).dragOverEvent.y;
                    event.time = (int)time;
                    event.feedback = 1;
                    event.dataTypes = dataTypes;
                    event.dataType = DropTarget.this.selectedDataType;
                    event.operations = ((DropTarget)DropTarget.this).dragOverEvent.operations;
                    event.detail = DropTarget.this.selectedOperation;
                    try {
                        DropTarget.this.notifyListeners(2004, event);
                    }
                    catch (Throwable e) {
                        event.dataType = null;
                        event.detail = 0;
                    }
                    DropTarget.this.effect.show(event.feedback, event.x, event.y);
                    DropTarget.this.selectedDataType = null;
                    if (event.dataType != null) {
                        for (int i = 0; i < allowedTypes.length; ++i) {
                            if (allowedTypes[i].type != event.dataType.type) continue;
                            DropTarget.this.selectedDataType = event.dataType;
                            break;
                        }
                    }
                    DropTarget.this.selectedOperation = 0;
                    if (DropTarget.this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
                        DropTarget.this.selectedOperation = event.detail;
                    }
                }
                DropTarget.this.control.getDisplay().timerExec(delay, DropTarget.this.dragOverHeartbeat);
            }
        };
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    private static int DragProcCallback(int widget, int client_data, int call_data) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target != null) {
            target.dragProcCallback(widget, client_data, call_data);
        }
        return 0;
    }

    private static int DropProcCallback(int widget, int client_data, int call_data) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target != null) {
            target.dropProcCallback(widget, client_data, call_data);
        }
        return 0;
    }

    private static DropTarget FindDropTarget(int handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData(DROPTARGETID);
    }

    private static int TransferProcCallback(int widget, int client_data, int pSelection, int pType, int pValue, int pLength, int pFormat) {
        DropTarget target = DropTarget.FindDropTarget(client_data);
        if (target != null) {
            target.transferProcCallback(widget, client_data, pSelection, pType, pValue, pLength, pFormat);
        }
        return 0;
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$dnd$DropTarget == null ? (class$org$eclipse$swt$dnd$DropTarget = DropTarget.class$("org.eclipse.swt.dnd.DropTarget")) : class$org$eclipse$swt$dnd$DropTarget).getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    private void dragProcCallback(int widget, int client_data, int call_data) {
        DNDEvent event;
        if (call_data == 0) {
            return;
        }
        XmDragProcCallbackStruct callbackData = new XmDragProcCallbackStruct();
        OS.memmove(callbackData, call_data, 24);
        if (callbackData.reason == 1) {
            this.updateDragOverHover(0L, null);
            this.effect.show(0, 0, 0);
            if (callbackData.dropSiteStatus == 2) {
                return;
            }
            DNDEvent event2 = new DNDEvent();
            event2.widget = this;
            event2.time = callbackData.timeStamp;
            event2.detail = 0;
            try {
                this.notifyListeners(2003, event2);
            }
            catch (Throwable e) {
                // empty catch block
            }
            return;
        }
        if (callbackData.reason == 2) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
            this.droppedEventData = null;
            this.dropTransferObject = 0;
        }
        if (!this.setEventData(callbackData.operations, callbackData.operation, callbackData.dragContext, callbackData.x, callbackData.y, callbackData.timeStamp, event = new DNDEvent())) {
            callbackData.dropSiteStatus = (byte)2;
            callbackData.operation = this.opToOsOp(0);
            OS.memmove(call_data, callbackData, 24);
            return;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        switch (callbackData.reason) {
            case 2: {
                event.type = 2002;
                break;
            }
            case 3: {
                event.type = 2004;
                event.dataType = this.selectedDataType;
                event.detail = this.selectedOperation;
                break;
            }
            case 8: {
                event.type = 2005;
                event.dataType = this.selectedDataType;
            }
        }
        this.updateDragOverHover(50L, event);
        try {
            this.notifyListeners(event.type, event);
        }
        catch (Throwable err) {
            callbackData.dropSiteStatus = (byte)2;
            callbackData.operation = this.opToOsOp(0);
            OS.memmove(call_data, callbackData, 24);
            return;
        }
        if (event.detail == 16) {
            event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        if (event.dataType != null) {
            for (int i = 0; i < allowedDataTypes.length; ++i) {
                if (allowedDataTypes[i].type != event.dataType.type) continue;
                this.selectedDataType = allowedDataTypes[i];
                break;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (allowedOperations & event.detail) != 0) {
            this.selectedOperation = event.detail;
        }
        this.effect.show(event.feedback, event.x, event.y);
        callbackData.dropSiteStatus = (byte)3;
        callbackData.operation = this.opToOsOp(this.selectedOperation);
        OS.memmove(call_data, callbackData, 24);
        if (callbackData.reason == 2) {
            this.dragOverHeartbeat.run();
        }
    }

    private void dropProcCallback(int widget, int client_data, int call_data) {
        if (call_data == 0) {
            return;
        }
        this.droppedEventData = new XmDropProcCallbackStruct();
        OS.memmove(this.droppedEventData, call_data, 24);
        if (this.droppedEventData.dropSiteStatus == 2) {
            int[] args = new int[]{OS.XmNtransferStatus, 0, OS.XmNnumDropTransfers, 0};
            this.dropTransferObject = OS.XmDropTransferStart(this.droppedEventData.dragContext, args, args.length / 2);
            return;
        }
        DNDEvent event = new DNDEvent();
        if (!this.setEventData(this.droppedEventData.operations, this.droppedEventData.operation, this.droppedEventData.dragContext, this.droppedEventData.x, this.droppedEventData.y, this.droppedEventData.timeStamp, event)) {
            return;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        try {
            this.notifyListeners(2007, event);
        }
        catch (Throwable err) {
            event.detail = 0;
            event.dataType = null;
        }
        this.selectedDataType = null;
        if (event.dataType != null) {
            for (int i = 0; i < allowedDataTypes.length; ++i) {
                if (allowedDataTypes[i].type != event.dataType.type) continue;
                this.selectedDataType = allowedDataTypes[i];
                break;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (event.detail & allowedOperations) == event.detail) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0) {
            int[] args = new int[]{OS.XmNtransferStatus, 0, OS.XmNnumDropTransfers, 0};
            this.dropTransferObject = OS.XmDropTransferStart(this.droppedEventData.dragContext, args, args.length / 2);
            return;
        }
        int[] transferEntries = new int[]{this.control.handle, this.selectedDataType.type};
        int pTransferEntries = OS.XtMalloc(transferEntries.length * 4);
        OS.memmove(pTransferEntries, transferEntries, transferEntries.length * 4);
        int xtContext = OS.XtDisplayToApplicationContext(this.getDisplay().xDisplay);
        this.selectionTimeout = OS.XtAppGetSelectionTimeout(xtContext);
        OS.XtAppSetSelectionTimeout(xtContext, Integer.MAX_VALUE);
        int[] args = new int[]{OS.XmNdropTransfers, pTransferEntries, OS.XmNnumDropTransfers, transferEntries.length / 2, OS.XmNtransferProc, TransferProc.getAddress()};
        this.dropTransferObject = OS.XmDropTransferStart(this.droppedEventData.dragContext, args, args.length / 2);
        OS.XtFree(pTransferEntries);
    }

    public Control getControl() {
        return this.control;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    public void notifyListeners(int eventType, Event event) {
        Point pt;
        int x1;
        Rectangle area;
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        if (this.control instanceof Tree) {
            Tree tree = (Tree)this.control;
            event.item = tree.getItem(coordinates);
            if (event.item == null && (area = tree.getClientArea()).contains(coordinates)) {
                for (x1 = area.x; x1 < area.x + area.width; ++x1) {
                    pt = new Point(x1, coordinates.y);
                    event.item = tree.getItem(pt);
                    if (event.item != null) break;
                }
            }
        }
        if (this.control instanceof Table) {
            Table table = (Table)this.control;
            event.item = table.getItem(coordinates);
            if (event.item == null && (area = table.getClientArea()).contains(coordinates)) {
                for (x1 = area.x; x1 < area.x + area.width; ++x1) {
                    pt = new Point(x1, coordinates.y);
                    event.item = table.getItem(pt);
                    if (event.item != null) break;
                }
            }
        }
        super.notifyListeners(eventType, event);
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            for (Control c = this.control; c != null; c = c.getParent()) {
                c.removeListener(22, this.controlListener);
                c.removeListener(23, this.controlListener);
            }
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DROPTARGETID, null);
        this.control = null;
        this.transferAgents = null;
    }

    private byte opToOsOp(int operation) {
        byte osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation = (byte)(osOperation | 2);
        }
        if ((operation & 2) == 2) {
            osOperation = (byte)(osOperation | 1);
        }
        if ((operation & 4) == 4) {
            osOperation = (byte)(osOperation | 4);
        }
        return osOperation;
    }

    private int osOpToOp(byte osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 1) == 1) {
            operation |= 2;
        }
        if ((osOperation & 4) == 4) {
            operation |= 4;
        }
        return operation;
    }

    private void registerDropTarget() {
        if (this.control == null || this.control.isDisposed() || this.registered) {
            return;
        }
        int[] args = new int[]{OS.XmNdropSiteOperations, this.opToOsOp(this.getStyle()), OS.XmNdropSiteActivity, 0, OS.XmNdropProc, DropProc.getAddress(), OS.XmNdragProc, DragProc.getAddress(), OS.XmNanimationStyle, 0, OS.XmNdropSiteType, 1};
        if (this.transferAgents.length != 0) {
            TransferData[] transferData = new TransferData[]{};
            int length = this.transferAgents.length;
            for (int i = 0; i < length; ++i) {
                TransferData[] data = this.transferAgents[i].getSupportedTypes();
                TransferData[] newTransferData = new TransferData[transferData.length + data.length];
                System.arraycopy(transferData, 0, newTransferData, 0, transferData.length);
                System.arraycopy(data, 0, newTransferData, transferData.length, data.length);
                transferData = newTransferData;
            }
            int[] atoms = new int[transferData.length];
            int length2 = transferData.length;
            for (int i = 0; i < length2; ++i) {
                atoms[i] = transferData[i].type;
            }
            int pImportTargets = OS.XtMalloc(atoms.length * 4);
            OS.memmove(pImportTargets, atoms, atoms.length * 4);
            int[] args2 = new int[]{OS.XmNimportTargets, pImportTargets, OS.XmNnumImportTargets, atoms.length};
            int[] newArgs = new int[args.length + args2.length];
            System.arraycopy(args, 0, newArgs, 0, args.length);
            System.arraycopy(args2, 0, newArgs, args.length, args2.length);
            args = newArgs;
        }
        OS.XmDropSiteRegister(this.control.handle, args, args.length / 2);
        this.registered = true;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    private boolean setEventData(byte ops, byte op, int dragContext, short x, short y, int timestamp, DNDEvent event) {
        int style = this.getStyle();
        int operations = this.osOpToOp(ops) & style;
        if (operations == 0) {
            return false;
        }
        int operation = this.osOpToOp(op);
        if ((operation & operations) == 0) {
            operation = 0;
        }
        if ((style & 0x10) != 0) {
            int xDisplay = this.getDisplay().xDisplay;
            int xWindow = OS.XDefaultRootWindow(xDisplay);
            int[] unused = new int[1];
            int[] mask_return = new int[1];
            OS.XQueryPointer(xDisplay, xWindow, unused, unused, unused, unused, unused, unused, mask_return);
            int mask = mask_return[0];
            if ((mask & 1) == 0 && (mask & 4) == 0) {
                operation = 16;
            }
        }
        int ppExportTargets = OS.XtMalloc(4);
        int pNumExportTargets = OS.XtMalloc(4);
        int[] args = new int[]{OS.XmNexportTargets, ppExportTargets, OS.XmNnumExportTargets, pNumExportTargets};
        OS.XtGetValues(dragContext, args, args.length / 2);
        int[] numExportTargets = new int[1];
        OS.memmove(numExportTargets, pNumExportTargets, 4);
        OS.XtFree(pNumExportTargets);
        int[] pExportTargets = new int[1];
        OS.memmove(pExportTargets, ppExportTargets, 4);
        OS.XtFree(ppExportTargets);
        int[] exportTargets = new int[numExportTargets[0]];
        OS.memmove(exportTargets, pExportTargets[0], 4 * numExportTargets[0]);
        TransferData[] dataTypes = new TransferData[]{};
        block0: for (int i = 0; i < exportTargets.length; ++i) {
            for (int j = 0; j < this.transferAgents.length; ++j) {
                TransferData transferData = new TransferData();
                transferData.type = exportTargets[i];
                if (!this.transferAgents[j].isSupportedType(transferData)) continue;
                TransferData[] newDataTypes = new TransferData[dataTypes.length + 1];
                System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
                newDataTypes[dataTypes.length] = transferData;
                dataTypes = newDataTypes;
                continue block0;
            }
        }
        if (dataTypes.length == 0) {
            return false;
        }
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.control.handle, x, y, root_x, root_y);
        event.widget = this;
        event.x = root_x[0];
        event.y = root_y[0];
        event.time = timestamp;
        event.feedback = 1;
        event.dataTypes = dataTypes;
        event.dataType = dataTypes[0];
        event.operations = operations;
        event.detail = operation;
        return true;
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (transferAgents == null) {
            DND.error(4);
        }
        this.transferAgents = transferAgents;
        if (!this.control.isVisible()) {
            return;
        }
        TransferData[] transferData = new TransferData[]{};
        int length = transferAgents.length;
        for (int i = 0; i < length; ++i) {
            TransferData[] data = transferAgents[i].getSupportedTypes();
            TransferData[] newTransferData = new TransferData[transferData.length + data.length];
            System.arraycopy(transferData, 0, newTransferData, 0, transferData.length);
            System.arraycopy(data, 0, newTransferData, transferData.length, data.length);
            transferData = newTransferData;
        }
        int[] atoms = new int[transferData.length];
        int length2 = transferData.length;
        for (int i = 0; i < length2; ++i) {
            atoms[i] = transferData[i].type;
        }
        int pImportTargets = OS.XtMalloc(atoms.length * 4);
        OS.memmove(pImportTargets, atoms, atoms.length * 4);
        int[] args = new int[]{OS.XmNimportTargets, pImportTargets, OS.XmNnumImportTargets, atoms.length};
        OS.XmDropSiteUpdate(this.control.handle, args, args.length / 2);
        OS.XtFree(pImportTargets);
    }

    private void transferProcCallback(int widget, int client_data, int pSelection, int pType, int pValue, int pLength, int pFormat) {
        if (pType == 0 || pValue == 0 || pLength == 0 || pFormat == 0) {
            return;
        }
        int[] type = new int[1];
        OS.memmove(type, pType, 4);
        if (type[0] == NULL_TYPE) {
            return;
        }
        DNDEvent event = new DNDEvent();
        if (!this.setEventData(this.droppedEventData.operations, this.droppedEventData.operation, this.droppedEventData.dragContext, this.droppedEventData.x, this.droppedEventData.y, this.droppedEventData.timeStamp, event)) {
            return;
        }
        int allowedOperations = event.operations;
        Object object = null;
        TransferData transferData = new TransferData();
        int[] length = new int[1];
        OS.memmove(length, pLength, 4);
        int[] format = new int[1];
        OS.memmove(format, pFormat, 4);
        transferData.type = type[0];
        transferData.length = length[0];
        transferData.pValue = pValue;
        transferData.format = format[0];
        for (int i = 0; i < this.transferAgents.length; ++i) {
            if (!this.transferAgents[i].isSupportedType(transferData)) continue;
            object = this.transferAgents[i].nativeToJava(transferData);
            break;
        }
        OS.XtFree(pValue);
        if (object == null) {
            this.selectedOperation = 0;
        }
        event.detail = this.selectedOperation;
        event.dataType = transferData;
        event.data = object;
        try {
            this.notifyListeners(2006, event);
            this.selectedOperation = 0;
            if ((allowedOperations & event.detail) == event.detail) {
                this.selectedOperation = event.detail;
            }
        }
        catch (Throwable e) {
            this.selectedOperation = 0;
        }
        int xtContext = OS.XtDisplayToApplicationContext(this.getDisplay().xDisplay);
        OS.XtAppSetSelectionTimeout(xtContext, this.selectionTimeout);
        if ((this.selectedOperation & 2) == 2) {
            int[] args = new int[]{this.control.handle, DELETE_TYPE};
            OS.XmDropTransferAdd(this.dropTransferObject, args, args.length / 2);
        }
    }

    private void unregisterDropTarget() {
        if (this.control == null || this.control.isDisposed() || !this.registered) {
            return;
        }
        OS.XmDropSiteUnregister(this.control.handle);
        this.registered = false;
    }

    private void updateDragOverHover(long delay, DNDEvent event) {
        if (delay == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + delay;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = event.x;
        this.dragOverEvent.y = event.y;
        TransferData[] dataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, dataTypes, 0, dataTypes.length);
        this.dragOverEvent.dataTypes = dataTypes;
        this.dragOverEvent.operations = event.operations;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

