/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpResources;
import org.eclipse.help.internal.RuntimeHelpStatus;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.context.Contexts;
import org.eclipse.help.internal.context.ContextsBuilder;
import org.eclipse.help.internal.context.ContextsFile;
import org.eclipse.help.internal.context.ContextsNode;
import org.eclipse.help.internal.context.RelatedTopic;
import org.eclipse.help.internal.util.FastStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ContextsFileParser
extends DefaultHandler {
    protected FastStack stack = new FastStack();
    StringBuffer buffer = new StringBuffer();
    boolean seenDescription = false;
    ContextsFile contextsFile;
    private ContextsBuilder builder;
    private static final SAXParserFactory factory = SAXParserFactory.newInstance();

    public ContextsFileParser(ContextsBuilder builder) {
        this.builder = builder;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.seenDescription) {
            this.buffer.append(ch, start, length);
        }
        if (HelpPlugin.DEBUG_CONTEXT) {
            System.out.println("ContextsFileParser.characters(): got char from parser= " + new StringBuffer().append(ch, start, length).toString());
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("description")) {
            this.seenDescription = false;
            ((Context)this.stack.peek()).setStyledText(this.buffer.toString());
            this.buffer.setLength(0);
        } else if (qName.equals("b")) {
            this.stack.pop();
            if (!this.stack.peek().equals("<@#$b>")) {
                this.buffer.append("</@#$b>");
            }
        } else {
            ContextsNode node = (ContextsNode)this.stack.pop();
            node.build(this.builder);
        }
    }

    public void error(SAXParseException ex) {
        String message = this.getMessage("E001", ex);
        HelpPlugin.logError(message, null);
        RuntimeHelpStatus.getInstance().addParseError(message, ex.getSystemId());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        String message = this.getMessage("E002", ex);
        HelpPlugin.logError(message, ex);
        RuntimeHelpStatus.getInstance().addParseError(message, ex.getSystemId());
    }

    public String getMessage(String messageID, SAXParseException ex) {
        String param0 = ex.getSystemId();
        Integer param1 = new Integer(ex.getLineNumber());
        Integer param2 = new Integer(ex.getColumnNumber());
        String param3 = ex.getMessage();
        String message = MessageFormat.format(HelpResources.getString(messageID), param0, param1, param2, param3);
        return message;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("description")) {
            this.seenDescription = true;
        } else if (qName.equals("b")) {
            if (!this.stack.peek().equals("<@#$b>")) {
                this.buffer.append("<@#$b>");
            }
            this.stack.push("<@#$b>");
        } else {
            ContextsNode e = null;
            if (qName.equals("contexts")) {
                e = new Contexts(atts);
            } else if (qName.equals("context")) {
                e = new Context(atts);
            } else if (qName.equals("topic")) {
                e = new RelatedTopic(atts);
            } else {
                return;
            }
            if (!this.stack.empty()) {
                ((ContextsNode)this.stack.peek()).addChild(e);
            }
            this.stack.push(e);
        }
    }

    public void warning(SAXParseException ex) {
        String message = this.getMessage("E003", ex);
        HelpPlugin.logWarning(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(ContextsFile contextsFile) {
        this.contextsFile = contextsFile;
        InputStream is = contextsFile.getInputStream();
        if (is == null) {
            return;
        }
        InputSource inputSource = new InputSource(is);
        String file = "/" + contextsFile.getDefiningPluginID() + "/" + contextsFile.getHref();
        inputSource.setSystemId(file);
        SAXParser parser = factory.newSAXParser();
        parser.parse(inputSource, (DefaultHandler)this);
        Object var8_9 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException e) {}
        return;
        {
            catch (ParserConfigurationException pce) {
                HelpPlugin.logError(HelpResources.getString("ContextsFileParser.PCE"), pce);
                Object var8_10 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
            catch (SAXException se) {
                HelpPlugin.logError("", se);
                Object var8_11 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
            catch (IOException ioe) {
                String msg = HelpResources.getString("E009", file);
                HelpPlugin.logError(msg, ioe);
                RuntimeHelpStatus.getInstance().addParseError(msg, file);
                Object var8_12 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource source = new InputSource(new ByteArrayInputStream(new byte[0]));
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }
}

