/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.JspServletWrapper;

public class JspCompilationContext {
    protected String servletClassName;
    protected String jspUri;
    private boolean isErrPage;
    protected String servletPackageName = "org.apache.jsp";
    protected String servletJavaFileName;
    protected String jspPath;
    protected String classFileName;
    protected String contentType;
    protected JspReader reader;
    protected ServletWriter writer;
    protected Options options;
    protected JspServletWrapper jsw;
    protected Compiler jspCompiler;
    protected String classPath;
    protected String baseURI;
    protected String outputDir;
    protected ServletContext context;
    protected URLClassLoader loader;
    protected JspRuntimeContext rctxt;
    protected int removed = 0;
    protected URLClassLoader jspLoader;
    protected URL[] outUrls = new URL[1];
    protected Class servletClass;

    public JspCompilationContext(String jspUri, boolean isErrPage, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt) {
        this.jspUri = JspCompilationContext.canonicalURI(jspUri);
        this.isErrPage = isErrPage;
        this.options = options;
        this.jsw = jsw;
        this.context = context;
        this.baseURI = jspUri.substring(0, jspUri.lastIndexOf(47) + 1);
        if (this.baseURI == null) {
            this.baseURI = "/";
        } else if (this.baseURI.charAt(0) != '/') {
            this.baseURI = "/" + this.baseURI;
        }
        if (this.baseURI.charAt(this.baseURI.length() - 1) != '/') {
            this.baseURI = this.baseURI + '/';
        }
        this.rctxt = rctxt;
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return this.rctxt.getClassPath();
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.rctxt.getParentClassLoader();
    }

    public void setClassLoader(URLClassLoader loader) {
        this.loader = loader;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String s) {
        this.outputDir = s;
    }

    public Compiler createCompiler() throws JasperException {
        if (this.jspCompiler != null) {
            return this.jspCompiler;
        }
        this.jspCompiler = new Compiler(this, this.jsw);
        return this.jspCompiler;
    }

    public String resolveRelativeUri(String uri) {
        if (uri.startsWith("/") || uri.startsWith(File.separator)) {
            return uri;
        }
        return this.baseURI + uri;
    }

    public InputStream getResourceAsStream(String res) {
        return this.context.getResourceAsStream(JspCompilationContext.canonicalURI(res));
    }

    public URL getResource(String res) throws MalformedURLException {
        return this.context.getResource(JspCompilationContext.canonicalURI(res));
    }

    public String getRealPath(String path) {
        if (this.context != null) {
            return this.context.getRealPath(path);
        }
        return path;
    }

    public String getServletClassName() {
        if (this.servletClassName != null) {
            return this.servletClassName;
        }
        int iSep = this.jspUri.lastIndexOf(47) + 1;
        int iEnd = this.jspUri.length();
        StringBuffer modifiedClassName = new StringBuffer(this.jspUri.length() - iSep);
        if (!Character.isJavaIdentifierStart(this.jspUri.charAt(iSep))) {
            modifiedClassName.append('_');
        }
        for (int i = iSep; i < iEnd; ++i) {
            char ch = this.jspUri.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                modifiedClassName.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedClassName.append('_');
                continue;
            }
            modifiedClassName.append(JspCompilationContext.mangleChar(ch));
        }
        this.servletClassName = modifiedClassName.toString();
        return this.servletClassName;
    }

    public void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    public String getJspFile() {
        return this.jspUri;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.servletPackageName = servletPackageName;
    }

    public String getServletJavaFileName() {
        if (this.servletJavaFileName != null) {
            return this.servletJavaFileName;
        }
        String outputDir = this.getOutputDir();
        this.servletJavaFileName = this.getServletClassName() + ".java";
        if (outputDir != null && !outputDir.equals("")) {
            this.servletJavaFileName = outputDir.endsWith("/") ? outputDir + this.servletJavaFileName : outputDir + "/" + this.servletJavaFileName;
        }
        return this.servletJavaFileName;
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getJspPath() {
        if (this.jspPath != null) {
            return this.jspPath;
        }
        String dirName = this.getJspFile();
        int pos = dirName.lastIndexOf(47);
        dirName = pos > 0 ? dirName.substring(0, pos + 1) : "";
        this.jspPath = dirName + this.getServletClassName() + ".java";
        if (this.jspPath.startsWith("/")) {
            this.jspPath = this.jspPath.substring(1);
        }
        return this.jspPath;
    }

    public String getClassFileName() {
        if (this.classFileName != null) {
            return this.classFileName;
        }
        String outputDir = this.getOutputDir();
        this.classFileName = this.getServletClassName() + ".class";
        if (outputDir != null && !outputDir.equals("")) {
            this.classFileName = outputDir + File.separatorChar + this.classFileName;
        }
        return this.classFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public JspReader getReader() {
        return this.reader;
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public String[] getTldLocation(String uri) throws JasperException {
        String[] location = this.getOptions().getTldLocationsCache().getLocation(uri);
        return location;
    }

    public boolean keepGenerated() {
        return this.getOptions().getKeepGenerated();
    }

    public void incrementRemoved() {
        if (this.removed > 1) {
            this.jspCompiler.removeGeneratedFiles();
            if (this.rctxt != null) {
                this.rctxt.removeWrapper(this.jspUri);
            }
        }
        ++this.removed;
    }

    public boolean isRemoved() {
        return this.removed > 1;
    }

    public void compile() throws JasperException, FileNotFoundException {
        this.createCompiler();
        if (this.jspCompiler.isOutDated()) {
            try {
                this.jspCompiler.compile();
                this.jsw.setReload(true);
            }
            catch (JasperException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new JasperException(Constants.getString((String)"jsp.error.unable.compile"), (Throwable)ex);
            }
        }
    }

    public Class load() throws JasperException, FileNotFoundException {
        try {
            this.jspLoader = new JasperLoader(this.outUrls, this.getServletPackageName() + "." + this.getServletClassName(), this.rctxt.getParentClassLoader(), this.rctxt.getPermissionCollection(), this.rctxt.getCodeSource());
            this.servletClass = this.jspLoader.loadClass(this.getServletPackageName() + "." + this.getServletClassName());
        }
        catch (ClassNotFoundException cex) {
            throw new JasperException(Constants.getString((String)"jsp.error.unable.load"), (Throwable)cex);
        }
        catch (Exception ex) {
            throw new JasperException(Constants.getString((String)"jsp.error.unable.compile"), (Throwable)ex);
        }
        this.removed = 0;
        return this.servletClass;
    }

    public void createOutdir() {
        File outDirF = null;
        try {
            URL outURL = this.options.getScratchDir().toURL();
            String outURI = outURL.toString();
            outURI = outURI.endsWith("/") ? outURI + this.jspUri.substring(1, this.jspUri.lastIndexOf("/") + 1) : outURI + this.jspUri.substring(0, this.jspUri.lastIndexOf("/") + 1);
            outURL = new URL(outURI);
            outDirF = new File(outURL.getFile());
            if (!outDirF.exists()) {
                outDirF.mkdirs();
            }
            this.setOutputDir(outDirF.toString() + File.separator);
            this.outUrls[0] = new URL(outDirF.toURL().toString() + File.separator);
        }
        catch (Exception e) {
            throw new IllegalStateException("No output directory: " + e.getMessage());
        }
    }

    private static final String mangleChar(char ch) {
        int i;
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        for (i = 1; i <= nzeros; ++i) {
            result[i] = 48;
        }
        i = nzeros + 1;
        int j = 0;
        while (i < 6) {
            result[i] = s.charAt(j);
            ++i;
            ++j;
        }
        return new String(result);
    }

    private static final boolean isPathSeparator(char c) {
        return c == '/' || c == '\\';
    }

    private static final String canonicalURI(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int len = s.length();
        int pos = 0;
        block4: while (pos < len) {
            char c = s.charAt(pos);
            if (JspCompilationContext.isPathSeparator(c)) {
                while (pos + 1 < len && JspCompilationContext.isPathSeparator(s.charAt(pos + 1))) {
                    ++pos;
                }
                if (pos + 1 < len && s.charAt(pos + 1) == '.') {
                    if (pos + 2 >= len) break;
                    switch (s.charAt(pos + 2)) {
                        case '/': 
                        case '\\': {
                            pos += 2;
                            continue block4;
                        }
                        case '.': {
                            int separatorPos;
                            if (pos + 3 >= len || !JspCompilationContext.isPathSeparator(s.charAt(pos + 3))) break;
                            pos += 3;
                            for (separatorPos = result.length() - 1; separatorPos >= 0 && !JspCompilationContext.isPathSeparator(result.charAt(separatorPos)); --separatorPos) {
                            }
                            if (separatorPos < 0) continue block4;
                            result.setLength(separatorPos);
                            continue block4;
                        }
                    }
                }
            }
            result.append(c);
            ++pos;
        }
        return result.toString();
    }
}

