/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.UpdateDialog;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;

public abstract class CVSSubscriberOperation
extends SynchronizeModelOperation {
    protected CVSSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final Map projectSyncInfos = this.getProjectSyncInfoSetMap();
        monitor.beginTask(null, projectSyncInfos.size() * 100);
        Iterator iter = projectSyncInfos.keySet().iterator();
        while (iter.hasNext()) {
            final IProject project = (IProject)iter.next();
            try {
                EclipseSynchronizer.getInstance().run((ISchedulingRule)project, new ICVSRunnable(){

                    public void run(IProgressMonitor monitor) throws CVSException {
                        try {
                            CVSSubscriberOperation.this.run((SyncInfoSet)projectSyncInfos.get(project), monitor);
                        }
                        catch (TeamException e) {
                            throw CVSException.wrapException((CoreException)((Object)e));
                        }
                    }
                }, Policy.subMonitorFor(monitor, 100));
            }
            catch (TeamException e) {
                throw new InvocationTargetException(e);
            }
        }
        monitor.done();
    }

    protected abstract void run(SyncInfoSet var1, IProgressMonitor var2) throws TeamException;

    protected boolean isOutOfSync(SyncInfo resource) {
        if (resource == null) {
            return false;
        }
        return resource.getKind() != 0 || !resource.getLocal().exists() && resource.getRemote() != null;
    }

    protected void makeInSync(SyncInfo[] folders, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, folders.length);
        for (int i = 0; i < folders.length; ++i) {
            SyncInfo resource = folders[i];
            this.makeInSync(resource);
            monitor.worked(1);
        }
        monitor.done();
    }

    protected boolean makeInSync(SyncInfo info) throws TeamException {
        if (this.isOutOfSync(info)) {
            SyncInfo parent = this.getParent(info);
            if (parent == null) {
                if (info.getLocal().getType() == 8) {
                    return true;
                }
                CVSUIPlugin.log(2, Policy.bind("CVSSubscriberAction.0", info.getLocal().getFullPath().toString()), null);
                return false;
            }
            if (!this.makeInSync(parent)) {
                return false;
            }
            if (info instanceof CVSSyncInfo) {
                CVSSyncInfo cvsInfo = (CVSSyncInfo)info;
                IStatus status = cvsInfo.makeInSync();
                if (status.getSeverity() == 4) {
                    this.logError(status);
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void makeOutgoing(SyncInfo[] folders, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, 100 * folders.length);
        for (int i = 0; i < folders.length; ++i) {
            SyncInfo info = folders[i];
            this.makeOutgoing(info, Policy.subMonitorFor(monitor, 100));
        }
        monitor.done();
    }

    private void makeOutgoing(SyncInfo info, IProgressMonitor monitor) throws TeamException {
        CVSSyncInfo cvsInfo;
        IStatus status;
        if (info == null) {
            return;
        }
        if (info instanceof CVSSyncInfo && (status = (cvsInfo = (CVSSyncInfo)info).makeOutgoing(monitor)).getSeverity() == 4) {
            this.logError(status);
        }
    }

    protected void logError(IStatus status) {
        CVSUIPlugin.log(status);
    }

    protected void handle(Exception t) {
        CVSUIPlugin.openError(this.getShell(), this.getErrorTitle(), null, t, 13);
    }

    protected String getErrorTitle() {
        return null;
    }

    protected boolean canRunAsJob() {
        return true;
    }

    protected void pruneEmptyParents(SyncInfo[] nodes) throws CVSException {
        if (!CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
            return;
        }
        ICVSResource[] cvsResources = new ICVSResource[nodes.length];
        for (int i = 0; i < cvsResources.length; ++i) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)nodes[i].getLocal());
        }
        new PruneFolderVisitor().visit(CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()), cvsResources);
    }

    public CVSSyncInfo getCVSSyncInfo(SyncInfo info) {
        if (info instanceof CVSSyncInfo) {
            return (CVSSyncInfo)info;
        }
        return null;
    }

    protected SyncInfo getParent(SyncInfo info) throws TeamException {
        return ((CVSSyncInfo)info).getSubscriber().getSyncInfo((IResource)info.getLocal().getParent());
    }

    protected IResource[] getIResourcesFrom(SyncInfo[] nodes) {
        ArrayList<IResource> resources = new ArrayList<IResource>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            resources.add(nodes[i].getLocal());
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    protected boolean promptForOverwrite(final SyncInfoSet syncSet) {
        final int[] result = new int[]{1};
        TeamUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                UpdateDialog dialog = new UpdateDialog(CVSSubscriberOperation.this.getShell(), syncSet);
                result[0] = dialog.open();
            }
        });
        return result[0] == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeRemoteLocal(SyncInfo info, IProgressMonitor monitor) throws TeamException {
        block10: {
            IResourceVariant remote = info.getRemote();
            IResource local = info.getLocal();
            try {
                if (remote == null) {
                    if (local.exists()) {
                        local.delete(2, monitor);
                    }
                    break block10;
                }
                if (remote.isContainer()) {
                    this.ensureContainerExists(info);
                    break block10;
                }
                monitor.beginTask(null, 200);
                try {
                    IFile localFile = (IFile)local;
                    if (local.exists()) {
                        localFile.setContents(remote.getStorage(Policy.subMonitorFor(monitor, 100)).getContents(), false, true, Policy.subMonitorFor(monitor, 100));
                    } else {
                        this.ensureContainerExists(this.getParent(info));
                        localFile.create(remote.getStorage(Policy.subMonitorFor(monitor, 100)).getContents(), false, Policy.subMonitorFor(monitor, 100));
                    }
                }
                finally {
                    monitor.done();
                }
            }
            catch (CoreException e) {
                throw new CVSException(Policy.bind("UpdateMergeActionProblems_merging_remote_resources_into_workspace_1"), (Throwable)e);
            }
        }
    }

    private boolean ensureContainerExists(SyncInfo info) throws TeamException {
        CVSSyncInfo cvsInfo;
        IStatus status;
        IResource local = info.getLocal();
        if (!local.exists() && !this.ensureContainerExists(this.getParent(info))) {
            return false;
        }
        if (this.isOutOfSync(info) && info instanceof CVSSyncInfo && (status = (cvsInfo = (CVSSyncInfo)info).makeInSync()).getSeverity() == 4) {
            this.logError(status);
            return false;
        }
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)local));
        if (!cvsFolder.exists()) {
            cvsFolder.mkdir();
        }
        return true;
    }

    private Map getProjectSyncInfoSetMap() {
        HashMap<IProject, SyncInfoSet> map = new HashMap<IProject, SyncInfoSet>();
        SyncInfoSet all = this.getSyncInfoSet();
        SyncInfo[] infos = all.getSyncInfos();
        for (int i = 0; i < infos.length; ++i) {
            SyncInfo info = infos[i];
            IProject project = info.getLocal().getProject();
            SyncInfoSet set = (SyncInfoSet)map.get(project);
            if (set == null) {
                set = new SyncInfoSet();
                map.put(project, set);
            }
            set.add(info);
        }
        return map;
    }
}

