/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.AbstractTreeItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.SelectableItem;
import org.eclipse.swt.widgets.SelectableItemWidget;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TreeRoots;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends SelectableItemWidget {
    private static final int ActionNone = 0;
    private static final int ActionExpandCollapse = 1;
    private static final int ActionSelect = 2;
    private static final int ActionCheck = 3;
    private static ImageData CollapsedImageData;
    private static ImageData ExpandedImageData;
    private TreeRoots root;
    private TreeItem expandingItem;
    private Image collapsedImage;
    private Image expandedImage;
    final Color CONNECTOR_LINE_COLOR = new Color(this.display, 170, 170, 170);
    Rectangle hierarchyIndicatorRect = null;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    void addItem(TreeItem item, int index) {
        if (index < 0 || index > this.getItemCount()) {
            this.error(6);
        }
        this.getRoot().add(item, index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    void addedItem(SelectableItem item, int index) {
        super.addedItem(item, index);
        this.redrawAfterModify(item, index);
    }

    int[] calculateChildrenYPos(TreeItem item) {
        int itemIndex = item.getVisibleIndex();
        int itemCount = item.getVisibleItemCount();
        int itemHeight = this.getItemHeight();
        int[] yPosition = new int[]{-1, -1};
        if (itemIndex != -1) {
            int yPos = ((itemIndex -= this.getTopIndex()) + itemCount + 1) * itemHeight;
            yPosition = new int[]{yPos - itemCount * itemHeight, yPos};
        }
        return yPosition;
    }

    void calculateWidestExpandingItem(TreeItem item) {
        int itemIndex = item.getVisibleIndex();
        int newMaximumItemWidth = this.getContentWidth();
        int stopIndex = itemIndex + item.getVisibleItemCount();
        for (int i = itemIndex + 1; i <= stopIndex; ++i) {
            newMaximumItemWidth = Math.max(newMaximumItemWidth, this.getContentWidth(i));
        }
        this.setContentWidth(newMaximumItemWidth);
    }

    void calculateWidestScrolledItem(int topIndexDifference) {
        int topIndex;
        int visibleItemCount = this.getItemCountTruncated(this.getClientArea());
        int newMaximumItemWidth = this.getContentWidth();
        int stopIndex = topIndex = this.getTopIndex();
        if (topIndexDifference < 0) {
            if (Math.abs(topIndexDifference) > visibleItemCount) {
                topIndexDifference = visibleItemCount * -1;
            }
            for (int i = stopIndex - topIndexDifference; i >= stopIndex; --i) {
                newMaximumItemWidth = Math.max(newMaximumItemWidth, this.getContentWidth(i));
            }
        } else if (topIndexDifference > 0) {
            if (topIndexDifference > visibleItemCount) {
                topIndexDifference = visibleItemCount;
            }
            for (int i = (stopIndex += visibleItemCount) - topIndexDifference; i < stopIndex; ++i) {
                newMaximumItemWidth = Math.max(newMaximumItemWidth, this.getContentWidth(i));
            }
        }
        this.setContentWidth(newMaximumItemWidth);
    }

    void calculateWidestShowingItem() {
        int newMaximumItemWidth = 0;
        int bottomIndex = this.getBottomIndex();
        if (this.getHorizontalBar().getVisible()) {
            ++bottomIndex;
        }
        for (int i = this.getTopIndex(); i < bottomIndex; ++i) {
            TreeItem visibleItem = this.getRoot().getVisibleItem(i);
            if (visibleItem == null) continue;
            int paintStopX = visibleItem.getPaintStopX();
            newMaximumItemWidth = Math.max(newMaximumItemWidth, paintStopX);
        }
        this.setContentWidth(newMaximumItemWidth);
    }

    static int checkStyle(int style) {
        return Tree.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void collapse(TreeItem item, boolean notifyListeners) {
        if (!item.getExpanded()) {
            return;
        }
        if (notifyListeners) {
            Event event = new Event();
            event.item = item;
            this.notifyListeners(18, event);
            if (this.isDisposed()) {
                return;
            }
        }
        this.collapseNoRedraw(item);
        int itemIndex = item.getVisibleIndex();
        if (itemIndex != -1) {
            item.redrawExpanded(itemIndex - this.getTopIndex());
            this.showSelectableItem(item);
            this.calculateVerticalScrollbar();
            this.calculateWidestShowingItem();
            this.claimRightFreeSpace();
            this.claimBottomFreeSpace();
        }
    }

    void collapseNoRedraw(TreeItem item) {
        if (!item.getExpanded()) {
            return;
        }
        if (this.isSelectedItemCollapsing(item)) {
            this.deselectAllExcept(item);
            this.selectNotify(item);
            this.update();
        }
        this.scrollForCollapse(item);
        item.internalSetExpanded(false);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = super.computeSize(wHint, hHint, changed);
        int WidthCalculationCount = 50;
        TreeRoots root = this.getRoot();
        int newItemWidth = 0;
        if (wHint == -1 && this.getContentWidth() == 0 && this.getItemCount() > 0) {
            TreeItem item;
            GC gc = new GC(this);
            for (int i = 0; i < 50 && (item = root.getVisibleItem(i)) != null; ++i) {
                Image itemImage = item.getImage();
                String itemText = item.getText();
                int width = 0;
                if (itemImage != null) {
                    width += itemImage.getBounds().width;
                }
                if (itemText != null) {
                    gc.setFont(item.getFont());
                    width += gc.stringExtent((String)itemText).x;
                }
                newItemWidth = Math.max(newItemWidth, width);
            }
            if (newItemWidth > 0) {
                size.x = newItemWidth;
            }
            gc.dispose();
        }
        return size;
    }

    public void deselectAll() {
        this.checkWidget();
        this.getRoot().deselectAll();
        this.getSelectionVector().removeAllElements();
        this.redraw();
    }

    void doArrowLeft(int keyMask) {
        TreeItem focusItem = (TreeItem)this.getLastFocus();
        if (focusItem == null) {
            return;
        }
        if (keyMask == SWT.MOD1) {
            super.doArrowLeft(keyMask);
        } else if (focusItem.getExpanded()) {
            this.collapse(focusItem, true);
        } else if (!focusItem.isRoot()) {
            TreeItem parentItem = focusItem.getParentItem();
            this.deselectAllExcept(parentItem);
            this.selectNotify(parentItem);
        }
    }

    void doArrowRight(int keyMask) {
        TreeItem focusItem = (TreeItem)this.getLastFocus();
        if (focusItem == null) {
            return;
        }
        if (keyMask == SWT.MOD1) {
            super.doArrowRight(keyMask);
        } else if (!focusItem.isLeaf()) {
            if (!focusItem.getExpanded()) {
                this.expand(focusItem, true);
            } else {
                TreeItem childItem = focusItem.getItems()[0];
                this.deselectAllExcept(childItem);
                this.selectNotify(childItem);
            }
        }
    }

    void doAsterisk() {
        this.expandAll((TreeItem)this.getLastFocus());
    }

    void doDispose() {
        super.doDispose();
        if (this.collapsedImage != null) {
            this.collapsedImage.dispose();
        }
        if (this.expandedImage != null) {
            this.expandedImage.dispose();
        }
        this.getRoot().dispose();
        this.CONNECTOR_LINE_COLOR.dispose();
        this.resetHierarchyIndicatorRect();
    }

    void doMinus() {
        TreeItem selectedItem = (TreeItem)this.getLastFocus();
        if (selectedItem != null) {
            this.collapse(selectedItem, true);
        }
    }

    void doPlus() {
        TreeItem selectedItem = (TreeItem)this.getLastFocus();
        if (selectedItem != null && !selectedItem.isLeaf()) {
            this.expand(selectedItem, true);
        }
    }

    void expand(TreeItem item, boolean notifyListeners) {
        boolean nestedExpand;
        Event event = new Event();
        boolean bl = nestedExpand = this.expandingItem != null;
        if (item.getExpanded() || item.getExpanding()) {
            return;
        }
        item.setExpanding(true);
        if (!nestedExpand) {
            this.setExpandingItem(item);
        }
        if (notifyListeners) {
            event.item = item;
            this.notifyListeners(17, event);
        }
        this.scrollForExpand(item);
        item.internalSetExpanded(true);
        item.redrawExpanded(item.getVisibleIndex() - this.getTopIndex());
        this.calculateVerticalScrollbar();
        if (!nestedExpand && this.isVisible()) {
            this.showSelectableItem(item);
            this.calculateWidestExpandingItem(item);
            this.scrollExpandedItemsIntoView(item);
        }
        if (!nestedExpand) {
            this.setExpandingItem(null);
        }
        item.setExpanding(false);
    }

    void expandAll(TreeItem item) {
        if (item != null && !item.isLeaf()) {
            this.expand(item, true);
            this.update();
            TreeItem[] items = item.getItems();
            for (int i = 0; i < items.length; ++i) {
                this.expandAll(items[i]);
            }
        }
    }

    Image getCollapsedImage() {
        if (this.collapsedImage == null) {
            this.collapsedImage = new Image((Device)this.display, CollapsedImageData);
        }
        return this.collapsedImage;
    }

    int getContentWidth(int itemIndex) {
        TreeItem item = this.getRoot().getVisibleItem(itemIndex);
        int paintStopX = 0;
        if (item != null) {
            paintStopX = item.getPaintStopX();
        }
        return paintStopX;
    }

    Image getExpandedImage() {
        if (this.expandedImage == null) {
            this.expandedImage = new Image((Device)this.display, ExpandedImageData);
        }
        return this.expandedImage;
    }

    Rectangle getHierarchyIndicatorRect() {
        int itemHeight = this.getItemHeight();
        if (this.hierarchyIndicatorRect == null && itemHeight != -1) {
            Image hierarchyImage = this.getCollapsedImage();
            Rectangle imageBounds = hierarchyImage != null ? hierarchyImage.getBounds() : new Rectangle(0, 0, 0, 0);
            this.hierarchyIndicatorRect = new Rectangle(0, (itemHeight - imageBounds.height) / 2 + (itemHeight - imageBounds.height) % 2, imageBounds.width, imageBounds.height);
        }
        return this.hierarchyIndicatorRect;
    }

    int getIndex(SelectableItem item) {
        int index = -1;
        if (item != null) {
            index = ((TreeItem)item).getGlobalIndex();
        }
        return index;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.getRoot().getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        return super.getItemHeight();
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        Object[] childrenArray = new TreeItem[this.getItemCount()];
        this.getRoot().getChildren().copyInto(childrenArray);
        return childrenArray;
    }

    int getOffScreenItemCount(TreeItem item) {
        int itemIndexFromTop = item.getVisibleIndex() - this.getTopIndex();
        int spaceRemaining = this.getItemCountWhole() - (itemIndexFromTop + 1);
        int expandedItemCount = item.getVisibleItemCount();
        return expandedItemCount - spaceRemaining;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    TreeRoots getRoot() {
        return this.root;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        Vector selectionVector = this.getSelectionVector();
        Object[] selectionArray = new TreeItem[selectionVector.size()];
        selectionVector.copyInto(selectionArray);
        this.sort((SelectableItem[])selectionArray, 0, selectionArray.length);
        return selectionArray;
    }

    int getVisibleIndex(SelectableItem item) {
        int index = -1;
        if (item != null) {
            index = ((AbstractTreeItem)item).getVisibleIndex();
        }
        return index;
    }

    SelectableItem getVisibleItem(int itemIndex) {
        return this.getRoot().getVisibleItem(itemIndex);
    }

    int getVisibleItemCount() {
        return this.getRoot().getVisibleItemCount();
    }

    int getVisibleRedrawY(SelectableItem item) {
        int redrawY = this.getRedrawY(item);
        if (redrawY < 0 || redrawY > this.getClientArea().height) {
            redrawY = -1;
        }
        return redrawY;
    }

    void handleEvents(Event event) {
        switch (event.type) {
            case 9: {
                this.paint(event);
                break;
            }
            case 3: {
                this.mouseDown(event);
                break;
            }
            case 8: {
                this.mouseDoubleClick(event);
                break;
            }
            default: {
                super.handleEvents(event);
            }
        }
    }

    void initialize() {
        this.resetRoot();
        super.initialize();
    }

    static void initializeImageData() {
        PaletteData fourBit = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(128, 0, 0), new RGB(0, 128, 0), new RGB(128, 128, 0), new RGB(0, 0, 128), new RGB(128, 0, 128), new RGB(0, 128, 128), new RGB(128, 128, 128), new RGB(192, 192, 192), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(0, 0, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)});
        CollapsedImageData = new ImageData(9, 9, 4, fourBit, 4, new byte[]{119, 119, 119, 119, 112, 0, 0, 0, 127, -1, -1, -1, 112, 0, 0, 0, 127, -1, 15, -1, 112, 0, 0, 0, 127, -1, 15, -1, 112, 0, 0, 0, 127, 0, 0, 15, 112, 0, 0, 0, 127, -1, 15, -1, 112, 0, 0, 0, 127, -1, 15, -1, 112, 0, 0, 0, 127, -1, -1, -1, 112, 0, 0, 0, 119, 119, 119, 119, 112, 0, 0, 0});
        Tree.CollapsedImageData.transparentPixel = 15;
        ExpandedImageData = new ImageData(9, 9, 4, fourBit, 4, new byte[]{119, 119, 119, 119, 112, 0, 0, 0, 127, -1, -1, -1, 112, 0, 0, 0, 127, -1, -1, -1, 112, 0, 0, 0, 127, -1, -1, -1, 112, 0, 0, 0, 127, 0, 0, 15, 112, 0, 0, 0, 127, -1, -1, -1, 112, 0, 0, 0, 127, -1, -1, -1, 112, 0, 0, 0, 127, -1, -1, -1, 112, 0, 0, 0, 119, 119, 119, 119, 112, 0, 0, 0});
        Tree.ExpandedImageData.transparentPixel = 15;
    }

    void installListeners() {
        Listener listener = this.getListener();
        super.installListeners();
        this.addListener(9, listener);
        this.addListener(3, listener);
        this.addListener(8, listener);
    }

    boolean isExpandingItem(SelectableItem item) {
        if (this.expandingItem == null || item == null || !(item instanceof TreeItem)) {
            return false;
        }
        TreeItem parentItem = ((TreeItem)item).getParentItem();
        return parentItem == this.expandingItem || this.isExpandingItem(parentItem);
    }

    boolean isSelectedItemCollapsing(TreeItem collapsingItem) {
        Enumeration selection = this.getSelectionVector().elements();
        int collapsingItemIndex = collapsingItem.getVisibleIndex();
        int lastCollapsedItemIndex = collapsingItemIndex + collapsingItem.getVisibleItemCount();
        if (collapsingItemIndex == -1) {
            return false;
        }
        while (selection.hasMoreElements()) {
            TreeItem item = (TreeItem)selection.nextElement();
            int selectedItemIndex = item.getVisibleIndex();
            if (selectedItemIndex <= collapsingItemIndex || selectedItemIndex > lastCollapsedItemIndex) continue;
            return true;
        }
        return false;
    }

    int itemAction(TreeItem item, int x, int y) {
        int action = 0;
        int itemHeight = this.getItemHeight();
        if (item != null) {
            int offsetX = x - item.getPaintStartX();
            int offsetY = y - itemHeight * (y / itemHeight);
            Point offsetPoint = new Point(offsetX, offsetY);
            if (!item.isLeaf() && this.getHierarchyIndicatorRect().contains(offsetPoint)) {
                action |= 1;
            } else if (item.isSelectionHit(offsetPoint)) {
                action |= 2;
            } else if (item.isCheckHit(new Point(x, y))) {
                action |= 3;
            }
        }
        return action;
    }

    void itemChanged(SelectableItem changedItem, int repaintStartX, int repaintWidth) {
        int oldItemHeight = this.getItemHeight();
        Point oldImageExtent = this.getImageExtent();
        if (!this.isExpandingItem(changedItem)) {
            super.itemChanged(changedItem, repaintStartX, repaintWidth);
        } else {
            this.calculateItemHeight(changedItem);
        }
        if (oldItemHeight != this.getItemHeight() || oldImageExtent != this.getImageExtent()) {
            this.getRoot().reset();
            this.resetHierarchyIndicatorRect();
            this.redraw();
        } else {
            ((AbstractTreeItem)changedItem).reset();
        }
        if (repaintWidth != 0) {
            this.calculateWidestShowingItem();
            this.claimRightFreeSpace();
        }
    }

    void keyDown(Event event) {
        super.keyDown(event);
        switch (event.character) {
            case '+': {
                this.doPlus();
                break;
            }
            case '-': {
                this.doMinus();
                break;
            }
            case '*': {
                this.doAsterisk();
            }
        }
    }

    void mouseDoubleClick(Event event) {
        int hitItemIndex = event.y / this.getItemHeight();
        TreeItem hitItem = this.getRoot().getVisibleItem(hitItemIndex + this.getTopIndex());
        if (hitItem == null || this.itemAction(hitItem, event.x, event.y) != 2) {
            return;
        }
        if (this.isListening(14)) {
            if (!this.getIgnoreDoubleClick()) {
                Event newEvent = new Event();
                newEvent.item = hitItem;
                this.postEvent(14, newEvent);
            }
        } else if (!hitItem.isLeaf()) {
            if (hitItem.getExpanded()) {
                this.collapse(hitItem, true);
            } else {
                this.expand(hitItem, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void mouseDown(Event event) {
        void var5_5;
        SelectableItem selectionItem = this.getLastSelection();
        int hitItemIndex = event.y / this.getItemHeight();
        TreeItem hitItem = this.getRoot().getVisibleItem(hitItemIndex + this.getTopIndex());
        if (hitItem == null) {
            return;
        }
        if (!this.isFocusControl()) {
            this.forceFocus();
        }
        int itemAction = this.itemAction(hitItem, event.x, event.y);
        switch (itemAction) {
            case 1: {
                if (event.button != 1) {
                    return;
                }
                if (hitItem.getExpanded()) {
                    this.collapse(hitItem, true);
                    break;
                }
                this.expand(hitItem, true);
                break;
            }
            case 2: {
                this.doMouseSelect(hitItem, hitItemIndex + this.getTopIndex(), event.stateMask, event.button);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                this.doCheckItem(hitItem);
            }
        }
        if (var5_5 != 2 && selectionItem == null) {
            selectionItem = this.getRoot().getVisibleItem(this.getTopIndex());
            this.selectNotify(selectionItem);
        }
    }

    void paint(Event event) {
        int[] visibleRange = this.getIndexRange(event.getBounds());
        this.paintItems(event.gc, visibleRange[0], visibleRange[1] + 1);
    }

    void paintItems(GC gc, int topPaintIndex, int bottomPaintIndex) {
        int itemHeight = this.getItemHeight();
        for (int i = topPaintIndex; i <= bottomPaintIndex; ++i) {
            TreeItem visibleItem = this.getRoot().getVisibleItem(i + this.getTopIndex());
            if (visibleItem == null) continue;
            visibleItem.paint(gc, i * itemHeight);
        }
    }

    void redrawAfterModify(SelectableItem modifiedItem, int modifiedIndex) {
        int itemChildIndex = ((TreeItem)modifiedItem).getIndex();
        int topIndex = this.getTopIndex();
        int itemHeight = this.getItemHeight();
        AbstractTreeItem parentItem = ((TreeItem)modifiedItem).getParentItem();
        AbstractTreeItem redrawItem = null;
        if (!this.redrawParentItem(modifiedItem)) {
            return;
        }
        if (parentItem == null) {
            parentItem = this.getRoot();
        }
        int itemCount = parentItem.getItemCount();
        if (itemChildIndex > 0) {
            if (itemChildIndex >= itemCount - 1) {
                redrawItem = (AbstractTreeItem)parentItem.getChildren().elementAt(itemChildIndex - 1);
            }
        } else if (this.getVisibleItemCount() > 0 && itemCount < 2) {
            redrawItem = parentItem;
        }
        if (redrawItem != null) {
            int redrawItemIndex = redrawItem.getVisibleIndex();
            if (modifiedIndex == -1) {
                modifiedIndex = redrawItemIndex + 1;
            }
            int redrawStartY = (redrawItemIndex - topIndex) * itemHeight;
            int redrawStopY = (modifiedIndex - topIndex) * itemHeight;
            this.redraw(0, redrawStartY, redrawItem.getCheckboxXPosition(), redrawStopY - redrawStartY, false);
        }
        if (modifiedIndex == 0) {
            this.redraw(0, 0, this.getClientArea().width, this.getItemHeight() * 2, false);
        }
    }

    boolean redrawParentItem(SelectableItem item) {
        TreeItem parentItem2;
        TreeItem parentItem = ((TreeItem)item).getParentItem();
        boolean redraw = false;
        if (parentItem != null && ((parentItem2 = parentItem.getParentItem()) == null || parentItem2.getExpanded()) && parentItem.getChildren().size() < 2) {
            redraw = true;
        }
        redraw = !this.isExpandingItem(item) && parentItem == null || parentItem.getExpanded() || redraw;
        return redraw;
    }

    public void removeAll() {
        this.checkWidget();
        this.setRedraw(false);
        this.getRoot().dispose();
        this.resetRoot();
        this.reset();
        this.calculateWidestShowingItem();
        this.calculateVerticalScrollbar();
        this.setRedraw(true);
    }

    void removeItem(TreeItem item) {
        this.getRoot().removeItem(item);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(17, listener);
        this.removeListener(18, listener);
    }

    void removedItem(SelectableItem item) {
        if (!this.isExpandingItem(item)) {
            super.removedItem(item);
        }
        this.calculateWidestShowingItem();
        this.claimRightFreeSpace();
    }

    void removingItem(SelectableItem item) {
        Vector selection = this.getSelectionVector();
        TreeItem parentItem = ((TreeItem)item).getParentItem();
        TreeItem newSelectionItem = null;
        boolean isLastSelected = selection.size() == 1 && selection.elementAt(0) == item;
        int itemIndex = this.getVisibleIndex(item);
        if (isLastSelected) {
            newSelectionItem = (TreeItem)this.getVisibleItem(itemIndex + 1);
            if (newSelectionItem == null || newSelectionItem.getParentItem() != parentItem) {
                newSelectionItem = parentItem;
            }
            if (newSelectionItem != null) {
                this.selectNotify(newSelectionItem, true);
            }
        }
        super.removingItem(item);
        if (!this.isExpandingItem(item)) {
            this.redrawAfterModify(item, itemIndex);
        }
    }

    void resetHierarchyIndicatorRect() {
        this.hierarchyIndicatorRect = null;
    }

    void resetItemData() {
        this.setContentWidth(0);
        this.resetHierarchyIndicatorRect();
        super.resetItemData();
    }

    void resetRoot() {
        this.root = new TreeRoots(this);
    }

    void resize(Event event) {
        int oldItemCount = this.getVerticalBar().getPageIncrement();
        super.resize(event);
        if (this.getItemCountWhole() > oldItemCount) {
            this.calculateWidestShowingItem();
        }
    }

    void scrollExpandedItemsIntoView(TreeItem item) {
        int itemCountOffScreen = this.getOffScreenItemCount(item);
        int newTopIndex = this.getTopIndex() + itemCountOffScreen;
        if (itemCountOffScreen > 0) {
            newTopIndex = Math.min(item.getVisibleIndex(), newTopIndex);
            this.setTopIndex(newTopIndex, true);
        }
    }

    void scrollForCollapse(TreeItem collapsedItem) {
        Rectangle clientArea = this.getClientArea();
        int topIndex = this.getTopIndex();
        int itemCount = collapsedItem.getVisibleItemCount();
        int[] scrollYPositions = this.calculateChildrenYPos(collapsedItem);
        if (scrollYPositions[0] == -1 && scrollYPositions[1] == -1) {
            return;
        }
        if (topIndex + this.getItemCountWhole() == this.getVisibleItemCount() && itemCount < topIndex) {
            int height = scrollYPositions[1] - scrollYPositions[0];
            this.scroll(0, 0, 0, -height, clientArea.width, scrollYPositions[0] + height, true);
            this.setTopIndexNoScroll(topIndex - itemCount, true);
        } else {
            this.scroll(0, scrollYPositions[0], 0, scrollYPositions[1], clientArea.width, clientArea.height - scrollYPositions[0], true);
        }
    }

    void scrollForExpand(TreeItem expandedItem) {
        Rectangle clientArea = this.getClientArea();
        expandedItem.internalSetExpanded(true);
        int[] scrollYPositions = this.calculateChildrenYPos(expandedItem);
        expandedItem.internalSetExpanded(false);
        if (scrollYPositions[0] == -1 && scrollYPositions[1] == -1) {
            return;
        }
        this.scroll(0, scrollYPositions[1], 0, scrollYPositions[0], clientArea.width, clientArea.height, true);
    }

    void scrollHorizontal(int numPixel) {
        Rectangle clientArea = this.getClientArea();
        this.scroll(numPixel, 0, 0, 0, clientArea.width, clientArea.height, true);
    }

    void scrollVertical(int scrollIndexCount) {
        Rectangle clientArea = this.getClientArea();
        this.scroll(0, 0, 0, scrollIndexCount * this.getItemHeight(), clientArea.width, clientArea.height, true);
    }

    public void selectAll() {
        this.checkWidget();
        Vector selection = this.getSelectionVector();
        if (this.isMultiSelect()) {
            selection = this.getRoot().selectAll(selection);
            this.setSelectionVector(selection);
        }
    }

    void setExpandingItem(TreeItem item) {
        this.expandingItem = item;
    }

    public void setFont(Font font) {
        int size;
        this.checkWidget();
        Vector children = new Vector();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        this.setRedraw(false);
        this.resetItemData();
        super.setFont(font);
        Enumeration elements = this.getRoot().getChildren().elements();
        while (elements.hasMoreElements()) {
            children.addElement(elements.nextElement());
        }
        while ((size = children.size()) != 0) {
            AbstractTreeItem item = (AbstractTreeItem)children.elementAt(size - 1);
            children.removeElementAt(size - 1);
            this.itemChanged(item, 0, this.getClientArea().width);
            elements = item.getChildren().elements();
            while (elements.hasMoreElements()) {
                children.addElement(elements.nextElement());
            }
        }
        this.setRedraw(true);
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
        this.motif_setInsertMark(item, !before);
    }

    public void setSelection(TreeItem[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        this.setSelectableSelection(items);
    }

    void setTopIndex(int index, boolean adjustScrollbar) {
        int indexDiff = index - this.getTopIndex();
        super.setTopIndex(index, adjustScrollbar);
        this.calculateWidestScrolledItem(indexDiff);
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (!item.isVisible()) {
            item.makeVisible();
        }
        this.scrollExpandedItemsIntoView(item);
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showSelectableItem(item);
    }

    void showSelectableItem(SelectableItem item) {
        if (item.getSelectableParent() != this) {
            return;
        }
        if (!((TreeItem)item).isVisible()) {
            ((TreeItem)item).makeVisible();
        }
        super.showSelectableItem(item);
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if (!this.getClientArea().contains(point)) {
            return null;
        }
        int itemHeight = this.getItemHeight();
        int hitItemIndex = point.y / itemHeight;
        TreeItem hitItem = this.getRoot().getVisibleItem(hitItemIndex + this.getTopIndex());
        if (hitItem != null) {
            Point pt = new Point(point.x, point.y);
            pt.x -= hitItem.getPaintStartX();
            pt.y -= itemHeight * hitItemIndex;
            if (!hitItem.isSelectionHit(pt)) {
                hitItem = null;
            }
        }
        return hitItem;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return super.getSelectionCount();
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        return (TreeItem)this.getVisibleItem(this.getTopIndex());
    }

    public void showSelection() {
        this.checkWidget();
        super.showSelection();
    }

    static {
        Tree.initializeImageData();
    }
}

