/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.search.IUpdateSiteAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpdatePolicy {
    private static final String TAG_POLICY = "update-policy";
    private static final String TAG_URL_MAP = "url-map";
    private static final String ATT_URL = "url";
    private static final String ATT_PATTERN = "pattern";
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private ArrayList entries = new ArrayList();
    private IUpdateSiteAdapter defaultSite;
    private boolean loaded = false;
    private boolean fallbackAllowed = true;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(URL mapFile, IProgressMonitor monitor) throws CoreException {
        block14: {
            block13: {
                policyStream = null;
                try {
                    try {
                        response = UpdateCore.getPlugin().get(mapFile);
                        UpdateManagerUtils.checkConnectionResult(response, mapFile);
                        policyStream = response.getInputStream(monitor);
                        if (policyStream == null) {
                            var8_8 = null;
                            if (policyStream == null) return;
                            break block13;
                        }
                        UpdatePolicy.documentBuilderFactory.setNamespaceAware(true);
                        parser = UpdatePolicy.documentBuilderFactory.newDocumentBuilder();
                        doc = parser.parse(new InputSource(policyStream));
                        this.processUpdatePolicy(doc);
                        this.loaded = true;
                        break block14;
                    }
                    catch (IOException e) {
                        if (mapFile == null) {
                            v0 = "";
                            throw Utilities.newCoreException(Policy.bind("SiteURLFactory.UnableToAccessSiteStream", v0), 42, e);
                        }
                        v0 = mapFile.toExternalForm();
                        throw Utilities.newCoreException(Policy.bind("SiteURLFactory.UnableToAccessSiteStream", v0), 42, e);
                    }
                    catch (SAXException e) {
                        throw Utilities.newCoreException(Policy.bind("UpdatePolicy.parsePolicy"), 0, e);
                    }
                    catch (ParserConfigurationException e) {
                        throw Utilities.newCoreException(Policy.bind("UpdatePolicy.parsePolicy"), 0, e);
                    }
                }
                catch (Throwable var7_16) {
                    var8_10 = null;
                    if (policyStream == null) throw var7_16;
                    try {
                        policyStream.close();
                        throw var7_16;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var7_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [9 : 151->158)] { 
lbl40:
            // 1 sources

            policyStream.close();
            return;
lbl42:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var8_9 = null;
        if (policyStream == null) return;
        try {}
        catch (IOException e) {}
        policyStream.close();
        return;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public IUpdateSiteAdapter getMappedSite(String id) {
        UpdateMapEntry lastEntry = null;
        for (int i = 0; i < this.entries.size(); ++i) {
            UpdateMapEntry entry = (UpdateMapEntry)this.entries.get(i);
            if (!entry.matches(id)) continue;
            if (lastEntry == null) {
                lastEntry = entry;
                continue;
            }
            String pattern = entry.getPattern();
            String lastPattern = lastEntry.getPattern();
            if (pattern.length() <= lastPattern.length()) continue;
            lastEntry = entry;
        }
        if (lastEntry != null) {
            return lastEntry.getSite();
        }
        return this.defaultSite;
    }

    public boolean isFallbackAllowed() {
        return this.fallbackAllowed;
    }

    private void reset() {
        if (!this.entries.isEmpty()) {
            this.entries.clear();
        }
    }

    private void processUpdatePolicy(Document document) throws CoreException {
        Element root = document.getDocumentElement();
        this.reset();
        if (!root.getNodeName().equals(TAG_POLICY)) {
            this.throwCoreException("'update-policy" + Policy.bind("UpdatePolicy.policyExpected"), null);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String tag;
            Node child = nodes.item(i);
            if (child.getNodeType() != 1 || !(tag = child.getNodeName()).equals(TAG_URL_MAP)) continue;
            this.processMapNode(child);
        }
    }

    private void processMapNode(Node node) throws CoreException {
        String pattern = this.getAttribute(node, ATT_PATTERN);
        String urlName = this.getAttribute(node, ATT_URL);
        this.assertNotNull(ATT_PATTERN, pattern);
        this.assertNotNull(ATT_URL, urlName);
        if (urlName.trim().length() == 0) {
            this.addEntry(pattern, null);
            return;
        }
        try {
            String decodedValue = URLDecoder.decode(urlName, "UTF-8");
            URL url = new URL(decodedValue);
            this.addEntry(pattern, url);
        }
        catch (MalformedURLException e) {
            this.throwCoreException(Policy.bind("UpdatePolicy.invalidURL") + urlName, null);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    private void assertNotNull(String name, String value) throws CoreException {
        if (value == null) {
            this.throwCoreException(name + Policy.bind("UpdatePolicy.nameNoNull"), null);
        }
    }

    private String getAttribute(Node node, String name) {
        NamedNodeMap attMap = node.getAttributes();
        Node att = attMap.getNamedItem(name);
        if (att == null) {
            return null;
        }
        return att.getNodeValue();
    }

    private void addEntry(String pattern, URL url) {
        if (pattern.equalsIgnoreCase("*")) {
            this.defaultSite = new MapSite(url);
        } else {
            this.entries.add(new UpdateMapEntry(pattern, url));
        }
    }

    private void throwCoreException(String message, Throwable e) throws CoreException {
        String fullMessage = Policy.bind("UpdatePolicy.UpdatePolicy") + message;
        throw Utilities.newCoreException(fullMessage, 0, e);
    }

    private static class UpdateMapEntry {
        private IUpdateSiteAdapter site;
        private String pattern;

        public UpdateMapEntry(String pattern, URL url) {
            this.pattern = pattern;
            this.site = new MapSite(url);
        }

        public IUpdateSiteAdapter getSite() {
            return this.site;
        }

        public boolean matches(String id) {
            return id.startsWith(this.pattern);
        }

        public String getPattern() {
            return this.pattern;
        }
    }

    private static class MapSite
    implements IUpdateSiteAdapter {
        private URL url;

        public MapSite(URL url) {
            this.url = url;
        }

        public String getLabel() {
            return this.url.toString();
        }

        public URL getURL() {
            return this.url;
        }
    }
}

