/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DiffImage;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.Diff;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

class PreviewPatchPage
extends WizardPage {
    private PatchWizard fPatchWizard;
    private Tree fTree;
    private Combo fStripPrefixSegments;
    private CompareViewerSwitchingPane fHunkViewer;
    private Button fIgnoreWhitespaceButton;
    private Button fReversePatchButton;
    private Text fFuzzField;
    private Image[] fImages = new Image[6];
    private CompareConfiguration fCompareConfiguration;

    PreviewPatchPage(PatchWizard pw) {
        super("PreviewPatchPage", PatchMessages.getString("PreviewPatchPage.title"), null);
        this.setMessage(PatchMessages.getString("PreviewPatchPage.message"));
        this.fPatchWizard = pw;
        int w = 16;
        ImageDescriptor addId = CompareUIPlugin.getImageDescriptor("ovr16/add_ov.gif");
        ImageDescriptor delId = CompareUIPlugin.getImageDescriptor("ovr16/del_ov.gif");
        ImageDescriptor errId = CompareUIPlugin.getImageDescriptor("ovr16/error_ov.gif");
        Image errIm = errId.createImage();
        this.fImages[0] = new DiffImage(null, null, w).createImage();
        this.fImages[1] = new DiffImage(null, addId, w).createImage();
        this.fImages[2] = new DiffImage(null, delId, w).createImage();
        this.fImages[3] = new DiffImage(errIm, null, w).createImage();
        this.fImages[4] = new DiffImage(errIm, addId, w).createImage();
        this.fImages[5] = new DiffImage(errIm, delId, w).createImage();
        this.fCompareConfiguration = new CompareConfiguration();
        this.fCompareConfiguration.setLeftEditable(false);
        this.fCompareConfiguration.setLeftLabel(PatchMessages.getString("PreviewPatchPage.Left.title"));
        this.fCompareConfiguration.setRightEditable(false);
        this.fCompareConfiguration.setRightLabel(PatchMessages.getString("PreviewPatchPage.Right.title"));
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.buildTree();
        }
        super.setVisible(visible);
    }

    Image getImage(Diff diff) {
        if (diff.fMatches) {
            switch (diff.getType()) {
                case 1: {
                    return this.fImages[1];
                }
                case 2: {
                    return this.fImages[2];
                }
            }
            return this.fImages[0];
        }
        switch (diff.getType()) {
            case 1: {
                return this.fImages[4];
            }
            case 2: {
                return this.fImages[5];
            }
        }
        return this.fImages[3];
    }

    Image getImage(Hunk hunk) {
        if (hunk.fMatches) {
            return this.fImages[0];
        }
        return this.fImages[3];
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.compare.patch_preview_wizard_page_context");
        this.setControl((Control)composite);
        this.buildPatchOptionsGroup(composite);
        Splitter splitter = new Splitter(composite, 512);
        splitter.setLayoutData(new GridData(1808));
        this.fTree = new Tree((Composite)splitter, 2848);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.fTree.setLayoutData((Object)gd);
        this.fHunkViewer = new CompareViewerSwitchingPane((Composite)splitter, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                return CompareUI.findContentViewer(oldViewer, (ICompareInput)input, (Composite)this, PreviewPatchPage.this.fCompareConfiguration);
            }
        };
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.fHunkViewer.setLayoutData(gd);
        this.fTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem ti = (TreeItem)e.item;
                Object data = e.item.getData();
                if (e.detail == 32) {
                    boolean checked = ti.getChecked();
                    if (data instanceof Hunk) {
                        Hunk hunk = (Hunk)data;
                        checked = checked && hunk.fMatches;
                        ti.setChecked(checked);
                        PreviewPatchPage.this.updateGrayedState(ti);
                    } else if (data instanceof Diff) {
                        PreviewPatchPage.this.updateCheckedState(ti);
                    }
                } else if (data instanceof Hunk) {
                    PreviewPatchPage.this.fHunkViewer.setInput(PreviewPatchPage.this.createInput((Hunk)data));
                } else {
                    PreviewPatchPage.this.fHunkViewer.setInput(null);
                }
            }
        });
        this.fTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PreviewPatchPage.this.fImages != null) {
                    for (int i = 0; i < PreviewPatchPage.this.fImages.length; ++i) {
                        if (PreviewPatchPage.this.fImages[i] != null) continue;
                        PreviewPatchPage.this.fImages[i].dispose();
                    }
                    PreviewPatchPage.access$402(PreviewPatchPage.this, null);
                }
            }
        });
        this.buildTree();
        Dialog.applyDialogFont((Control)composite);
    }

    private void buildPatchOptionsGroup(Composite parent) {
        final Patcher patcher = this.fPatchWizard.getPatcher();
        Group group = new Group(parent, 0);
        group.setText(PatchMessages.getString("PreviewPatchPage.PatchOptions.title"));
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        gl.marginHeight = 0;
        group.setLayout((Layout)gl);
        group.setLayoutData((Object)new GridData(768));
        Composite pair = new Composite((Composite)group, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        pair.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        pair.setLayoutData((Object)gd);
        Label l = new Label(pair, 0);
        l.setText(PatchMessages.getString("PreviewPatchPage.IgnoreSegments.text"));
        gd = new GridData(548);
        l.setLayoutData((Object)gd);
        this.fStripPrefixSegments = new Combo(pair, 76);
        int prefixCnt = patcher.getStripPrefixSegments();
        String prefix = Integer.toString(prefixCnt);
        this.fStripPrefixSegments.add(prefix);
        this.fStripPrefixSegments.setText(prefix);
        gd = new GridData(132);
        this.fStripPrefixSegments.setLayoutData((Object)gd);
        this.addSpacer((Composite)group);
        this.fReversePatchButton = new Button((Composite)group, 32);
        this.fReversePatchButton.setText(PatchMessages.getString("PreviewPatchPage.ReversePatch.text"));
        this.addSpacer((Composite)group);
        pair = new Composite((Composite)group, 0);
        gl = new GridLayout();
        gl.numColumns = 3;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        pair.setLayout((Layout)gl);
        gd = new GridData(256);
        pair.setLayoutData((Object)gd);
        l = new Label(pair, 0);
        l.setText(PatchMessages.getString("PreviewPatchPage.FuzzFactor.text"));
        l.setToolTipText(PatchMessages.getString("PreviewPatchPage.FuzzFactor.tooltip"));
        gd = new GridData(548);
        l.setLayoutData((Object)gd);
        this.fFuzzField = new Text(pair, 2048);
        this.fFuzzField.setText("2");
        gd = new GridData(132);
        gd.widthHint = 30;
        this.fFuzzField.setLayoutData((Object)gd);
        Button b = new Button(pair, 8);
        b.setText(PatchMessages.getString("PreviewPatchPage.GuessFuzz.text"));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fuzz = PreviewPatchPage.this.guessFuzzFactor(patcher);
                if (fuzz >= 0) {
                    PreviewPatchPage.this.fFuzzField.setText(Integer.toString(fuzz));
                }
            }
        });
        gd = new GridData(4);
        b.setLayoutData((Object)gd);
        this.addSpacer((Composite)group);
        this.fIgnoreWhitespaceButton = new Button((Composite)group, 32);
        this.fIgnoreWhitespaceButton.setText(PatchMessages.getString("PreviewPatchPage.IgnoreWhitespace.text"));
        this.addSpacer((Composite)group);
        if (this.fStripPrefixSegments != null) {
            this.fStripPrefixSegments.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (patcher.setStripPrefixSegments(PreviewPatchPage.this.getStripPrefixSegments())) {
                        PreviewPatchPage.this.updateTree();
                    }
                }
            });
        }
        this.fReversePatchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (patcher.setReversed(PreviewPatchPage.this.fReversePatchButton.getSelection())) {
                    PreviewPatchPage.this.updateTree();
                }
            }
        });
        this.fIgnoreWhitespaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (patcher.setIgnoreWhitespace(PreviewPatchPage.this.fIgnoreWhitespaceButton.getSelection())) {
                    PreviewPatchPage.this.updateTree();
                }
            }
        });
        this.fFuzzField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (patcher.setFuzz(PreviewPatchPage.this.getFuzzFactor())) {
                    PreviewPatchPage.this.updateTree();
                }
            }
        });
    }

    private int guessFuzzFactor(final Patcher patcher) {
        final int strip = this.getStripPrefixSegments();
        final int[] result = new int[1];
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    result[0] = PreviewPatchPage.this.guess(patcher, monitor, strip);
                }
            });
            return result[0];
        }
        catch (InvocationTargetException ex) {
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int guess(Patcher patcher, IProgressMonitor pm, int strip) {
        Diff[] diffs = patcher.getDiffs();
        if (diffs == null || diffs.length <= 0) {
            return -1;
        }
        IFile[] files = new IFile[diffs.length];
        int work = 0;
        for (int i = 0; i < diffs.length; ++i) {
            IFile file;
            Diff diff = diffs[i];
            if (diff == null || diff.getType() == 1) continue;
            IPath p = diff.fOldPath;
            if (strip > 0 && strip < p.segmentCount()) {
                p = p.removeFirstSegments(strip);
            }
            if ((file = this.existsInSelection(p)) == null) continue;
            files[i] = file;
            work += diff.fHunks.size();
        }
        int[] fuzzRef = new int[1];
        String format = PatchMessages.getString("PreviewPatchPage.GuessFuzzProgress.format");
        pm.beginTask(PatchMessages.getString("PreviewPatchPage.GuessFuzzProgress.text"), work);
        try {
            int fuzz = 0;
            for (int i = 0; i < diffs.length; ++i) {
                Diff d = diffs[i];
                IFile file = files[i];
                if (d == null || file == null) continue;
                List lines = patcher.load(file, false);
                String name = d.getPath().lastSegment();
                Iterator iter = d.fHunks.iterator();
                int shift = 0;
                int hcnt = 1;
                while (iter.hasNext()) {
                    pm.subTask(MessageFormat.format(format, name, Integer.toString(hcnt)));
                    Hunk h = (Hunk)iter.next();
                    shift = patcher.calculateFuzz(h, lines, shift, pm, fuzzRef);
                    int f = fuzzRef[0];
                    if (f == -1) {
                        int n = -1;
                        return n;
                    }
                    if (f > fuzz) {
                        fuzz = f;
                    }
                    pm.worked(1);
                    ++hcnt;
                }
            }
            int n = fuzz;
            return n;
        }
        finally {
            pm.done();
        }
    }

    ICompareInput createInput(Hunk hunk) {
        String[] lines = hunk.fLines;
        StringBuffer left = new StringBuffer();
        StringBuffer right = new StringBuffer();
        block5: for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String rest = line.substring(1);
            switch (line.charAt(0)) {
                case ' ': {
                    left.append(rest);
                    right.append(rest);
                    continue block5;
                }
                case '-': {
                    left.append(rest);
                    continue block5;
                }
                case '+': {
                    right.append(rest);
                }
            }
        }
        Diff diff = hunk.fParent;
        IPath path = diff.getPath();
        String type = path.getFileExtension();
        return new DiffNode(new HunkInput(type, left.toString()), new HunkInput(type, right.toString()));
    }

    private void buildTree() {
        this.setPageComplete(true);
        if (this.fTree != null && !this.fTree.isDisposed()) {
            int i;
            this.fTree.removeAll();
            this.fHunkViewer.setInput(null);
            int length = 99;
            Diff[] diffs = this.fPatchWizard.getPatcher().getDiffs();
            if (diffs != null) {
                for (i = 0; i < diffs.length; ++i) {
                    Diff diff = diffs[i];
                    TreeItem d = new TreeItem(this.fTree, 0);
                    d.setData((Object)diff);
                    d.setImage(this.getImage(diff));
                    if (diff.fOldPath != null) {
                        length = Math.min(length, diff.fOldPath.segmentCount());
                    }
                    if (diff.fNewPath != null) {
                        length = Math.min(length, diff.fNewPath.segmentCount());
                    }
                    List hunks = diff.fHunks;
                    Iterator iter = hunks.iterator();
                    while (iter.hasNext()) {
                        Hunk hunk = (Hunk)iter.next();
                        TreeItem h = new TreeItem(d, 0);
                        h.setData((Object)hunk);
                        h.setText(hunk.getDescription());
                    }
                }
            }
            if (this.fStripPrefixSegments != null && length != 99) {
                for (i = 1; i < length; ++i) {
                    this.fStripPrefixSegments.add(Integer.toString(i));
                }
            }
        }
        this.updateTree();
    }

    private IFile existsInSelection(IPath path) {
        IContainer c;
        IResource target = this.fPatchWizard.getTarget();
        if (target instanceof IFile) {
            IFile file = (IFile)target;
            if (this.matches(file.getFullPath(), path)) {
                return file;
            }
        } else if (target instanceof IContainer && (c = (IContainer)target).exists(path)) {
            return c.getFile(path);
        }
        return null;
    }

    private boolean matches(IPath fullpath, IPath path) {
        IPath p = fullpath;
        while (path.segmentCount() <= p.segmentCount()) {
            if (p.equals(path)) {
                return true;
            }
            p = p.removeFirstSegments(1);
        }
        return false;
    }

    private void updateTree() {
        if (this.fTree == null || this.fTree.isDisposed()) {
            return;
        }
        int strip = this.getStripPrefixSegments();
        TreeItem[] children = this.fTree.getItems();
        for (int i = 0; i < children.length; ++i) {
            IPath p;
            TreeItem item = children[i];
            Diff diff = (Diff)item.getData();
            diff.fMatches = false;
            String error = null;
            boolean create = false;
            IFile file = null;
            if (diff.getType() == 1) {
                p = diff.fNewPath;
                if (strip > 0 && strip < p.segmentCount()) {
                    p = p.removeFirstSegments(strip);
                }
                if ((file = this.existsInSelection(p)) == null) {
                    diff.fMatches = true;
                } else {
                    error = PatchMessages.getString("PreviewPatchPage.FileExists.error");
                }
                create = true;
            } else {
                p = diff.fOldPath;
                if (strip > 0 && strip < p.segmentCount()) {
                    p = p.removeFirstSegments(strip);
                }
                file = this.existsInSelection(p);
                diff.fMatches = false;
                if (file != null) {
                    if (file.isReadOnly()) {
                        error = PatchMessages.getString("PreviewPatchPage.FileIsReadOnly.error");
                        file = null;
                    } else {
                        diff.fMatches = true;
                    }
                } else {
                    error = PatchMessages.getString("PreviewPatchPage.FileDoesNotExist.error");
                }
            }
            ArrayList failedHunks = new ArrayList();
            Patcher patcher = this.fPatchWizard.getPatcher();
            patcher.setFuzz(this.getFuzzFactor());
            patcher.apply(diff, file, create, failedHunks);
            if (failedHunks.size() > 0) {
                diff.fRejected = this.fPatchWizard.getPatcher().getRejected(failedHunks);
            }
            int checkedSubs = 0;
            TreeItem[] hunkItems = item.getItems();
            for (int h = 0; h < hunkItems.length; ++h) {
                Hunk hunk = (Hunk)hunkItems[h].getData();
                boolean failed = failedHunks.contains(hunk);
                String hunkError = null;
                if (failed) {
                    hunkError = PatchMessages.getString("PreviewPatchPage.NoMatch.error");
                }
                boolean check = !failed;
                hunkItems[h].setChecked(check);
                if (check) {
                    ++checkedSubs;
                }
                String hunkLabel = hunk.getDescription();
                if (hunkError != null) {
                    hunkLabel = hunkLabel + "   " + hunkError;
                }
                hunkItems[h].setText(hunkLabel);
                hunkItems[h].setImage(this.getImage(hunk));
            }
            String label = diff.getDescription(strip);
            if (error != null) {
                label = label + "    " + error;
            }
            item.setText(label);
            item.setImage(this.getImage(diff));
            item.setChecked(checkedSubs > 0);
            boolean gray = checkedSubs > 0 && checkedSubs < hunkItems.length;
            item.setGrayed(gray);
            item.setExpanded(gray);
        }
        this.setPageComplete(this.updateModel());
    }

    private void updateCheckedState(TreeItem diffItem) {
        boolean checked = diffItem.getChecked();
        TreeItem[] hunks = diffItem.getItems();
        int checkedCount = 0;
        for (int i = 0; i < hunks.length; ++i) {
            Hunk hunk = (Hunk)hunks[i].getData();
            if (checked) {
                if (!hunk.fMatches) continue;
                hunks[i].setChecked(true);
                ++checkedCount;
                continue;
            }
            hunks[i].setChecked(false);
        }
        diffItem.setGrayed(checkedCount > 0 && checkedCount < hunks.length);
        diffItem.setChecked(checkedCount > 0);
        this.setPageComplete(this.updateModel());
    }

    private void updateGrayedState(TreeItem hunk) {
        TreeItem diff = hunk.getParentItem();
        TreeItem[] hunks = diff.getItems();
        int checked = 0;
        for (int i = 0; i < hunks.length; ++i) {
            if (!hunks[i].getChecked()) continue;
            ++checked;
        }
        diff.setChecked(checked > 0);
        diff.setGrayed(checked > 0 && checked < hunks.length);
        this.setPageComplete(this.updateModel());
    }

    private void addSpacer(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData(768);
        gd.widthHint = 20;
        label.setLayoutData((Object)gd);
    }

    private int getStripPrefixSegments() {
        int stripPrefixSegments = 0;
        if (this.fStripPrefixSegments != null) {
            String s = this.fStripPrefixSegments.getText();
            try {
                stripPrefixSegments = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return stripPrefixSegments;
    }

    private int getFuzzFactor() {
        int fuzzFactor = 0;
        if (this.fFuzzField != null) {
            String s = this.fFuzzField.getText();
            try {
                fuzzFactor = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fuzzFactor;
    }

    public boolean updateModel() {
        boolean atLeastOneIsEnabled = false;
        if (this.fTree != null && !this.fTree.isDisposed()) {
            TreeItem[] diffItems = this.fTree.getItems();
            for (int i = 0; i < diffItems.length; ++i) {
                TreeItem diffItem = diffItems[i];
                Object data = diffItem.getData();
                if (!(data instanceof Diff)) continue;
                Diff diff = (Diff)data;
                boolean b = diffItem.getChecked();
                diff.setEnabled(b);
                if (!b) continue;
                TreeItem[] hunkItems = diffItem.getItems();
                for (int j = 0; j < hunkItems.length; ++j) {
                    TreeItem hunkItem = hunkItems[j];
                    data = hunkItem.getData();
                    if (!(data instanceof Hunk)) continue;
                    Hunk hunk = (Hunk)data;
                    b = hunkItem.getChecked();
                    hunk.setEnabled(b);
                    if (!b) continue;
                    atLeastOneIsEnabled = true;
                }
            }
        }
        return atLeastOneIsEnabled;
    }

    static /* synthetic */ Image[] access$402(PreviewPatchPage x0, Image[] x1) {
        x0.fImages = x1;
        return x1;
    }

    static class HunkInput
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        static final String UTF_16 = "UTF-16";
        String fContent;
        String fType;

        HunkInput(String type, String s) {
            this.fType = type;
            this.fContent = s;
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return PatchMessages.getString("PreviewPatchPage.NoName.text");
        }

        public String getType() {
            return this.fType;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(Utilities.getBytes(this.fContent, UTF_16));
        }

        public String getCharset() {
            return UTF_16;
        }
    }
}

