/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.SourceElementRequestorAdapter;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.util.Util;

class BinaryMethod
extends BinaryMember
implements IMethod {
    protected String[] parameterTypes;
    protected String[] parameterNames;
    protected static final String[] NO_TYPES = new String[0];
    protected String[] exceptionTypes;
    protected String returnType;

    protected BinaryMethod(JavaElement parent, String name, String[] paramTypes) {
        super(parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
        this.parameterTypes = paramTypes == null ? NO_TYPES : paramTypes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinaryMethod)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull(this.parameterTypes, ((BinaryMethod)o).parameterTypes);
    }

    public String[] getExceptionTypes() throws JavaModelException {
        if (this.exceptionTypes == null) {
            IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
            char[][] eTypeNames = info.getExceptionTypeNames();
            if (eTypeNames == null || eTypeNames.length == 0) {
                this.exceptionTypes = NO_TYPES;
            } else {
                eTypeNames = ClassFile.translatedNames(eTypeNames);
                this.exceptionTypes = new String[eTypeNames.length];
                int length = eTypeNames.length;
                for (int j = 0; j < length; ++j) {
                    int nameLength = eTypeNames[j].length;
                    char[] convertedName = new char[nameLength + 2];
                    System.arraycopy(eTypeNames[j], 0, convertedName, 1, nameLength);
                    convertedName[0] = 76;
                    convertedName[nameLength + 1] = 59;
                    this.exceptionTypes[j] = new String(convertedName);
                }
            }
        }
        return this.exceptionTypes;
    }

    public int getElementType() {
        return 9;
    }

    public int getFlags() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.getModifiers();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            buff.append(delimiter);
            buff.append(this.parameterTypes[i]);
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
        return buff.toString();
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    public String[] getParameterNames() throws JavaModelException {
        if (this.parameterNames == null) {
            IType type = (IType)this.getParent();
            SourceMapper mapper = this.getSourceMapper();
            if (mapper != null) {
                char[][] paramNames = mapper.getMethodParameterNames(this);
                if (paramNames == null) {
                    char[] source = mapper.findSource(type);
                    if (source != null) {
                        mapper.mapSource(type, source);
                    }
                    paramNames = mapper.getMethodParameterNames(this);
                }
                if (paramNames != null) {
                    this.parameterNames = new String[paramNames.length];
                    for (int i = 0; i < paramNames.length; ++i) {
                        this.parameterNames[i] = new String(paramNames[i]);
                    }
                }
            }
            if (this.parameterNames == null) {
                IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
                int paramCount = Signature.getParameterCount(new String(info.getMethodDescriptor()));
                this.parameterNames = new String[paramCount];
                for (int i = 0; i < paramCount; ++i) {
                    this.parameterNames[i] = "arg" + i;
                }
            }
        }
        return this.parameterNames;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        return new String[0];
    }

    public String getReturnType() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        if (this.returnType == null) {
            String returnTypeName = Signature.getReturnType(new String(info.getMethodDescriptor()));
            this.returnType = new String(ClassFile.translatedName(returnTypeName.toCharArray()));
        }
        return this.returnType;
    }

    public String getSignature() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return new String(info.getMethodDescriptor());
    }

    public int hashCode() {
        int hash = super.hashCode();
        int length = this.parameterTypes.length;
        for (int i = 0; i < length; ++i) {
            hash = Util.combineHashCodes(hash, this.parameterTypes[i].hashCode());
        }
        return hash;
    }

    public boolean isConstructor() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    public boolean isSimilar(IMethod method) {
        return this.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append("(");
        String[] paramTypes = this.parameterTypes;
        if (paramTypes != null && (length = paramTypes.length) > 0) {
            for (int i = 0; i < length; ++i) {
                buffer.append(Signature.toString(paramTypes[i]));
                if (i >= length - 1) continue;
                buffer.append(", ");
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                if (!this.isConstructor()) {
                    buffer.append(Signature.toString(this.getReturnType()));
                    buffer.append(' ');
                }
                this.toStringName(buffer);
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    protected void toStringName(StringBuffer buffer) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            for (int i = 0; i < length; ++i) {
                buffer.append(Signature.toString(parameters[i]));
                if (i >= length - 1) continue;
                buffer.append(", ");
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }

    class DecodeParametersNames
    extends SourceElementRequestorAdapter {
        String[] parametersNames;

        DecodeParametersNames() {
        }

        public void enterMethod(int declarationStart, int modifiers, char[] returnTypeName, char[] selector, int nameSourceStart, int nameSourceEnd, char[][] paramTypes, char[][] paramNames, char[][] exceptions) {
            if (paramNames != null) {
                int length = paramNames.length;
                this.parametersNames = new String[length];
                for (int i = 0; i < length; ++i) {
                    this.parametersNames[i] = new String(paramNames[i]);
                }
            }
        }

        public void enterConstructor(int declarationStart, int modifiers, char[] selector, int nameSourceStart, int nameSourceEnd, char[][] paramTypes, char[][] paramNames, char[][] exceptions) {
            if (paramNames != null) {
                int length = paramNames.length;
                this.parametersNames = new String[length];
                for (int i = 0; i < length; ++i) {
                    this.parametersNames[i] = new String(paramNames[i]);
                }
            }
        }

        public String[] getParametersNames() {
            return this.parametersNames;
        }
    }
}

