/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ProjectNatureDescriptor;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class NatureManager
implements ILifecycleListener,
IManager {
    protected Map descriptors;
    protected Map natureEnablements;
    protected Map buildersToNatures = null;
    private static final byte WHITE = 0;
    private static final byte GREY = 1;
    private static final byte BLACK = 2;

    protected NatureManager() {
    }

    protected String[] computeNatureEnablements(Project project) {
        String[] natureIds = project.internalGetDescription().getNatureIds();
        int count = natureIds.length;
        if (count == 0) {
            return natureIds;
        }
        HashSet<String> candidates = new HashSet<String>(count * 2);
        HashMap<String, ArrayList<String>> setsToNatures = new HashMap<String, ArrayList<String>>(count);
        for (int i = 0; i < count; ++i) {
            String id = natureIds[i];
            ProjectNatureDescriptor desc = (ProjectNatureDescriptor)this.getNatureDescriptor(id);
            if (desc == null) continue;
            if (!desc.hasCycle) {
                candidates.add(id);
            }
            String[] setIds = desc.getNatureSetIds();
            for (int j = 0; j < setIds.length; ++j) {
                String set = setIds[j];
                ArrayList<String> current = (ArrayList<String>)setsToNatures.get(set);
                if (current == null) {
                    current = new ArrayList<String>(5);
                    setsToNatures.put(set, current);
                }
                current.add(id);
            }
        }
        Iterator it = setsToNatures.values().iterator();
        while (it.hasNext()) {
            ArrayList setMembers = (ArrayList)it.next();
            if (setMembers.size() <= 1) continue;
            candidates.removeAll(setMembers);
        }
        String[] orderedCandidates = candidates.toArray(new String[candidates.size()]);
        orderedCandidates = this.sortNatureSet(orderedCandidates);
        block3: for (int i = 0; i < orderedCandidates.length; ++i) {
            String id = orderedCandidates[i];
            IProjectNatureDescriptor desc = this.getNatureDescriptor(id);
            String[] required = desc.getRequiredNatureIds();
            for (int j = 0; j < required.length; ++j) {
                if (candidates.contains(required[j])) continue;
                candidates.remove(id);
                continue block3;
            }
        }
        return candidates.toArray(new String[candidates.size()]);
    }

    public IProjectNatureDescriptor getNatureDescriptor(String natureId) {
        this.lazyInitialize();
        return (IProjectNatureDescriptor)this.descriptors.get(natureId);
    }

    public IProjectNatureDescriptor[] getNatureDescriptors() {
        this.lazyInitialize();
        Collection values = this.descriptors.values();
        return values.toArray(new IProjectNatureDescriptor[values.size()]);
    }

    public void handleEvent(LifecycleEvent event) {
        switch (event.kind) {
            case 1: 
            case 2: 
            case 16: 
            case 32: 
            case 64: {
                this.flushEnablements((IProject)event.resource);
            }
        }
    }

    protected void configureNature(final Project project, final String natureID, final MultiStatus errors) {
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                IProjectNature nature = NatureManager.this.createNature(project, natureID);
                nature.configure();
                ProjectInfo info = (ProjectInfo)project.getResourceInfo(false, true);
                info.setNature(natureID, nature);
            }

            public void handleException(Throwable exception) {
                if (exception instanceof CoreException) {
                    errors.add(((CoreException)exception).getStatus());
                } else {
                    errors.add((IStatus)new ResourceStatus(566, project.getFullPath(), Policy.bind("resources.errorNature", natureID), exception));
                }
            }
        };
        if (Policy.DEBUG_NATURES) {
            System.out.println("Configuring nature: " + natureID + " on project: " + project.getName());
        }
        Platform.run((ISafeRunnable)code);
    }

    public void configureNatures(Project project, ProjectDescription oldDescription, ProjectDescription newDescription, MultiStatus status) {
        int i;
        HashSet<String> newNatures;
        HashSet<String> oldNatures = new HashSet<String>(Arrays.asList(oldDescription.getNatureIds(false)));
        if (oldNatures.equals(newNatures = new HashSet<String>(Arrays.asList(newDescription.getNatureIds(false))))) {
            return;
        }
        HashSet deletions = (HashSet)oldNatures.clone();
        HashSet additions = (HashSet)newNatures.clone();
        additions.removeAll(oldNatures);
        deletions.removeAll(newNatures);
        IStatus result = this.validateAdditions(newNatures, additions, project);
        if (!result.isOK()) {
            status.merge(result);
            return;
        }
        result = this.validateRemovals(newNatures, deletions);
        if (!result.isOK()) {
            status.merge(result);
            return;
        }
        oldDescription.setNatureIds(newDescription.getNatureIds(true));
        this.flushEnablements(project);
        String[] ordered = null;
        if (deletions.size() > 0) {
            ordered = this.sortNatureSet(deletions.toArray(new String[deletions.size()]));
            i = ordered.length;
            while (--i >= 0) {
                this.deconfigureNature(project, ordered[i], status);
            }
        }
        if (additions.size() > 0) {
            ordered = this.sortNatureSet(additions.toArray(new String[additions.size()]));
            for (i = 0; i < ordered.length; ++i) {
                this.configureNature(project, ordered[i], status);
            }
        }
    }

    protected IProjectNature createNature(Project project, String natureID) throws CoreException {
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "natures", natureID);
        if (extension == null) {
            String message = Policy.bind("resources.natureExtension", natureID);
            throw new ResourceException(2, project.getFullPath(), message, null);
        }
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length < 1) {
            String message = Policy.bind("resources.natureClass", natureID);
            throw new ResourceException(2, project.getFullPath(), message, null);
        }
        IConfigurationElement config = null;
        for (int i = 0; config == null && i < configs.length; ++i) {
            if (!"runtime".equalsIgnoreCase(configs[i].getName())) continue;
            config = configs[i];
        }
        if (config == null) {
            String message = Policy.bind("resources.natureFormat", natureID);
            throw new ResourceException(2, project.getFullPath(), message, null);
        }
        try {
            IProjectNature nature = (IProjectNature)config.createExecutableExtension("run");
            nature.setProject(project);
            return nature;
        }
        catch (ClassCastException e) {
            String message = Policy.bind("resources.natureImplement", natureID);
            throw new ResourceException(2, project.getFullPath(), message, e);
        }
    }

    protected void deconfigureNature(final Project project, final String natureID, final MultiStatus status) {
        final ProjectInfo info = (ProjectInfo)project.getResourceInfo(false, true);
        IProjectNature existingNature = info.getNature(natureID);
        if (existingNature == null) {
            try {
                existingNature = this.createNature(project, natureID);
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                return;
            }
        }
        final IProjectNature nature = existingNature;
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                nature.deconfigure();
                info.setNature(natureID, null);
            }

            public void handleException(Throwable exception) {
                if (exception instanceof CoreException) {
                    status.add(((CoreException)exception).getStatus());
                } else {
                    status.add((IStatus)new ResourceStatus(566, project.getFullPath(), Policy.bind("resources.natureDeconfig", natureID), exception));
                }
            }
        };
        if (Policy.DEBUG_NATURES) {
            System.out.println("Deconfiguring nature: " + natureID + " on project: " + project.getName());
        }
        Platform.run((ISafeRunnable)code);
    }

    protected void detectCycles() {
        Collection values = this.descriptors.values();
        ProjectNatureDescriptor[] natures = values.toArray(new ProjectNatureDescriptor[values.size()]);
        for (int i = 0; i < natures.length; ++i) {
            if (natures[i].colour != 0) continue;
            this.hasCycles(natures[i]);
        }
    }

    protected IStatus failure(String reason) {
        return new ResourceStatus(35, reason);
    }

    public String findNatureForBuilder(String builderID) {
        if (this.buildersToNatures == null) {
            this.buildersToNatures = new HashMap(10);
            IProjectNatureDescriptor[] descriptors = this.getNatureDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                String natureId = descriptors[i].getNatureId();
                String[] builders = ((ProjectNatureDescriptor)descriptors[i]).getBuilderIds();
                for (int j = 0; j < builders.length; ++j) {
                    this.buildersToNatures.put(builders[j], natureId);
                }
            }
        }
        return (String)this.buildersToNatures.get(builderID);
    }

    protected void flushEnablements(IProject project) {
        if (this.natureEnablements != null) {
            this.natureEnablements.remove(project);
            if (this.natureEnablements.size() == 0) {
                this.natureEnablements = null;
            }
        }
    }

    protected String[] getEnabledNatures(IProject project) {
        if (this.natureEnablements != null) {
            return (String[])this.natureEnablements.get(project);
        }
        return null;
    }

    protected boolean hasCycles(ProjectNatureDescriptor desc) {
        if (desc.colour == 2) {
            return desc.hasCycle;
        }
        if (desc.colour == 1) {
            desc.hasCycle = true;
            desc.colour = (byte)2;
            return true;
        }
        desc.colour = 1;
        String[] required = desc.getRequiredNatureIds();
        for (int i = 0; i < required.length; ++i) {
            ProjectNatureDescriptor dependency = (ProjectNatureDescriptor)this.getNatureDescriptor(required[i]);
            if (dependency == null || !this.hasCycles(dependency)) continue;
            desc.hasCycle = true;
            desc.colour = (byte)2;
            return true;
        }
        desc.hasCycle = false;
        desc.colour = (byte)2;
        return false;
    }

    protected boolean hasLinks(IProject project) {
        try {
            IResource[] children = project.members();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].isLinked()) continue;
                return true;
            }
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
        return false;
    }

    protected String hasSetOverlap(IProjectNatureDescriptor one, IProjectNatureDescriptor two) {
        if (one == null || two == null) {
            return null;
        }
        String[] setsOne = one.getNatureSetIds();
        String[] setsTwo = two.getNatureSetIds();
        for (int iOne = 0; iOne < setsOne.length; ++iOne) {
            for (int iTwo = 0; iTwo < setsTwo.length; ++iTwo) {
                if (!setsOne[iOne].equals(setsTwo[iTwo])) continue;
                return setsOne[iOne];
            }
        }
        return null;
    }

    protected void insert(ArrayList list, Set seen, String id) {
        if (seen.contains(id)) {
            return;
        }
        seen.add(id);
        IProjectNatureDescriptor desc = this.getNatureDescriptor(id);
        if (desc != null) {
            String[] prereqs = desc.getRequiredNatureIds();
            for (int i = 0; i < prereqs.length; ++i) {
                this.insert(list, seen, prereqs[i]);
            }
        }
        list.add(id);
    }

    public boolean isNatureEnabled(Project project, String id) {
        String[] enabled = this.getEnabledNatures(project);
        if (enabled == null) {
            enabled = this.computeNatureEnablements(project);
            this.setEnabledNatures(project, enabled);
        }
        for (int i = 0; i < enabled.length; ++i) {
            if (!enabled[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    protected void lazyInitialize() {
        if (this.descriptors != null) {
            return;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "natures");
        IExtension[] extensions = point.getExtensions();
        this.descriptors = new HashMap(extensions.length * 2 + 1);
        int imax = extensions.length;
        for (int i = 0; i < imax; ++i) {
            ProjectNatureDescriptor desc = null;
            try {
                desc = new ProjectNatureDescriptor(extensions[i]);
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            }
            if (desc == null) continue;
            this.descriptors.put(desc.getNatureId(), desc);
        }
        this.detectCycles();
    }

    protected void setEnabledNatures(IProject project, String[] enablements) {
        if (this.natureEnablements == null) {
            this.natureEnablements = new HashMap(20);
        }
        this.natureEnablements.put(project, enablements);
    }

    public void shutdown(IProgressMonitor monitor) throws CoreException {
    }

    public String[] sortNatureSet(String[] natureIds) {
        int count = natureIds.length;
        if (count == 0) {
            return natureIds;
        }
        ArrayList result = new ArrayList(count);
        HashSet<String> seen = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            this.insert(result, seen, natureIds[i]);
        }
        seen.clear();
        seen.addAll(Arrays.asList(natureIds));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Object id = it.next();
            if (seen.contains(id)) continue;
            it.remove();
        }
        return result.toArray(new String[result.size()]);
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        ((Workspace)ResourcesPlugin.getWorkspace()).addLifecycleListener(this);
    }

    protected IStatus validateAdditions(HashSet newNatures, HashSet additions, IProject project) {
        Boolean hasLinks = null;
        Iterator added = additions.iterator();
        while (added.hasNext()) {
            String id = (String)added.next();
            IProjectNatureDescriptor desc = this.getNatureDescriptor(id);
            if (desc == null) {
                return this.failure(Policy.bind("natures.missingNature", id));
            }
            if (((ProjectNatureDescriptor)desc).hasCycle) {
                return this.failure(Policy.bind("natures.hasCycle", id));
            }
            String[] required = desc.getRequiredNatureIds();
            for (int i = 0; i < required.length; ++i) {
                if (newNatures.contains(required[i])) continue;
                return this.failure(Policy.bind("natures.missingPrerequisite", id, required[i]));
            }
            Iterator all = newNatures.iterator();
            while (all.hasNext()) {
                String overlap;
                String current = (String)all.next();
                if (current.equals(id) || (overlap = this.hasSetOverlap(desc, this.getNatureDescriptor(current))) == null) continue;
                return this.failure(Policy.bind("natures.multipleSetMembers", overlap));
            }
            if (desc.isLinkingAllowed()) continue;
            if (hasLinks == null) {
                Boolean bl = hasLinks = this.hasLinks(project) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!hasLinks.booleanValue()) continue;
            return this.failure(Policy.bind("links.vetoNature", project.getName(), id));
        }
        return Status.OK_STATUS;
    }

    public IStatus validateLinkCreation(String[] natureIds) {
        for (int i = 0; i < natureIds.length; ++i) {
            IProjectNatureDescriptor desc = this.getNatureDescriptor(natureIds[i]);
            if (desc == null || desc.isLinkingAllowed()) continue;
            String msg = Policy.bind("links.natureVeto", desc.getLabel());
            return new ResourceStatus(378, msg);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateRemovals(HashSet newNatures, HashSet deletions) {
        Iterator it = newNatures.iterator();
        while (it.hasNext()) {
            String currentID = (String)it.next();
            IProjectNatureDescriptor desc = this.getNatureDescriptor(currentID);
            if (desc == null) continue;
            String[] required = desc.getRequiredNatureIds();
            for (int i = 0; i < required.length; ++i) {
                if (!deletions.contains(required[i])) continue;
                return this.failure(Policy.bind("natures.invalidRemoval", required[i], currentID));
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validateNatureSet(String[] natureIds) {
        int i;
        int count = natureIds.length;
        if (count == 0) {
            return Status.OK_STATUS;
        }
        String msg = Policy.bind("natures.invalidSet");
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 35, msg, null);
        HashSet<String> natures = new HashSet<String>(count * 2);
        HashSet<String> sets = new HashSet<String>(count);
        for (i = 0; i < count; ++i) {
            String id = natureIds[i];
            ProjectNatureDescriptor desc = (ProjectNatureDescriptor)this.getNatureDescriptor(id);
            if (desc == null) {
                result.add(this.failure(Policy.bind("natures.missingNature", id)));
                continue;
            }
            if (desc.hasCycle) {
                result.add(this.failure(Policy.bind("natures.hasCycle", id)));
            }
            if (!natures.add(id)) {
                result.add(this.failure(Policy.bind("natures.duplicateNature", id)));
            }
            String[] setIds = desc.getNatureSetIds();
            for (int j = 0; j < setIds.length; ++j) {
                if (sets.add(setIds[j])) continue;
                result.add(this.failure(Policy.bind("natures.multipleSetMembers", setIds[j])));
            }
        }
        for (i = 0; i < count; ++i) {
            IProjectNatureDescriptor desc = this.getNatureDescriptor(natureIds[i]);
            if (desc == null) continue;
            String[] required = desc.getRequiredNatureIds();
            for (int j = 0; j < required.length; ++j) {
                if (natures.contains(required[j])) continue;
                result.add(this.failure(Policy.bind("natures.missingPrerequisite", natureIds[i], required[j])));
            }
        }
        return result.isOK() ? Status.OK_STATUS : result;
    }
}

