/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplates;
import org.eclipse.jdt.internal.corext.template.java.TemplateSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public final class CompatibilityTemplateStore
extends ContributionTemplateStore {
    private TemplateSet fLegacySet;

    public CompatibilityTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key, TemplateSet legacySet) {
        super(registry, store, key);
        this.fLegacySet = legacySet;
    }

    public void load() throws IOException {
        super.load();
        if (this.fLegacySet != null) {
            ArrayList<Template> legacyTemplates = new ArrayList<Template>(Arrays.asList(this.fLegacySet.getTemplates()));
            this.fLegacySet.clear();
            TemplatePersistenceData[] datas = this.getTemplateData(true);
            ListIterator it = legacyTemplates.listIterator();
            while (it.hasNext()) {
                Template t = (Template)it.next();
                TemplatePersistenceData orig = CompatibilityTemplateStore.findSimilarTemplate(datas, t, this.isCodeTemplates());
                if (orig == null) {
                    if (this.isCodeTemplates()) continue;
                    this.add(new TemplatePersistenceData(t, true));
                    continue;
                }
                if (orig.getTemplate().getPattern().equals(t.getPattern())) continue;
                orig.setTemplate(t);
            }
            this.save();
        }
    }

    private static TemplatePersistenceData findSimilarTemplate(TemplatePersistenceData[] datas, Template template, boolean isCodeTemplates) {
        for (int i = 0; i < datas.length; ++i) {
            TemplatePersistenceData data = datas[i];
            Template orig = data.getTemplate();
            if (!CompatibilityTemplateStore.isSimilar(template, orig, isCodeTemplates)) continue;
            return data;
        }
        return null;
    }

    private static boolean isSimilar(Template t, Template orig, boolean isCodeTemplates) {
        return orig.getName().equals(t.getName()) && orig.getContextTypeId().equals(t.getContextTypeId()) && (isCodeTemplates || orig.getDescription().equals(t.getDescription()));
    }

    private boolean isCodeTemplates() {
        return this.fLegacySet instanceof CodeTemplates;
    }

    public static void pruneDuplicates(TemplateStore store, boolean isCodeTemplates) {
        int i;
        TemplatePersistenceData[] datas = store.getTemplateData(true);
        for (i = datas.length - 1; i >= 0; --i) {
            TemplatePersistenceData similar;
            TemplatePersistenceData data = datas[i];
            if (!data.isUserAdded() || (similar = CompatibilityTemplateStore.findSimilarTemplate(datas, data.getTemplate(), isCodeTemplates)) == data || similar.isUserAdded()) continue;
            similar.setTemplate(data.getTemplate());
            store.delete(data);
        }
        if (isCodeTemplates) {
            datas = store.getTemplateData(true);
            for (i = datas.length - 1; i >= 0; --i) {
                if (!datas[i].isUserAdded()) continue;
                store.delete(datas[i]);
            }
        }
    }
}

