#include <stdio.h>

#include "awklib.h"
#include "awkgram.h"
#include "proto.h"

static const char * const printname[102] = {
	"FIRSTTOKEN",	/* 258 */
	"PROGRAM",	/* 259 */
	"PASTAT",	/* 260 */
	"PASTAT2",	/* 261 */
	"XBEGIN",	/* 262 */
	"XEND",		/* 263 */
	"NL",		/* 264 */
	"ARRAY",	/* 265 */
	"MATCH",	/* 266 */
	"NOTMATCH",	/* 267 */
	"MATCHOP",	/* 268 */
	"FINAL",	/* 269 */
	"DOT",		/* 270 */
	"ALL",		/* 271 */
	"CCL",		/* 272 */
	"NCCL",		/* 273 */
	"CHAR",		/* 274 */
	"OR",		/* 275 */
	"STAR",		/* 276 */
	"QUEST",	/* 277 */
	"PLUS",		/* 278 */
	"EMPTYRE",	/* 279 */
	"AND",		/* 280 */
	"BOR",		/* 281 */
	"APPEND",	/* 282 */
	"EQ",		/* 283 */
	"GE",		/* 284 */
	"GT",		/* 285 */
	"LE",		/* 286 */
	"LT",		/* 287 */
	"NE",		/* 288 */
	"IN",		/* 289 */
	"ARG",		/* 290 */
	"BLTIN",	/* 291 */
	"BREAK",	/* 292 */
	"CLOSE",	/* 293 */
	"CONTINUE",	/* 294 */
	"DELETE",	/* 295 */
	"DLALLOC",	/* 296 */
	"DLCALL",	/* 297 */
	"DLCLOSE",	/* 298 */
	"DLFIELD",	/* 299 */
	"DLFREE",	/* 300 */
	"DLOPEN",	/* 301 */
	"DLPROTO",	/* 302 */
	"SHIFTARGS",	/* 303 */
	"DO",		/* 304 */
	"EXIT",		/* 305 */
	"FOR",		/* 306 */
	"FUNC",		/* 307 */
	"SUB",		/* 308 */
	"GSUB",		/* 309 */
	"IF",		/* 310 */
	"INDEX",	/* 311 */
	"LSUBSTR",	/* 312 */
	"MATCHFCN",	/* 313 */
	"NEXT",		/* 314 */
	"NEXTFILE",	/* 315 */
	"ADD",		/* 316 */
	"MINUS",	/* 317 */
	"MULT",		/* 318 */
	"DIVIDE",	/* 319 */
	"MOD",		/* 320 */
	"ASSIGN",	/* 321 */
	"ASGNOP",	/* 322 */
	"ADDEQ",	/* 323 */
	"SUBEQ",	/* 324 */
	"MULTEQ",	/* 325 */
	"DIVEQ",	/* 326 */
	"MODEQ",	/* 327 */
	"POWEQ",	/* 328 */
	"PRINT",	/* 329 */
	"PRINTF",	/* 330 */
	"SPRINTF",	/* 331 */
	"ELSE",		/* 332 */
	"INTEST",	/* 333 */
	"CONDEXPR",	/* 334 */
	"POSTINCR",	/* 335 */
	"PREINCR",	/* 336 */
	"POSTDECR",	/* 337 */
	"PREDECR",	/* 338 */
	"VAR",		/* 339 */
	"IVAR",		/* 340 */
	"VARNF",	/* 341 */
	"CALL",		/* 342 */
	"NUMBER",	/* 343 */
	"STRING",	/* 344 */
	"REGEXPR",	/* 345 */
	"GETLINE",	/* 346 */
	"GENSUB",	/* 347 */
	"RETURN",	/* 348 */
	"SPLIT",	/* 349 */
	"SUBSTR",	/* 350 */
	"WHILE",	/* 351 */
	"CAT",		/* 352 */
	"NOT",		/* 353 */
	"UMINUS",	/* 354 */
	"POWER",	/* 355 */
	"DECR",		/* 356 */
	"INCR",		/* 357 */
	"INDIRECT",	/* 358 */
	"LASTTOKEN",	/* 359 */
};


awkcell_t *(*awklib_proctab[102])(awk_t *, awknode_t **, int) = {
	awklib_nullproc,	/* FIRSTTOKEN */
	awklib_program,	/* PROGRAM */
	awklib_pastat,	/* PASTAT */
	awklib_dopa2,	/* PASTAT2 */
	awklib_nullproc,	/* XBEGIN */
	awklib_nullproc,	/* XEND */
	awklib_nullproc,	/* NL */
	awklib_array,	/* ARRAY */
	awklib_matchop,	/* MATCH */
	awklib_matchop,	/* NOTMATCH */
	awklib_nullproc,	/* MATCHOP */
	awklib_nullproc,	/* FINAL */
	awklib_nullproc,	/* DOT */
	awklib_nullproc,	/* ALL */
	awklib_nullproc,	/* CCL */
	awklib_nullproc,	/* NCCL */
	awklib_nullproc,	/* CHAR */
	awklib_nullproc,	/* OR */
	awklib_nullproc,	/* STAR */
	awklib_nullproc,	/* QUEST */
	awklib_nullproc,	/* PLUS */
	awklib_nullproc,	/* EMPTYRE */
	awklib_boolop,	/* AND */
	awklib_boolop,	/* BOR */
	awklib_nullproc,	/* APPEND */
	awklib_relop,	/* EQ */
	awklib_relop,	/* GE */
	awklib_relop,	/* GT */
	awklib_relop,	/* LE */
	awklib_relop,	/* LT */
	awklib_relop,	/* NE */
	awklib_instat,	/* IN */
	awklib_arg,	/* ARG */
	awklib_bltin,	/* BLTIN */
	awklib_jump,	/* BREAK */
	awklib_closefile,	/* CLOSE */
	awklib_jump,	/* CONTINUE */
	awklib_delete,	/* DELETE */
	awklib_dlalloc,	/* DLALLOC */
	awklib_dlcall,	/* DLCALL */
	awklib_dlclose,	/* DLCLOSE */
	awklib_dlfield,	/* DLFIELD */
	awklib_dlfree,	/* DLFREE */
	awklib_dlopen,	/* DLOPEN */
	awklib_dlproto,	/* DLPROTO */
	awklib_shift,	/* SHIFTARGS */
	awklib_dostat,	/* DO */
	awklib_jump,	/* EXIT */
	awklib_forstat,	/* FOR */
	awklib_nullproc,	/* FUNC */
	awklib_sub,	/* SUB */
	awklib_gsub,	/* GSUB */
	awklib_ifstat,	/* IF */
	awklib_index,	/* INDEX */
	awklib_nullproc,	/* LSUBSTR */
	awklib_matchop,	/* MATCHFCN */
	awklib_jump,	/* NEXT */
	awklib_jump,	/* NEXTFILE */
	awklib_arith,	/* ADD */
	awklib_arith,	/* MINUS */
	awklib_arith,	/* MULT */
	awklib_arith,	/* DIVIDE */
	awklib_arith,	/* MOD */
	awklib_assign,	/* ASSIGN */
	awklib_nullproc,	/* ASGNOP */
	awklib_assign,	/* ADDEQ */
	awklib_assign,	/* SUBEQ */
	awklib_assign,	/* MULTEQ */
	awklib_assign,	/* DIVEQ */
	awklib_assign,	/* MODEQ */
	awklib_assign,	/* POWEQ */
	awklib_print,	/* PRINT */
	awklib_printf,	/* PRINTF */
	awklib_sprintf,	/* SPRINTF */
	awklib_nullproc,	/* ELSE */
	awklib_intest,	/* INTEST */
	awklib_condexpr,	/* CONDEXPR */
	awklib_incrdecr,	/* POSTINCR */
	awklib_incrdecr,	/* PREINCR */
	awklib_incrdecr,	/* POSTDECR */
	awklib_incrdecr,	/* PREDECR */
	awklib_nullproc,	/* VAR */
	awklib_nullproc,	/* IVAR */
	awklib_getnf,	/* VARNF */
	awklib_call,	/* CALL */
	awklib_nullproc,	/* NUMBER */
	awklib_nullproc,	/* STRING */
	awklib_nullproc,	/* REGEXPR */
	awklib_getline,	/* GETLINE */
	awklib_gensub,	/* GENSUB */
	awklib_jump,	/* RETURN */
	awklib_split,	/* SPLIT */
	awklib_substr,	/* SUBSTR */
	awklib_whilestat,	/* WHILE */
	awklib_cat,	/* CAT */
	awklib_boolop,	/* NOT */
	awklib_arith,	/* UMINUS */
	awklib_arith,	/* POWER */
	awklib_nullproc,	/* DECR */
	awklib_nullproc,	/* INCR */
	awklib_indirect,	/* INDIRECT */
	awklib_nullproc,	/* LASTTOKEN */
};

const char *
awklib_tokname(int n)
{
	static char buf[100];

	if (n < FIRSTTOKEN || n > LASTTOKEN) {
		snprintf(buf, sizeof(buf), "token %d", n);
		return buf;
	}
	return printname[n-FIRSTTOKEN];
}
