/*
 * Decompiled with CFR 0.152.
 */
package netscape.palomar.sgml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import netscape.palomar.sgml.SGMLException;
import netscape.palomar.sgml.SGMLParseTableEntry;
import netscape.palomar.sgml.SGMLStream;
import netscape.palomar.sgml.SGMLTag;
import netscape.palomar.sgml.SGMLText;
import netscape.palomar.sgml.charHolder;
import netscape.palomar.util.CascadedException;

public class SGMLParser {
    protected String[] charEscape = new String[256];
    protected Hashtable parseTable = new Hashtable(50);
    protected Hashtable paramSets = new Hashtable(50);
    protected Hashtable charXlate = new Hashtable(350);
    protected Class _unknownTagClass;
    protected Class _textClass;
    protected Class _scriptClass;
    protected Class _treeTopClass;

    public SGMLParser() throws CascadedException {
        try {
            this._unknownTagClass = Class.forName("netscape.palomar.sgml.SGMLTagImpl");
            this._textClass = Class.forName("netscape.palomar.sgml.SGMLTextImpl");
            this._scriptClass = Class.forName("netscape.palomar.sgml.SGMLTextImpl");
            this._treeTopClass = Class.forName("netscape.palomar.sgml.SGMLTagTop");
            return;
        }
        catch (Exception ex) {
            SGMLException ce = new SGMLException(200, ex);
            throw ce;
        }
    }

    public SGMLTag parseFile(String filename) throws CascadedException {
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            SGMLTag rslt = this.parseStream(bis);
            ((FilterInputStream)bis).close();
            return rslt;
        }
        catch (Exception e) {
            SGMLException ce = new SGMLException(201, e);
            ce.addToken("filename", filename);
            throw ce;
        }
    }

    public void writeFile(String filename, SGMLTag content) throws CascadedException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            this.writeStream(bos, content);
            bos.close();
            return;
        }
        catch (Exception e) {
            SGMLException ce = new SGMLException(202, e);
            ce.addToken("filename", filename);
            throw ce;
        }
    }

    public SGMLTag parseStream(InputStream is) throws CascadedException {
        try {
            SGMLStream fis = new SGMLStream(is, this);
            SGMLTag res = (SGMLTag)this._treeTopClass.newInstance();
            SGMLParseTableEntry phony = (SGMLParseTableEntry)this.parseTable.get("%UNKNOWN");
            if (phony == null) {
                phony = new SGMLParseTableEntry(this, this._unknownTagClass);
                phony.contentEmpty = true;
                this.parseTable.put("%UNKNOWN", phony);
            }
            res.preParseSetup("<TOP>", phony);
            res.parseChildren(fis, new Vector(), new Vector());
            return res;
        }
        catch (Exception e) {
            SGMLException ce = new SGMLException(201, e);
            ce.addToken("filename", "STREAM");
            throw ce;
        }
    }

    public void writeStream(OutputStream os, SGMLTag content) throws CascadedException {
        DataOutputStream outData = new DataOutputStream(os);
        content.writeYourself(outData);
    }

    public SGMLTag generateTag(String lineImage) throws CascadedException {
        String tokenType = null;
        try {
            tokenType = SGMLParser.getTagType(lineImage);
            SGMLParseTableEntry pte = (SGMLParseTableEntry)this.parseTable.get(tokenType);
            if (pte == null) {
                SGMLTag newT = (SGMLTag)this._unknownTagClass.newInstance();
                newT.preParseSetup(lineImage, (SGMLParseTableEntry)this.parseTable.get("%UNKNOWN"));
                return newT;
            }
            SGMLTag newT = (SGMLTag)pte.generatedClass.newInstance();
            newT.preParseSetup(lineImage, pte);
            return newT;
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(203, e);
            pe.addToken("tag", tokenType);
            throw pe;
        }
    }

    public SGMLText generateText(String lineImage) throws CascadedException {
        try {
            SGMLText retText = (SGMLText)this._textClass.newInstance();
            retText.setParser(this);
            retText.setRawValue(lineImage);
            return retText;
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(204, e);
            throw pe;
        }
    }

    public SGMLText generateScript(String rawValue) throws CascadedException {
        try {
            SGMLText retText = (SGMLText)this._scriptClass.newInstance();
            retText.setParser(this);
            retText.setRawValue(rawValue);
            return retText;
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(204, e);
            throw pe;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String getTagType(String lineImage) {
        i = 1;
        len = lineImage.length();
        if (len >= 3) ** GOTO lbl7
        return "";
        while ((ch = lineImage.charAt(i)) > ' ') {
            ++i;
lbl7:
            // 2 sources

            if (i < len) continue;
        }
        if (i < len) {
            return lineImage.substring(1, i).toUpperCase();
        }
        return lineImage.substring(1, len - 1).toUpperCase();
    }

    public static int findWhite(String s, int start) {
        int i = start;
        int last = s.length();
        while (i < last) {
            char ch = s.charAt(i);
            if (ch <= ' ') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int spanWhite(String s, int start) {
        int i = start;
        int last = s.length();
        while (i < last) {
            char ch = s.charAt(i);
            if (ch > ' ') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setChar(String escape, int value) {
        charHolder hold = new charHolder(escape, value);
        this.charXlate.put(escape, hold);
        if (value >= 0 & value < 256) {
            this.charEscape[value] = "&" + escape + ";";
        }
    }

    public int lookUpChar(String entitiy) {
        charHolder hold = (charHolder)this.charXlate.get(entitiy);
        if (hold == null) {
            return -1;
        }
        return hold.getValue();
    }

    public String escapeChar(char ch) {
        if (ch > '\u00ff') {
            return "&#" + ch + ";";
        }
        return this.charEscape[ch];
    }

    public String escapeText(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        int len = input.length();
        int i = 0;
        while (i < len) {
            out.append(this.escapeChar(input.charAt(i)));
            ++i;
        }
        return out.toString();
    }

    public String unEscapeText(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        int last = input.length();
        int pos = 0;
        while (pos < last) {
            char ch = input.charAt(pos);
            switch (ch) {
                case '&': {
                    int semiPos = input.indexOf(";", pos + 1);
                    if (semiPos < 0) {
                        out.append('&');
                        break;
                    }
                    if (input.charAt(pos + 1) == '#') {
                        String num = input.substring(pos + 2, semiPos);
                        try {
                            int val = Integer.parseInt(num);
                            out.append((char)val);
                        }
                        catch (NumberFormatException numberFormatException) {
                            out.append(input.substring(pos, semiPos + 1));
                        }
                    } else {
                        String esc = input.substring(pos + 1, semiPos);
                        int escVal = this.lookUpChar(esc);
                        if (escVal > 0) {
                            out.append((char)escVal);
                        } else {
                            out.append(input.substring(pos, semiPos + 1));
                        }
                    }
                    pos = semiPos;
                    break;
                }
                default: {
                    out.append(ch);
                }
                case '\r': 
            }
            ++pos;
        }
        return out.toString();
    }

    private String unEscapeText_OLD_OLD_OLD(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        int oldPos = 0;
        int pos = input.indexOf("&");
        while (pos >= 0) {
            out.append(input.substring(oldPos, pos));
            int semiPos = input.indexOf(";", pos + 1);
            if (semiPos < 0) {
                out.append(input.substring(pos));
                return out.toString();
            }
            if (input.charAt(pos + 1) == '#') {
                String num = input.substring(pos + 2, semiPos);
                try {
                    int val = Integer.parseInt(num);
                    out.append((char)val);
                }
                catch (NumberFormatException numberFormatException) {
                    out.append(input.substring(pos, semiPos + 1));
                }
            } else {
                String esc = input.substring(pos + 1, semiPos);
                int escVal = this.lookUpChar(esc);
                if (escVal > 0) {
                    out.append((char)escVal);
                } else {
                    out.append(input.substring(pos, semiPos + 1));
                }
            }
            oldPos = semiPos + 1;
            pos = input.indexOf("&", oldPos);
        }
        out.append(input.substring(oldPos));
        return out.toString();
    }

    public void setUnknownTagClass(Class utc) {
        this._unknownTagClass = utc;
    }

    public void setTextClass(Class tc) {
        this._textClass = tc;
    }

    public void setScriptClass(Class tc) {
        this._scriptClass = tc;
    }

    public void setTopClass(Class tc) {
        this._treeTopClass = tc;
    }

    public SGMLParseTableEntry getParseTableEntry(String tagName) {
        SGMLParseTableEntry pte;
        if (tagName == null) {
            tagName = "%UNKNOWN";
        }
        if ((pte = (SGMLParseTableEntry)this.parseTable.get(tagName)) == null) {
            pte = (SGMLParseTableEntry)this.parseTable.get("%UNKNOWN");
        }
        return pte;
    }

    public String[] getStandardAttributeList(String tagName) {
        return (String[])this.paramSets.get(tagName);
    }
}

