/*
 * Decompiled with CFR 0.152.
 */
package netscape.nethelp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import netscape.nethelp.util.ErrorMsg;
import netscape.nethelp.util.ProgressMsg;
import netscape.nethelp.util.TraceMsg;

public class MyFile
extends File {
    public MyFile(File file) {
        super(file.toString());
    }

    public MyFile(File file, String string) {
        super(file, string);
    }

    public boolean copyTo(File file) {
        if (this.isDirectory()) {
            TraceMsg.show("copying directory " + this + " to " + file);
            if (!file.exists() && !file.mkdir()) {
                ErrorMsg.show("Cannot create directory " + file);
                return false;
            }
            MyFile[] myFileArray = this.listMyFiles();
            int n = 0;
            while (n < myFileArray.length) {
                File file2 = new File(file, myFileArray[n].getName());
                myFileArray[n].copyTo(file2);
                ++n;
            }
        } else {
            ProgressMsg.show("Copying " + this + " to " + file);
            TraceMsg.show("  copying " + this + " to " + file);
            try {
                int n;
                FileInputStream fileInputStream = new FileInputStream(this);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n = fileInputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                fileInputStream.close();
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                ErrorMsg.show("cannot find file: " + fileNotFoundException);
                return false;
            }
            catch (IOException iOException) {
                ErrorMsg.show("copying to file " + file + ": " + iOException);
                return false;
            }
        }
        return true;
    }

    public MyFile[] listMyFiles() {
        String[] stringArray = null;
        MyFile[] myFileArray = null;
        if (this.isDirectory()) {
            stringArray = this.list();
            myFileArray = new MyFile[stringArray.length];
            TraceMsg.show("Found " + stringArray.length + " items in dir " + this);
            int n = 0;
            while (n < stringArray.length) {
                myFileArray[n] = new MyFile(this, stringArray[n]);
                ++n;
            }
        }
        return myFileArray;
    }
}

