import QtQuick
import Constants
import Generated.DesignSystem

Item {
    id: root
    property bool autoMode: false
    property bool autoModeGoingUp: true
    property int heartRate: 0
    property int elevation: 0
    property int incline: 0
    property int timeMinutes: 0
    property int timeSeconds: 0
    property string timeMinuteString: timeMinutes.toString().length <2 ? "0" + timeMinutes : timeMinutes
    property string timeSecondString: timeSeconds.toString().length <2 ? "0" + timeSeconds : timeSeconds
    property int paceMinutes: 0
    property int paceSeconds: 0
    property double speed: 0
    property bool paused: false

    function calculateValuesOnScreen() {
        var pace = 60 / root.speed + root.incline / 10
        root.heartRate = Math.random() * 100 + 100
        ++root.timeSeconds
        if (root.timeSeconds === 60) {
            ++root.timeMinutes
            root.timeSeconds = 0
        }
        if (pace > 99) {
            root.paceMinutes = 99
            root.paceSeconds = 60
        }
        else {
            root.paceMinutes =  pace
            root.paceSeconds = (pace - Math.floor(pace)) * 60
        }
        if (root.elevation < 999) {
            root.elevation = (root.incline / 100) * 33
        }
    }

    function automateThings() {
        main.trackView.timelineAnimation.start()
        if (root.autoModeGoingUp) {
            ++root.elevation
            ++root.incline
            root.speed += 0.3
            if (root.incline > 99)
                root.autoModeGoingUp = !root.autoModeGoingUp
        }
        else if (!root.autoModeGoingUp) {
            --root.elevation
            --root.incline
            root.speed -= 0.3
            if (root.incline < 1)
                root.autoModeGoingUp = !root.autoModeGoingUp
        }
        calculateValuesOnScreen()
    }

    function reset() {
        timer.stop()
        main.trackView.timelineAnimation.stop()
        main.trackView.timeline.currentFrame = 0
        main.modeSwitch.checked = false
        root.autoMode = false
        root.heartRate = 0
        root.elevation = 0
        root.incline = 0
        root.timeMinutes = 0
        root.timeSeconds = 0
        root.paceMinutes = 0
        root.paceSeconds = 0
        root.speed = 0
        main.trackView.paused = false
    }

    width: Constants.width
    height: Constants.height

    Screen01 {
        id: main

        modeSwitch.onClicked: {
            root.autoMode = !root.autoMode
            if (!root.autoMode)
                main.trackView.timelineAnimation.stop()
        }

        lightModeButton.checkable: darkModeButton.checked || sportyModeButton.checked
        darkModeButton.checkable: lightModeButton.checked || sportyModeButton.checked
        sportyModeButton.checkable: darkModeButton.checked || lightModeButton.checked
        lightModeButton.onClicked: {
            Colors.currentTheme = Colors.light
            main.lightModeButton.checked = true
            main.darkModeButton.checked = false
            main.sportyModeButton.checked = false
            main.inclinePanel.panelIcon.source = "assets/panelIcon.png"
            main.speedPanel.panelIcon.source = "assets/sprintIconDark.png"
        }

        darkModeButton.onClicked: {
            Colors.currentTheme = Colors.dark
            main.darkModeButton.checked = true
            main.lightModeButton.checked = false
            main.sportyModeButton.checked = false
            main.inclinePanel.panelIcon.source = "assets/inclineIconLight.png"
            main.speedPanel.panelIcon.source = "assets/sprintIconLight.png"
        }

        sportyModeButton.onClicked: {
            Colors.currentTheme = Colors.sporty
            main.sportyModeButton.checked = true
            main.lightModeButton.checked = false
            main.darkModeButton.checked = false
            main.inclinePanel.panelIcon.source = "assets/panelIcon.png"
            main.speedPanel.panelIcon.source = "assets/sprintIconDark.png"
        }

        heartRatePanel.counterText: root.heartRate
        elevationPanel.counterText: root.elevation

        trackView.timeValueText: root.timeMinuteString + ":" + root.timeSecondString
        trackView.paceValueText: root.paceSeconds.toString().length < 2 ? root.paceMinutes + ":0" + root.paceSeconds
                                                                        : root.paceMinutes +":" + root.paceSeconds

        inclinePanel.leftArrowButton.onClicked: root.incline > 0 ? --root.incline : undefined
        inclinePanel.rightArrowButton.onClicked: root.incline < 100 ? ++root.incline : undefined
        inclinePanel.panelValueText: root.incline

        speedPanel.leftArrowButton.onClicked: root.speed > 0 ? root.speed = Math.round((root.speed - 0.1) * 10) / 10 : undefined
        speedPanel.rightArrowButton.onClicked: root.speed < 20 ? root.speed = Math.round((root.speed + 0.1) * 10) / 10 : undefined
        speedPanel.panelValueText: root.speed.toFixed(1)

        startButton.onClicked: {
            timer.start()
            root.autoMode = false
            main.modeSwitch.checked = false
            main.trackView.timelineAnimation.start()
            main.trackView.paused = false
        }
        pauseButton.onClicked: {
            timer.stop()
            root.autoMode = false
            main.modeSwitch.checked = false
            if (!main.trackView.paused) {
                main.trackView.timelineAnimation.stop()
                main.trackView.paused = true
            }
            else {
                timer.start()
                main.trackView.timelineAnimation.start()
                main.trackView.paused = false
            }
        }
        stopButton.onClicked: reset()
    }

    SplashScreen {
        id: splash
    }

    Timer {
        id: timer
        running: false
        repeat: true
        interval: 1000
        onTriggered: calculateValuesOnScreen()
    }

    Timer {
        id: autoModeTimer
        running: root.autoMode
        repeat: true
        interval: 1000
        onTriggered: automateThings()
    }

    Timer {
        id: splashTimer
        running: true
        repeat: false
        interval: 5000
        onTriggered: splash.visible = !splash.visible
    }
}
