#!/usr/bin/perl

package eBay::API::XML::DataType::SiteLocationType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SiteLocationType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SiteLocationType

=head1 DESCRIPTION

Contains the data that defines a site-based filter (used when searching for 
items and filtering the search result set).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SiteLocationType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::SiteIDFilterCodeType;


my @gaProperties = ( [ 'SiteID', 'ns:SiteIDFilterCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SiteIDFilterCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setSiteID()

Specifies the criteria for filtering search results by site, where site is 
determined by the site ID in the SOAP URL or, for Unified Schema XML requests, 
X-EBAY-API-SITEID HTTP Header.

  Calls: GetSearchResults
         GetCategoryListings
  RequiredInput: No

#    Argument: 'ns:SiteIDFilterCodeType'

=cut

sub setSiteID {
  my $self = shift;
  $self->{'SiteID'} = shift
}

=head2 getSiteID()

#    Returns: 'ns:SiteIDFilterCodeType'

=cut

sub getSiteID {
  my $self = shift;
  return $self->{'SiteID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
