# Generated by default/object.tt
package Paws::CodePipeline::ActionTypeExecutor;
  use Moose;
  has Configuration => (is => 'ro', isa => 'Paws::CodePipeline::ExecutorConfiguration', request_name => 'configuration', traits => ['NameInRequest'], required => 1);
  has JobTimeout => (is => 'ro', isa => 'Int', request_name => 'jobTimeout', traits => ['NameInRequest']);
  has PolicyStatementsTemplate => (is => 'ro', isa => 'Str', request_name => 'policyStatementsTemplate', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodePipeline::ActionTypeExecutor

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodePipeline::ActionTypeExecutor object:

  $service_obj->Method(Att1 => { Configuration => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodePipeline::ActionTypeExecutor object:

  $result = $service_obj->Method(...);
  $result->Att1->Configuration

=head1 DESCRIPTION

The action engine, or executor, for an action type created for a
provider, where the action is to be used by customers of the provider.
The action engine is associated with the model used to create and
update the action, such as the Lambda integration model.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Configuration => L<Paws::CodePipeline::ExecutorConfiguration>

The action configuration properties for the action type. These
properties are specified in the action definition when the action type
is created.


=head2 JobTimeout => Int

The timeout in seconds for the job. An action execution can have
multiple jobs. This is the timeout for a single job, not the entire
action execution.


=head2 PolicyStatementsTemplate => Str

The policy statement that specifies the permissions in the CodePipeline
customerE<rsquo>s account that are needed to successfully run an
action.

To grant permission to another account, specify the account ID as the
Principal, a domain-style identifier defined by the service, for
example C<codepipeline.amazonaws.com>.

The size of the passed JSON policy document cannot exceed 2048
characters.


=head2 B<REQUIRED> Type => Str

The integration model used to create and update the action type,
C<Lambda> or C<JobWorker>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodePipeline>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

