package Net::Amazon::EMR::ClusterStatus;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;
use Net::Amazon::EMR::ClusterStateChangeReason;
use Net::Amazon::EMR::ClusterTimeline;

subtype 'Net::Amazon::EMR::Type::ClusterStatus::State' => as 'Str' => where { m/^(?:STARTING | BOOTSTRAPPING | RUNNING | WAITING | TERMINATING | TERMINATED | TERMINATED_WITH_ERRORS)$/x };

has 'State' => ( is => 'ro',
                 isa => 'Net::Amazon::EMR::Type::ClusterStatus::State',
);

has 'StateChangeReason' => ( is => 'ro', 
                             isa => 'Net::Amazon::EMR::Type::ClusterStateChangeReason',
                             coerce => 1,
                         );

has 'Timeline' => ( is => 'ro', 
                    isa => 'Net::Amazon::EMR::Type::ClusterTimeline',
                    coerce => 1,
                );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::ClusterStatus

=head1 DESCRIPTION

Implements the ClusterStatus data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_ClusterStatus.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
