#!/bin/sh
# -*- mode: cperl; coding: utf-8-unix; -*-

eval 'exec ${PERL-perl} -Sx "$0" ${1+"$@"}'
  if 0;

#!perl -w
#line 9
#
# Author:      Peter John Acklam
# Time-stamp:  2023-08-27 18:15:36 Vest-Europa (sommertid)
# E-mail:      pjacklam@online.no
# URL:         http://home.online.no/~pjacklam

use strict;
use warnings;

use lib '/cygdrive/c/share/repos/private/github.com/pjacklam/p5-Math-BigInt/lib';

package Math::BigInt;

sub lsft {
    my ($cls, $x, $y, $b) = @_;
    my $z = $y > 0 ? $cls -> new($x) -> bmul($cls -> new($b) -> bpow($y))
                   : $cls -> new($x) -> bdiv($cls -> new($b) -> bpow(-$y));
    return $z;
}

package main;

use Math::BigInt;

my @x = ("-inf", -20 .. 20, "inf");
my @y = (0 .. 10, "inf");
my @b = ( 2 );

my $cls = "Math::BigInt";

for my $b (@b) {

    printf "\nb = %s\n\n", $b;

    printf "        y";
    for my $y (@y) {
        printf " %6s", $y;
    }
    printf "\n";

    printf "    x    ";
    for my $y (@y) {
        printf " %6s", "-----";
    }
    printf "\n";

    for my $x (@x) {
        printf "%6s | ", $x;
        for my $y (@y) {
            printf " %6s", $cls -> lsft($x, $y, $b);
        }
        printf "\n";

    }
}
