package Net::Amazon::EMR::ListStepsResult;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::StepSummary;

has 'Steps' => ( is => 'ro',
                            isa => 'Net::Amazon::EMR::Type::ArrayRefofStepSummary',
                            coerce => 1 );

has 'Marker' => ( is => 'ro',
                  isa => 'Str',
              );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::ListStepsResult

=head1 DESCRIPTION

Implements the ListSteps result type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/API/API_ListSteps.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
