package Byte;

use overload '+' => \&add, '-' => \&sub, '*' => \&mult, '/' => \&div,
    '""' => \&value, '0+' => \&value;

sub new {
    my ($class, $val) = @_;
    my $byte = { -val => pack('c',$val) };
    bless $byte, $class;
    return $byte;
}
sub value {
    my $byte = shift;
    return unpack('c',$byte->{-val})
}
sub add { 
    my ($byte, $num) = @_;
    return Byte->new($byte->value + $num);
}
sub sub { 
    my ($byte, $num) = @_;
    return Byte->new($byte->value - $num);
}
sub mult { 
    my ($byte, $num) = @_;
    return Byte->new($byte->value * $num);
}
sub div { 
    my ($byte, $num) = @_;
    return Byte->new($byte->value / $num);
}
1;
