/*
addEventListener("load", hwOnload, true);

function hwOnload()
{
	removeEventListener("load", hwOnload, true);
	alert("ciao");
}
*/

function dbgAlert(sMessage)
{
	return;		//comment this line to enable debugging alerts.
	alert(sMessage);
}


function resetEngine()
{
	var sResult=confirm("By resetting sync engine, the extension will behave as it never performed sync with your PocketPC device. Do you still want to perform reset?");
	if(sResult==false)
		return;
	alert("The Sync engine will now be resetted. The extension will behave as it never performed sync before.");
	var sPathName=getToolPathName();
	var args=new Array();
	args[0]="-reset";
	util.runProcess(sPathName, true, args);
}

function createDirectories()
{
	var sPathName=getToolPathName();
	var args=new Array();
	//var sContactsFile=util.getUserHomePath() + "\\SmartSync\\PCContacts.xml";
	args[0]="-createfolders";
	util.runProcess(sPathName, true, args);
}

function doSynchronize()
{
	createDirectories();
	if(preferences.getCharPref("smartsync.configured")!="yes")
	{
		alert("SmartSync has not yet been configured. You'll be directed to the configuration page, instead of performing sync.");
		showSettings();
		return;
	}
	var sPathName=getToolPathName();
	var args=new Array();
	var sContactsFile=util.getUserHomePath() + "\\SmartSync\\PCContacts.xml";
	var loglevel=preferences.getCharPref("smartsync.loglevel");
	if(isNaN(parseInt(loglevel))==true)
		loglevel="0";
	args[0]="-auto";
	args[1]="-autoclose";
	args[2]="-loglevel";
	args[3]=loglevel;
	addrbook.abName=preferences.getCharPref("smartsync.targetAddressBook");
	//entrypoints.synchronizeFromXml(util.getUserHomePath() + "\\SmartSync\\PCContacts.xml");
	entrypoints.saveContactsToXml(sContactsFile);
	util.runProcess(sPathName, true, args);
	entrypoints.synchronizeFromXml(sContactsFile);
}

function showSettings()
{
	window.open("chrome://smartsync/content/dlgSettings.xul", "dlgSettings", "chrome,modal");
}

function getToolPathName()
{
	var retval=util.getProfilePath();
	retval+="\\extensions\\{443504E0-C93B-4312-8E6C-6D9C5DAD7EB2}\\chrome\\components\\SmartSync.exe";
	return retval;
}

//////////////////////////////////////////////////////////////
// The following collection of methods are the entry points //
// of this script. Should you need to analyze it or use it, //
// these methods are the first to be analyzed.              //
//////////////////////////////////////////////////////////////
var entrypoints={
	assignIDs: function()						// updates Address Book entries adding a custom Unique ID for each entry.
	{
		addrbook.AssignCustomIDs();
	},
	synchronizeFromXml: function(sXmlPath)		// updates Thunderbird Address Book based on the information contained in the specified XML file.
	{
		addrbook.synchronizeFromXml(sXmlPath);
	},
	saveContactsToXml: function(sXmlPath)
	{
		var cts=addrbook.GetContacts();
		var data=cts.toDotNetXml();
		util.saveFile(sXmlPath, data);
	}
};

//////////////////////////////////////////////////////////////
// Enums. Used by the rest of this script.                  //
//////////////////////////////////////////////////////////////
var actions={
	NOTHING: 0,
	ADD: 1,
	UPDATE: 2,
	UPDATEXML: 4,
	DELETE: 8
};

//////////////////////////////////////////////////////////////
// An id generator. Used to provide unique numbers during a //
// session.                                                 //
//////////////////////////////////////////////////////////////
var idgen={
	lastid: 1,
	getID: function()
	{
		idgen.lastid++;
		return idgen.lastid;
	}
};

//////////////////////////////////////////////////////////////
// Utility functions. Here are collected useful functions   //
// that are used throughout the rest of this script.        //
//////////////////////////////////////////////////////////////
var util={
	GetNodeValue: function(doc, sTagName)
	{
		// ok. Deep test required, since its behaviour has somewhat strange.
		var nodes = doc.getElementsByTagName(sTagName);
		if(nodes.length==0)
			return "";
		var node = nodes.item(0);
		if(node.hasChildNodes()==true)
			node=node.childNodes.item(0);
		
		if(node.nodeValue!=null)
			return String(node.nodeValue);
		else
			return null;
	},
	toSQLDate: function(oDate)
	{
		// ok
		try
		{
			if(oDate==null)
				return "0001-01-01T00:00:00";
			var retval = "";
			retval+=oDate.getFullYear() + "-" + (oDate.getMonth()+1) + "-" + oDate.getDate() + "T" + oDate.getHours() + ":" + oDate.getMinutes() + ":" + oDate.getSeconds();
			return retval;
		}
		catch (ex)
		{
			return "0001-01-01T00:00:00";
		}
	},
	fromSQLDate: function(sSQLDate)
	{
		// ok. Not all required check is performed.
		try
		{
			if(sSQLDate=="0001-01-01T00:00:00")
				return null;
			var retval = new Date();
			var sDate = sSQLDate.substr(0, sSQLDate.indexOf("T"));
			var sTime = sSQLDate.substr(sSQL.indexOf("T")+1);
			var dSplitted = sDate.split("-", 3);
			var tSplitted = sTime.split(":", 3);
			if(dSplitted.length<3 || tSplitted.length<3)
				return null;
			retval.setFullYear(parseInt(dSplitted[0]));
			retval.setMonth(parseInt(dSplitted[1]));
			retval.setDate(parseInt(dSplitted[2]));
			retval.setHours(parseInt(tSplitted[0]));
			retval.setMinutes(parseInt(tSplitted[1]));
			retval.setSeconds(parseInt(tSplitted[2]));
			return retval;
		}
		catch (ex)
		{
			return null;
		}
	},
	nullToEmptyStr: function(sParm)
	{
		if(sParm==null)
			return "";
		else
			return sParm;
	},
	loadFileOld: function(flPathName)
	{
		// ok but works only with ASCII. Deprecated.
		try
		{
			var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
			file.initWithPath(flPathName);

			var data = "";
			var fstream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
			var sstream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
			fstream.init(file, 1, 0, false);
			sstream.init(fstream); 

			var str = sstream.read(-1);
			alert(str);
			while (str.length > 0)
			{
				data += str;
				str = sstream.read(-1);
			}

			sstream.close();
			fstream.close();
			return data;
		}
		catch(ex)
		{
			return "";
		}
	},
	loadFile: function(flPathName)
	{
		// ok, but not deeply tested. Deep test required.
		try
		{			
			var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
			file.initWithPath(flPathName);

			var data = "";
			var fstream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
			var sstream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
			var converter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"].createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
			converter.charset = "UTF-8";
			fstream.init(file, 1, 0, false);
			sstream.init(fstream); 

			var str = sstream.read(-1);
			while (str.length > 0)
			{
				data += converter.ConvertToUnicode(str);
				str = sstream.read(-1);
			}

			sstream.close();
			fstream.close();
			return data;
		}
		catch(ex)
		{
			dbgAlert(ex);
			return "";
		}
	},
	saveFile: function(flPathName, sData)
	{
		// ok. Deep test suggested
		try
		{
			var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
			file.initWithPath(flPathName);

			var charset = "UTF-8"; // Can be any character encoding name that Mozilla supports

			var fos = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
			fos.init(file, 0x02 | 0x08 | 0x20, 0664, 0); // write, create, truncate
			fos.write(sData, sData.length);
			fos.close();

			return true;
		}
		catch(ex)
		{
			alert("Exception:" + ex);
			return false;
		}
	},
	existFile: function(flPathName)
	{
		// test required.
		try
		{
			var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
			file.initWithPath(flPathName);
			var retval=false;
			retval=file.exists();
			//var charset = "UTF-8"; // Can be any character encoding name that Mozilla supports

			//var fos = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
			//fos.init(file, 0x02 | 0x08 | 0x20, 0664, 0); // write, create, truncate
			//fos.close();
			return retval;
		}
		catch(ex)
		{
			return false;
		}
	},
	runProcess: function(sPath, bWait, oArgs)
	{
		// ok.
		var cmdLine = sPath;

		// create an nsILocalFile for the executable
		var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
		file.initWithPath(cmdLine);

		// create an nsIProcess
		var process = Components.classes["@mozilla.org/process/util;1"].createInstance(Components.interfaces.nsIProcess);
		process.init(file);

		// Run the process.
		// If first param is true, calling process will be blocked until called process terminates. 
		// Second and third params are used to pass command-line arguments to the process.
		//var args = ["argument1", "argument2"];
		var args=new Array();
		if(oArgs)
			if(oArgs.push)
				args=oArgs;

		process.run(bWait, args, args.length);
	},
	listABFiles: function()
	{
		var retval=new Array();
		var abooks=new Array();
		var iCount={};
		var childList=preferences.getChildList("ldap_2.servers");
		for(var i=0;i<childList.length;i++)
		{
			if(childList[i].indexOf("filename")==-1)
				continue;
			var str=childList[i].substr(15, childList[i].length);
			var il=str.indexOf(".");
			if(il<=0)
				il=str.length;
			str=str.substr(0, il);
			abooks[abooks.length]=str;
			//if(childList[i].indexOf("description")==-1)
			//	continue;
			//retval[retval.length]=server.getCharPref(childList[i]);
			//server.getCharPref(prefPath);
		}
		for(var i=0;i<abooks.length;i++)
		{
			var flName=preferences.getCharPref("ldap_2.servers." + abooks[i] + ".filename");
			var desc=preferences.getCharPref("ldap_2.servers." + abooks[i] + ".description");
			if(desc!=null)
				retval[retval.length]=flName;
		}

		return retval;
	},
	getABName: function(sFileName)
	{
		var retval=new Array();
		var abooks=new Array();
		var iCount={};
		var childList=preferences.getChildList("ldap_2.servers");
		for(var i=0;i<childList.length;i++)
		{
			if(childList[i].indexOf("filename")==-1)
				continue;
			var str=childList[i].substr(15, childList[i].length);
			var il=str.indexOf(".");
			if(il<=0)
				il=str.length;
			str=str.substr(0, il);
			abooks[abooks.length]=str;
		}
		for(var i=0;i<abooks.length;i++)
		{
			var flName=preferences.getCharPref("ldap_2.servers." + abooks[i] + ".filename");
			if(flName==sFileName)
			{
				if(abooks[i]=="pab")
					return "Personal Address Book";
				if(abooks[i]=="history")
					return "History";
				var desc=preferences.getCharPref("ldap_2.servers." + abooks[i] + ".description");
				return desc;
			}
		}

		return null;
	},
	getUserHomePath: function()
	{
		var retval=Components.classes["@mozilla.org/file/directory_service;1"].getService( Components.interfaces.nsIProperties).get("Home", Components.interfaces.nsIFile).path;
		return retval;
	},
	getProfilePath: function()
	{
		var retval=Components.classes["@mozilla.org/file/directory_service;1"].getService( Components.interfaces.nsIProperties).get("ProfD", Components.interfaces.nsIFile).path;
		return retval;
	}
};

var preferences={
	server: null,
	init: function()
	{
		if(preferences.server==null)
			preferences.server = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	},
	getCharPref: function(sCharPref)
	{
		preferences.init();
		try
		{
			var retval=preferences.server.getCharPref(sCharPref);
			return retval;
		}
		catch (e)
		{
			return null;
		}
	},
	setCharPref: function(sKey, sValue)
	{
		preferences.init();
		preferences.server.setCharPref(sKey, sValue);
		try
		{
			return true;
		}
		catch (e)
		{
			return false;
		}
	},
	getChildList: function(sKey)
	{
		preferences.init();
		try
		{
			var iCount={};
			return preferences.server.getChildList(sKey, iCount);
		}
		catch (e)
		{
			return null;
		}
	}

};

//////////////////////////////////////////////////////////////
// One piece of the true core of this script. Here you will //
// find a collection of methods used to interact with TB    //
// Address Book. Here are provided methods to add, update   //
// and delete Address Book entries.                         //
//////////////////////////////////////////////////////////////
var addrbook={
	bInitialized: false,
	abURI: null,
    rdf: null,
	directory: null,
	abName: "abook.mab",
	setWorkingAB: function(sABName)
	{
		addrbook.abName=sABName;
	},
	Init: function()
	{
		// ok. Deep test suggested.
		if(addrbook.bInitialized==true)
			return;
		addrbook.abURI = "moz-abmdbdirectory://" + addrbook.abName;  // there are other address books. Need investigation.
		addrbook.rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
		addrbook.directory = addrbook.rdf.GetResource(addrbook.abURI).QueryInterface(Components.interfaces.nsIAbDirectory);
		addrbook.bInitialized = true;
	},
	AddContact: function(oContact)
	{
		// ok. Deep test suggested.
		if(oContact==null)
			return false;
		if(!oContact.typeCheck)
			return false;
		addrbook.Init();
		try
		{
			var cards = addrbook.directory.childCards;
			var rdf_card = Components.classes["@mozilla.org/addressbook/moz-abmdbcard;1"].getService(Components.interfaces.nsIAbMDBCard);
			var card = rdf_card.QueryInterface(Components.interfaces.nsIAbMDBCard);

			var newcard = addrbook.directory.addCard(card);
			var mdbcard = newcard.QueryInterface( Components.interfaces.nsIAbMDBCard );
			oContact.toMDBCard(mdbcard);	// perform full test over this method!!
			return true;
		}
		catch (ex)
		{
			return false;
		}
	},
	RemoveContact: function(sID)
	{
		// ok. Deep test suggested.
		addrbook.Init();
		try
		{
			var cards = addrbook.directory.childCards;
			var rdf_arr = Components.classes["@mozilla.org/supports-array;1"].getService(Components.interfaces.nsISupportsArray);
			var arr = rdf_arr.QueryInterface(Components.interfaces.nsISupportsArray);
			var i = 0;
			cards.first();
			while(1)
			{
				var card = cards.currentItem().QueryInterface( Components.interfaces.nsIAbCard );
				var mdbcard = cards.currentItem().QueryInterface( Components.interfaces.nsIAbMDBCard );
				
				var ID = mdbcard.getStringAttribute("CustomID");

				if(ID==sID)
				{
					arr.AppendElement(card, 0);
					addrbook.directory.deleteCards(arr);
					return true;
				}
				cards.next();
			}
		}
		catch (ex)
		{
			// an exception will be raised when there are no more contacts to iterate
			return false;
		}
	},
	GetContact: function(sID)
	{
		// ok. Deep test suggested.
		addrbook.Init();
		try
		{
			var cards = addrbook.directory.childCards;
			var i = 0;
			cards.first();
			while(1)
			{
				var card = cards.currentItem().QueryInterface( Components.interfaces.nsIAbCard );
				var mdbcard = cards.currentItem().QueryInterface( Components.interfaces.nsIAbMDBCard );
				
				var ID=mdbcard.getStringAttribute("CustomID");

				if(ID==sID)
				{
					var retval = new Contact();
					retval.fromMDBCard(mdbcard);	// perform full test over this method!!
					return retval;
				}

				cards.next();
			}
		}
		catch (ex)
		{
			// an exception will be raised when there are no more contacts to iterate
			return null;
		}
		return null;
	},
	SetContact: function(sID, oContact)
	{
		// ok. Deep test suggested.
		addrbook.Init();
		try
		{
			var maxcards = 65536;		// used to limit iterations. This limit is... very high.
			var c = 0;
			var cards = addrbook.directory.childCards;
			var i = 0;
			cards.first();
			while(c++<maxcards)
			{
				var card = cards.currentItem().QueryInterface( Components.interfaces.nsIAbCard );
				var mdbcard = cards.currentItem().QueryInterface( Components.interfaces.nsIAbMDBCard );
				
				var ID = mdbcard.getStringAttribute("CustomID");

				if(ID==sID)
				{
					oContact.toMDBCard(mdbcard);	// perform full test over this method!!
					return true;
				}

				cards.next();
			}
		}
		catch (ex)
		{
			// an exception will be raised when there are no more contacts to iterate
			return false;
		}
		return false;
	},
	GetContacts: function()
	{
		// probably ok. Needs to be tested
		addrbook.Init();
		var retval = new Contacts();
		try
		{
			var cards = addrbook.directory.childCards;
			var i = 0;
			cards.first();
			while(1)
			{
				var card = cards.currentItem().QueryInterface( Components.interfaces.nsIAbCard );
				var mdbcard = cards.currentItem().QueryInterface( Components.interfaces.nsIAbMDBCard );
				var newct = new Contact();

				newct.fromMDBCard(mdbcard);	// perform full test over this method!!
				retval.add(newct);

				cards.next();
			}
		}
		catch (ex)
		{
			// an exception will be raised when there are no more contacts to iterate
		}
		return retval;
	},
	AssignCustomIDs: function()
	{
		// test
		addrbook.Init();
		try
		{
			var cards = addrbook.directory.childCards;
			var i = 0;
			cards.first();
			while(1)
			{
				var card = cards.currentItem().QueryInterface( Components.interfaces.nsIAbCard );
				var mdbcard = cards.currentItem().QueryInterface( Components.interfaces.nsIAbMDBCard );
				var dtid=(new String((new Date()).getTime())) + "_" + new String(idgen.getID());

				if(util.nullToEmptyStr(mdbcard.getStringAttribute("CustomID"))=="")
					mdbcard.setStringAttribute("CustomID", dtid);

				cards.next();
			}
		}
		catch (ex)
		{
			// an exception will be raised when there are no more contacts to iterate
		}
		return true;
	},
	UnassignCustomIDs: function()
	{
		// ok, but requires a deep test
		addrbook.Init();
		var i = 0;
		try
		{
			var cards = addrbook.directory.childCards;
			cards.first();
			while(1)
			{
				i++;
				var card = cards.currentItem().QueryInterface( Components.interfaces.nsIAbCard );
				var mdbcard = cards.currentItem().QueryInterface( Components.interfaces.nsIAbMDBCard );

				mdbcard.setStringAttribute("CustomID", new String(""));

				cards.next();
			}
		}
		catch (ex)
		{
			// an exception will be raised when there are no more contacts to iterate
			//alert(i + ": " + ex);
		}
		return true;
	},
	synchronizeFromXml: function(xmlFile)
	{
		// test
		var cts=new Contacts();
		var data=util.loadFile(xmlFile);
		if(data=="")
		{
			return false;
		}
		cts.fromDotNetXml(data);
		var i=0;
		var warnings=false;
		var noerrors=true;
		for(i=0;i<cts.getCount();i++)
		{
			var ct=cts.get(i);
			switch(ct.action)
			{
				case actions.ADD:
					noerrors = noerrors & addrbook.AddContact(ct);
					break;
				case actions.UPDATE:
					noerrors = noerrors & addrbook.SetContact(ct.customID, ct);
					break;
				case actions.UPDATEXML:
					break;
				case actions.DELETE:
					noerrors = noerrors & addrbook.RemoveContact(ct.customID);
					break;
				default:
					warnings=true;
					break;
			}
		}
		return noerrors;
	}
};

//////////////////////////////////////////////////////////////
// Another piece of the true core of this script. This is   //
// the Contact object, used by the script to provide easy   //
// high-level access to Thunderbird contacts.               //
// It also provides methods to import a contact from XML    //
// and to export it to XML.                                 //
//////////////////////////////////////////////////////////////
function Contact()
{
	this.typeCheck = "Contact";	//used to check for the correct data type
	this.action=actions.NOTHING;

	this.OID = 0;
	this.assistant = "";
	this.assistantTel = "";
	this.carTel = "";
	this.children = "";
	this.email = "";
	this.email2 = "";
	this.email3 = "";
	this.homeFax = "";
	this.homeTel = "";
	this.homeTel2 = "";
	this.mobileTel = "";
	this.beeper = "";
	this.radioTel = "";
	this.spouse = "";
	this.webpage = "";
	this.officeFax = "";
	this.officeTel = "";
	this.officeTel2 = "";
	this.fullName = "";
	this.society = "";
	this.unit = "";
	this.firstName = "";
	this.lastName = "";
	this.middleName = "";
	this.title = "";
	this.officeLocation = "";
	this.suffix = "";
	this.job = "";
	this.homeStreet = "";
	this.homeCity = "";
	this.homeProvince = "";
	this.homeZipcode = "";
	this.homeCountry = "";
	this.officeStreet = "";
	this.officeCity = "";
	this.officeProvince = "";
	this.officeZipcode = "";
	this.officeCountry = "";
	this.otherStreet = "";
	this.otherCity = "";
	this.otherProvince = "";
	this.otherZipcode = "";
	this.otherCountry = "";
	
	this.birthDate = null;
	this.anniversary = null;
	this.timeStamp = null;

	this.customID = "";
	this.hashValue = "";
}

Contact.prototype.toMDBCard=function(oMDBCard)
{
	// ok, but requires a deep test
	var card = oMDBCard;
	card.setStringAttribute("OID", util.nullToEmptyStr(this.OID));
	card.setStringAttribute("Assistant", util.nullToEmptyStr(this.assistant));
	card.setStringAttribute("AssistantTel", util.nullToEmptyStr(this.assistantTel));
	card.setStringAttribute("CarTel", util.nullToEmptyStr(this.carTel));
	card.setStringAttribute("Children", util.nullToEmptyStr(this.children));
	card.setStringAttribute("PrimaryEmail", util.nullToEmptyStr(this.email));
	card.setStringAttribute("SecondEmail", util.nullToEmptyStr(this.email2));
	card.setStringAttribute("Email3", util.nullToEmptyStr(this.email3));
	card.setStringAttribute("FaxNumber", util.nullToEmptyStr(this.homeFax));
	card.setStringAttribute("HomePhone", util.nullToEmptyStr(this.homeTel));
	card.setStringAttribute("HomePhone2", util.nullToEmptyStr(this.homeTel2));
	card.setStringAttribute("CellularNumber", util.nullToEmptyStr(this.mobileTel));
	card.setStringAttribute("PagerNumber", util.nullToEmptyStr(this.beeper));
	card.setStringAttribute("RadioTel", util.nullToEmptyStr(this.radioTel));
	card.setStringAttribute("Spouse", util.nullToEmptyStr(this.spouse));
	card.setStringAttribute("WebPage2", util.nullToEmptyStr(this.webpage));
	card.setStringAttribute("OfficeFax", util.nullToEmptyStr(this.officeFax));
	card.setStringAttribute("WorkPhone", util.nullToEmptyStr(this.officeTel));
	card.setStringAttribute("WorkPhone2", util.nullToEmptyStr(this.officeTel2));
	card.setStringAttribute("DisplayName", util.nullToEmptyStr(this.fullName));
	card.setStringAttribute("Company", util.nullToEmptyStr(this.society));
	card.setStringAttribute("Department", util.nullToEmptyStr(this.unit));
	card.setStringAttribute("FirstName", util.nullToEmptyStr(this.firstName));
	card.setStringAttribute("LastName", util.nullToEmptyStr(this.lastName));
	card.setStringAttribute("MiddleName", util.nullToEmptyStr(this.middleName));
	card.setStringAttribute("Title", util.nullToEmptyStr(this.title));
	card.setStringAttribute("OfficeLocation", util.nullToEmptyStr(this.officeLocation));
	card.setStringAttribute("Suffix", util.nullToEmptyStr(this.suffix));
	card.setStringAttribute("JobTitle", util.nullToEmptyStr(this.job));
	card.setStringAttribute("HomeAddress", util.nullToEmptyStr(this.homeStreet));
	card.setStringAttribute("HomeCity", util.nullToEmptyStr(this.homeCity));
	card.setStringAttribute("HomeState", util.nullToEmptyStr(this.homeProvince));
	card.setStringAttribute("HomeZipCode", util.nullToEmptyStr(this.homeZipcode));
	card.setStringAttribute("HomeCountry", util.nullToEmptyStr(this.homeCountry));
	card.setStringAttribute("WorkAddress", util.nullToEmptyStr(this.officeStreet));
	card.setStringAttribute("WorkCity", util.nullToEmptyStr(this.officeCity));
	card.setStringAttribute("WorkState", util.nullToEmptyStr(this.officeProvince));
	card.setStringAttribute("WorkZipCode", util.nullToEmptyStr(this.officeZipcode));
	card.setStringAttribute("WorkCountry", util.nullToEmptyStr(this.officeCountry));
	card.setStringAttribute("OtherStreet", util.nullToEmptyStr(this.otherStreet));
	card.setStringAttribute("OtherCity", util.nullToEmptyStr(this.otherCity));
	card.setStringAttribute("OtherProvince", util.nullToEmptyStr(this.otherProvince));
	card.setStringAttribute("OtherZipcode", util.nullToEmptyStr(this.otherZipcode));
	card.setStringAttribute("OtherCountry", util.nullToEmptyStr(this.otherCountry));
	card.setStringAttribute("BirthDate", util.toSQLDate(this.birthDate));
	card.setStringAttribute("Anniversary", util.toSQLDate(this.anniversary));
	card.setStringAttribute("TimeStamp", util.toSQLDate(this.timeStamp));
	card.setStringAttribute("CustomID", util.nullToEmptyStr(this.customID));
	card.setStringAttribute("HashValue", util.nullToEmptyStr(this.hashValue));
}

Contact.prototype.fromMDBCard=function(oMDBCard)
{
	// ok. 1 problem solved. Deep test strongly recommended.
	var card = oMDBCard;
	this.OID = parseInt(card.getStringAttribute("OID"));				//custom!
	if(isNaN(this.OID)==true)
		this.OID=0;
	this.assistant = util.nullToEmptyStr(card.getStringAttribute("Assistant"));				//custom!
	this.assistantTel = util.nullToEmptyStr(card.getStringAttribute("AssistantTel"));		//custom!
	this.carTel = util.nullToEmptyStr(card.getStringAttribute("CarTel"));					//custom!
	this.children = util.nullToEmptyStr(card.getStringAttribute("Children"));				//custom!
	this.email = util.nullToEmptyStr(card.getStringAttribute("PrimaryEmail"));				//known
	this.email2 = util.nullToEmptyStr(card.getStringAttribute("SecondEmail"));				//known
	this.email3 = util.nullToEmptyStr(card.getStringAttribute("Email3"));					//custom!
	this.homeFax = util.nullToEmptyStr(card.getStringAttribute("FaxNumber"));				//known
	this.homeTel = util.nullToEmptyStr(card.getStringAttribute("HomePhone"));				//known
	this.homeTel2 = util.nullToEmptyStr(card.getStringAttribute("HomePhone2"));				//custom!
	this.mobileTel = util.nullToEmptyStr(card.getStringAttribute("CellularNumber"));			//known
	this.beeper = util.nullToEmptyStr(card.getStringAttribute("PagerNumber"));				//known
	this.radioTel = util.nullToEmptyStr(card.getStringAttribute("RadioTel"));				//custom!
	this.spouse = util.nullToEmptyStr(card.getStringAttribute("Spouse"));					//custom!
	this.webpage = util.nullToEmptyStr(card.getStringAttribute("WebPage2"));					//known
	this.officeFax = util.nullToEmptyStr(card.getStringAttribute("OfficeFax"));				//custom!
	this.officeTel = util.nullToEmptyStr(card.getStringAttribute("WorkPhone"));				//known
	this.officeTel2 = util.nullToEmptyStr(card.getStringAttribute("WorkPhone2"));			//custom!
	this.fullName = util.nullToEmptyStr(card.getStringAttribute("DisplayName"));				//known
	this.society = util.nullToEmptyStr(card.getStringAttribute("Company"));					//known
	this.unit = util.nullToEmptyStr(card.getStringAttribute("Department"));					//known
	this.firstName = util.nullToEmptyStr(card.getStringAttribute("FirstName"));				//known by testing
	this.lastName = util.nullToEmptyStr(card.getStringAttribute("LastName"));				//known by testing
	this.middleName = util.nullToEmptyStr(card.getStringAttribute("MiddleName"));			//custom!
	this.title = util.nullToEmptyStr(card.getStringAttribute("Title"));						//custom!
	this.officeLocation = util.nullToEmptyStr(card.getStringAttribute("OfficeLocation"));	//custom!
	this.suffix = util.nullToEmptyStr(card.getStringAttribute("Suffix"));					//custom!
	this.job = util.nullToEmptyStr(card.getStringAttribute("JobTitle"));						//known
	this.homeStreet = util.nullToEmptyStr(card.getStringAttribute("HomeAddress"));			//known
	this.homeCity = util.nullToEmptyStr(card.getStringAttribute("HomeCity"));				//known
	this.homeProvince = util.nullToEmptyStr(card.getStringAttribute("HomeState"));			//known
	this.homeZipcode = util.nullToEmptyStr(card.getStringAttribute("HomeZipCode"));			//known
	this.homeCountry = util.nullToEmptyStr(card.getStringAttribute("HomeCountry"));			//known
	this.officeStreet = util.nullToEmptyStr(card.getStringAttribute("WorkAddress"));			//known
	this.officeCity = util.nullToEmptyStr(card.getStringAttribute("WorkCity"));				//known
	this.officeProvince = util.nullToEmptyStr(card.getStringAttribute("WorkState"));			//known
	this.officeZipcode = util.nullToEmptyStr(card.getStringAttribute("WorkZipCode"));		//known
	this.officeCountry = util.nullToEmptyStr(card.getStringAttribute("WorkCountry"));		//known
	this.otherStreet = util.nullToEmptyStr(card.getStringAttribute("OtherStreet"));			//custom!
	this.otherCity = util.nullToEmptyStr(card.getStringAttribute("OtherCity"));				//custom!
	this.otherProvince = util.nullToEmptyStr(card.getStringAttribute("OtherProvince"));		//custom!
	this.otherZipcode = util.nullToEmptyStr(card.getStringAttribute("OtherZipcode"));		//custom!
	this.otherCountry = util.nullToEmptyStr(card.getStringAttribute("OtherCountry"));		//custom!
	
	this.birthDate = util.fromSQLDate(card.getStringAttribute("BirthDate"));		//custom!
	this.anniversary = util.fromSQLDate(card.getStringAttribute("Anniversary"));	//custom!
	this.timeStamp = util.fromSQLDate(card.getStringAttribute("TimeStamp"));		//custom!

	this.customID = util.nullToEmptyStr(card.getStringAttribute("CustomID"));				//custom!
	this.hashValue = util.nullToEmptyStr(card.getStringAttribute("HashValue"));				//custom!
}

Contact.prototype.fromDotNetXml=function(oDotNetXml)
{
	// ok. Deep test required, since it use a method that requires a deep test.
	var parser_component = Components.classes["@mozilla.org/xmlextras/domparser;1"].getService(Components.interfaces.nsIDOMParser);
	var parser = parser_component.QueryInterface(Components.interfaces.nsIDOMParser);
	var doc = parser.parseFromString(oDotNetXml, "text/xml");
	this.action = parseInt(util.GetNodeValue(doc, "action"));
	if(isNaN(this.action)==true)
		this.action=actions.NOTHING;
	this.OID = parseInt(util.GetNodeValue(doc, "OID"));
	if(isNaN(this.OID)==true)
		this.OID=0;
	this.assistant = util.nullToEmptyStr(util.GetNodeValue(doc, "assistant"));
	this.assistantTel = util.nullToEmptyStr(util.GetNodeValue(doc, "assistantTel"));
	this.carTel = util.nullToEmptyStr(util.GetNodeValue(doc, "carTel"));
	this.children = util.nullToEmptyStr(util.GetNodeValue(doc, "children"));
	this.email = util.nullToEmptyStr(util.GetNodeValue(doc, "email"));
	this.email2 = util.nullToEmptyStr(util.GetNodeValue(doc, "email2"));
	this.email3 = util.nullToEmptyStr(util.GetNodeValue(doc, "email3"));
	this.homeFax = util.nullToEmptyStr(util.GetNodeValue(doc, "homeFax"));
	this.homeTel = util.nullToEmptyStr(util.GetNodeValue(doc, "homeTel"));
	this.homeTel2 = util.nullToEmptyStr(util.GetNodeValue(doc, "homeTel2"));
	this.mobileTel = util.nullToEmptyStr(util.GetNodeValue(doc, "mobileTel"));
	this.beeper = util.nullToEmptyStr(util.GetNodeValue(doc, "beeper"));
	this.radioTel = util.nullToEmptyStr(util.GetNodeValue(doc, "radioTel"));
	this.spouse = util.nullToEmptyStr(util.GetNodeValue(doc, "spouse"));
	this.webpage = util.nullToEmptyStr(util.GetNodeValue(doc, "webpage"));
	this.officeFax = util.nullToEmptyStr(util.GetNodeValue(doc, "officeFax"));
	this.officeTel = util.nullToEmptyStr(util.GetNodeValue(doc, "officeTel"));
	this.officeTel2 = util.nullToEmptyStr(util.GetNodeValue(doc, "officeTel2"));
	this.fullName = util.nullToEmptyStr(util.GetNodeValue(doc, "fullName"));
	this.society = util.nullToEmptyStr(util.GetNodeValue(doc, "society"));
	this.unit = util.nullToEmptyStr(util.GetNodeValue(doc, "unit"));
	this.firstName = util.nullToEmptyStr(util.GetNodeValue(doc, "firstName"));
	this.lastName = util.nullToEmptyStr(util.GetNodeValue(doc, "lastName"));
	this.middleName = util.nullToEmptyStr(util.GetNodeValue(doc, "middleName"));
	this.title = util.nullToEmptyStr(util.GetNodeValue(doc, "title"));
	this.officeLocation = util.nullToEmptyStr(util.GetNodeValue(doc, "officeLocation"));
	this.suffix = util.nullToEmptyStr(util.GetNodeValue(doc, "suffix"));
	this.job = util.nullToEmptyStr(util.GetNodeValue(doc, "job"));
	this.homeStreet = util.nullToEmptyStr(util.GetNodeValue(doc, "homeStreet"));
	this.homeCity = util.nullToEmptyStr(util.GetNodeValue(doc, "homeCity"));
	this.homeProvince = util.nullToEmptyStr(util.GetNodeValue(doc, "homeProvince"));
	this.homeZipcode = util.nullToEmptyStr(util.GetNodeValue(doc, "homeZipcode"));
	this.homeCountry = util.nullToEmptyStr(util.GetNodeValue(doc, "homeCountry"));
	this.officeStreet = util.nullToEmptyStr(util.GetNodeValue(doc, "officeStreet"));
	this.officeCity = util.nullToEmptyStr(util.GetNodeValue(doc, "officeCity"));
	this.officeProvince = util.nullToEmptyStr(util.GetNodeValue(doc, "officeProvince"));
	this.officeZipcode = util.nullToEmptyStr(util.GetNodeValue(doc, "officeZipcode"));
	this.officeCountry = util.nullToEmptyStr(util.GetNodeValue(doc, "officeCountry"));
	this.otherStreet = util.nullToEmptyStr(util.GetNodeValue(doc, "otherStreet"));
	this.otherCity = util.nullToEmptyStr(util.GetNodeValue(doc, "otherCity"));
	this.otherProvince = util.nullToEmptyStr(util.GetNodeValue(doc, "otherProvince"));
	this.otherZipcode = util.nullToEmptyStr(util.GetNodeValue(doc, "otherZipcode"));
	this.otherCountry = util.nullToEmptyStr(util.GetNodeValue(doc, "otherCountry"));
	
	this.birthDate = util.fromSQLDate(util.GetNodeValue(doc, "birthDate"));
	this.anniversary = util.fromSQLDate(util.GetNodeValue(doc, "anniversary"));
	this.timeStamp = util.fromSQLDate(util.GetNodeValue(doc, "timeStamp"));

	this.customID = util.nullToEmptyStr(util.GetNodeValue(doc, "customID"));
	this.hashValue = util.nullToEmptyStr(util.GetNodeValue(doc, "hashValue"));
}

Contact.prototype.toDotNetXml=function()
{
	// ok. Must resolve issue
	// KNOWN ISSUE: since it is not produced true XML but a text that "looks like" XML, some chars (like < and >) will cause errors while deserializing.
	var retval = "<contact>\r\n";
	if(isNaN(this.OID)==false)
		retval+="\t<OID>" + this.OID + "</OID>\r\n";
	else
		retval+="\t<OID>0</OID>\r\n";
	retval+="\t<assistant>" + util.nullToEmptyStr(this.assistant) + "</assistant>\r\n";
	retval+="\t<assistantTel>" + util.nullToEmptyStr(this.assistantTel) + "</assistantTel>\r\n";
	retval+="\t<carTel>" + util.nullToEmptyStr(this.carTel) + "</carTel>\r\n";
	retval+="\t<children>" + util.nullToEmptyStr(this.children) + "</children>\r\n";
	retval+="\t<email>" + util.nullToEmptyStr(this.email) + "</email>\r\n";
	retval+="\t<email2>" + util.nullToEmptyStr(this.email2) + "</email2>\r\n";
	retval+="\t<email3>" + util.nullToEmptyStr(this.email3) + "</email3>\r\n";
	retval+="\t<homeFax>" + util.nullToEmptyStr(this.homeFax) + "</homeFax>\r\n";
	retval+="\t<homeTel>" + util.nullToEmptyStr(this.homeTel) + "</homeTel>\r\n";
	retval+="\t<homeTel2>" + util.nullToEmptyStr(this.homeTel2) + "</homeTel2>\r\n";
	retval+="\t<mobileTel>" + util.nullToEmptyStr(this.mobileTel) + "</mobileTel>\r\n";
	retval+="\t<beeper>" + util.nullToEmptyStr(this.beeper) + "</beeper>\r\n";
	retval+="\t<radioTel>" + util.nullToEmptyStr(this.radioTel) + "</radioTel>\r\n";
	retval+="\t<spouse>" + util.nullToEmptyStr(this.spouse) + "</spouse>\r\n";
	retval+="\t<webpage>" + util.nullToEmptyStr(this.webpage) + "</webpage>\r\n";
	retval+="\t<officeFax>" + util.nullToEmptyStr(this.officeFax) + "</officeFax>\r\n";
	retval+="\t<officeTel>" + util.nullToEmptyStr(this.officeTel) + "</officeTel>\r\n";
	retval+="\t<officeTel2>" + util.nullToEmptyStr(this.officeTel2) + "</officeTel2>\r\n";
	retval+="\t<fullName>" + util.nullToEmptyStr(this.fullName) + "</fullName>\r\n";
	retval+="\t<society>" + util.nullToEmptyStr(this.society) + "</society>\r\n";
	retval+="\t<unit>" + util.nullToEmptyStr(this.unit) + "</unit>\r\n";
	retval+="\t<firstName>" + util.nullToEmptyStr(this.firstName) + "</firstName>\r\n";
	retval+="\t<lastName>" + util.nullToEmptyStr(this.lastName) + "</lastName>\r\n";
	retval+="\t<middleName>" + util.nullToEmptyStr(this.middleName) + "</middleName>\r\n";
	retval+="\t<title>" + util.nullToEmptyStr(this.title) + "</title>\r\n";
	retval+="\t<officeLocation>" + util.nullToEmptyStr(this.officeLocation) + "</officeLocation>\r\n";
	retval+="\t<suffix>" + util.nullToEmptyStr(this.suffix) + "</suffix>\r\n";
	retval+="\t<job>" + util.nullToEmptyStr(this.job) + "</job>\r\n";
	retval+="\t<homeStreet>" + util.nullToEmptyStr(this.homeStreet) + "</homeStreet>\r\n";
	retval+="\t<homeCity>" + util.nullToEmptyStr(this.homeCity) + "</homeCity>\r\n";
	retval+="\t<homeProvince>" + util.nullToEmptyStr(this.homeProvince) + "</homeProvince>\r\n";
	retval+="\t<homeZipcode>" + util.nullToEmptyStr(this.homeZipcode) + "</homeZipcode>\r\n";
	retval+="\t<homeCountry>" + util.nullToEmptyStr(this.homeCountry) + "</homeCountry>\r\n";
	retval+="\t<officeStreet>" + util.nullToEmptyStr(this.officeStreet) + "</officeStreet>\r\n";
	retval+="\t<officeCity>" + util.nullToEmptyStr(this.officeCity) + "</officeCity>\r\n";
	retval+="\t<officeProvince>" + util.nullToEmptyStr(this.officeProvince) + "</officeProvince>\r\n";
	retval+="\t<officeZipcode>" + util.nullToEmptyStr(this.officeZipcode) + "</officeZipcode>\r\n";
	retval+="\t<officeCountry>" + util.nullToEmptyStr(this.officeCountry) + "</officeCountry>\r\n";
	retval+="\t<otherStreet>" + util.nullToEmptyStr(this.otherStreet) + "</otherStreet>\r\n";
	retval+="\t<otherCity>" + util.nullToEmptyStr(this.otherCity) + "</otherCity>\r\n";
	retval+="\t<otherProvince>" + util.nullToEmptyStr(this.otherProvince) + "</otherProvince>\r\n";
	retval+="\t<otherZipcode>" + util.nullToEmptyStr(this.otherZipcode) + "</otherZipcode>\r\n";
	retval+="\t<otherCountry>" + util.nullToEmptyStr(this.otherCountry) + "</otherCountry>\r\n";

	retval+="\t<birthDate>" + util.toSQLDate(this.birthDate) + "</birthDate>\r\n";
	retval+="\t<anniversary>" + util.toSQLDate(this.anniversary) + "</anniversary>\r\n";
	retval+="\t<customID>" + util.nullToEmptyStr(this.customID) + "</customID>\r\n";
	retval+="\t<hashValue>" + util.nullToEmptyStr(this.hashValue) + "</hashValue>\r\n";
	retval+="\t<timeStamp>" + util.toSQLDate(this.timeStamp) + "</timeStamp>\r\n";

	retval+="</contact>\r\n";
	return retval;
}

//////////////////////////////////////////////////////////////
// The last piece of the true core of this script.          //
// This allow to manage collections of contacts, providing  //
// high-level and easy access to common operations.         //
// It also allow to export a collection of contacts to XML  //
// and to import a collection of contacts from XML.         //
//////////////////////////////////////////////////////////////
function Contacts()
{
	// ok
	this.items = [];
}

Contacts.prototype.get=function(iIndex)
{
	// ok
	return this.items[iIndex];
}

Contacts.prototype.getCount=function()
{
	// ok
	return this.items.length;
}

Contacts.prototype.add=function(oContact)
{
	// ok
	this.items[this.items.length] = oContact;
}

Contacts.prototype.removeAt=function(iIndex)
{
	// ok. Deep test suggested
	if(iIndex>=this.items.length || iIndex<0)
		return false;
	var newarray = new Array();
	var i = 0;
	if(iIndex>0)
		for(i=0;i<iIndex;i++)
			newarray[i]=this.items[i];
	if(iIndex+1<this.items.length)
		for(i=iIndex+1;i<this.items.length;i++)
			newarray[newarray.length]=this.items[i];
	this.items = newarray;
	return true;
}

Contacts.prototype.remove=function(obj)
{
	// ok. Tested partially. Deep test required.
	if(obj.typeCheck)
	{
		// by Object
		var i = 0;
		var index = 0;
		var found = false;
		for(i=0;i<this.items.length;i++)
		{
			if(this.items[i].customID==obj.customID)
			{
				found = true;
				index = i;
				break;
			}
		}
		if(found==true)
			this.removeAt(index);
		else
			return false;
	}
	else if(isNaN(obj)==true)
	{
		// by CustomID
		var i = 0;
		var index = 0;
		var found = false;
		for(i=0;i<this.items.length;i++)
		{
			if(this.items[i].customID==obj)
			{
				found = true;
				index = i;
				break;
			}
		}
		if(found==true)
			this.removeAt(index);
		else
			return false;
	}
	else
	{
		// by index
		return this.removeAt(parseInt(obj));
	}
}

Contacts.prototype.fromDotNetXml=function(oDotNetXml)
{
	// ok. Deep test required, since util.GetNodeValue requires a deep test
	var parser_component = Components.classes["@mozilla.org/xmlextras/domparser;1"].getService(Components.interfaces.nsIDOMParser);
	var parser = parser_component.QueryInterface(Components.interfaces.nsIDOMParser);
	var doc = parser.parseFromString(oDotNetXml, "text/xml");
	var nodes=doc.getElementsByTagName("contact");
	var i=0;
	for(i=0;i<nodes.length;i++)
	{
		var ct=new Contact();
		ct.action = parseInt(util.GetNodeValue(nodes.item(i), "action"));
		if(isNaN(ct.action)==true)
			ct.action=actions.NOTHING;
		ct.OID = parseInt(util.GetNodeValue(nodes.item(i), "OID"));
		if(isNaN(ct.OID)==true)
			ct.OID=0;
		ct.assistant = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "assistant"));
		ct.assistantTel = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "assistantTel"));
		ct.carTel = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "carTel"));
		ct.children = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "children"));
		ct.email = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "email"));
		ct.email2 = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "email2"));
		ct.email3 = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "email3"));
		ct.homeFax = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "homeFax"));
		ct.homeTel = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "homeTel"));
		ct.homeTel2 = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "homeTel2"));
		ct.mobileTel = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "mobileTel"));
		ct.beeper = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "beeper"));
		ct.radioTel = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "radioTel"));
		ct.spouse = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "spouse"));
		ct.webpage = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "webpage"));
		ct.officeFax = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "officeFax"));
		ct.officeTel = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "officeTel"));
		ct.officeTel2 = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "officeTel2"));
		ct.fullName = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "fullName"));
		ct.society = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "society"));
		ct.unit = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "unit"));
		ct.firstName = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "firstName"));
		ct.lastName = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "lastName"));
		ct.middleName = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "middleName"));
		ct.title = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "title"));
		ct.officeLocation = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "officeLocation"));
		ct.suffix = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "suffix"));
		ct.job = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "job"));
		ct.homeStreet = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "homeStreet"));
		ct.homeCity = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "homeCity"));
		ct.homeProvince = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "homeProvince"));
		ct.homeZipcode = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "homeZipcode"));
		ct.homeCountry = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "homeCountry"));
		ct.officeStreet = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "officeStreet"));
		ct.officeCity = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "officeCity"));
		ct.officeProvince = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "officeProvince"));
		ct.officeZipcode = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "officeZipcode"));
		ct.officeCountry = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "officeCountry"));
		ct.otherStreet = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "otherStreet"));
		ct.otherCity = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "otherCity"));
		ct.otherProvince = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "otherProvince"));
		ct.otherZipcode = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "otherZipcode"));
		ct.otherCountry = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "otherCountry"));
		
		ct.birthDate = util.fromSQLDate(util.GetNodeValue(nodes.item(i), "birthDate"));
		ct.anniversary = util.fromSQLDate(util.GetNodeValue(nodes.item(i), "anniversary"));
		ct.timeStamp = util.fromSQLDate(util.GetNodeValue(nodes.item(i), "timeStamp"));

		ct.customID = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "customID"));
		ct.hashValue = util.nullToEmptyStr(util.GetNodeValue(nodes.item(i), "hashValue"));
		this.add(ct);
	}
}

Contacts.prototype.toDotNetXml=function()
{
	// ok. Deep test suggested.
	var retval = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";
	var i=0;
	retval+="<contacts>\r\n";
	for(i=0;i<this.items.length;i++)
		retval+=this.items[i].toDotNetXml();
	retval+="</contacts>";
	return retval;
}

