<?php header('Content-Type: application/vnd.mozilla.xul+xml'); 

/* XULTech firelog is released under the Mozilla Public License:

   http://www.mozilla.org/MPL/MPL-1.1.html

   Copyright (C) 2006 Akeni Technologies
   http://www.akeni.com
   http://www.xultech.com
*/

echo '<?xml version="1.0"?>';
echo '<?xml-stylesheet href="chrome://global/skin" type="text/css"?>';
echo '<?xml-stylesheet href="chrome://global/content/xul.css" type="text/css"?>';
echo '<?xml-stylesheet href="firelog.css" type="text/css"?>';
?>

<window title="XULTech Firelog Viewer"
        onload="handleLogViewerLoad()"
        xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"
        xmlns:html="http://www.w3.org/1999/xhtml">

<vbox id="log-viewer-main-box" flex="1">

<popupset>
<popup ignorekeys="true">
<vbox id="log-viewer-about-box" flex="1" pack="center">
<spacer flex="3"/>
<hbox pack="center" align="center">
<image src="xultech_logo.png"/>
<vbox>
<label id="log-viewer-about-label" value="Firelog"
       onclick="window.open('http://www.xultech.com')"/>
<html:div id="log-viewer-about-explanation">
<html:b>Fire</html:b>fox <html:b>Log</html:b> 
Viewer version <html:span id="product-version-span">1.0</html:span>
</html:div>
</vbox>
</hbox>
<spacer flex="1"/>
<hbox pack="center">
<button label="OK" onclick="hideAboutPopup()"/>
</hbox>
<spacer flex="1"/>
<label id="log-viewer-about-copyright-label"
       value="Copyright© 2006 Akeni Technologies"
       onclick="window.open('http://www.akeni.com')"/>
</vbox>
</popup>

</popupset>

<commandset>
<command id="help-about-product-command" label="About Firelog"  
         oncommand="setTimeout('displayAboutProduct()', 100)"
         tooltiptext="Display information about this product"/>
<command id="help-license-info-command" label="License Info"
         oncommand="setTimeout('displayProductLicenseInfo()', 100)"
         tooltiptext="Display information about your license"/>
<command id="help-users-guide" label="User's Guide"
         oncommand="helpUsersGuide()"
         tooltiptext="Display User's Guide"/>
<command id="help-product-website" label="XULTech Web Site"
         oncommand="helpProductWebsite()"
         tooltiptext="Go to Product Web Site"/>
<command id="help-product-update" label="Check for Updates..."
         oncommand="helpCheckProductUpdate()"
         tooltiptext="Check for Newer Version"/>
</commandset>


<menubar>
<textbox id="log-viewer-path-textbox" flex="1" editable="true"
         onkeypress="logViewerPathEditKeypress(event)"/>
<toolbarbutton id="go-button" class="go-toolbarbutton"
               oncommand="logViewerLoadPath()"/>
<menu id="help-menu" label="Help" accesskey="H">
<menupopup>
  <menuitem command="help-users-guide"/>
  <menuitem command="help-product-website"/>
  <menuitem command="help-product-update"/>
  <menuseparator/>
  <menuitem command="help-license-info-command"/>
  <menuseparator/>
  <menuitem command="help-about-product-command"/>
</menupopup>
</menu>
</menubar>

<toolbar align="center" pack="center" class="log-viewer">
<!-- toolbarbutton id="go0-button" class="go-toolbarbutton"
               oncommand="logViewerUpdateSliderWithOffsetInput()"/ -->
<textbox id="log-viewer-offset-textbox"
         onkeypress="logViewerFileOffsetEditKeypress(this, event)"/>
<label id="log-viewer-filesize-label"/>
<scrollbar id="log-viewer-offset-slider" orient="horizontal" flex="1"
           oncommand="logViewerSliderPositionUpdate()"
           onmousemove="logViewerSliderPositionUpdate()"
           onclick="logViewerSliderPositionUpdate()"/>
<toolbarbutton id="log-viewer-throbber" class="throbber" stopped="true"
               command="log-viewer-reload-location-command"/>
</toolbar>


<textbox id="log-viewer-content-textbox"
         wrap="off" multiline="true" flex="1"/>
</vbox>

<script src="firelog.js"/>"""

</window>
