/*
  File autogenerated by gengetopt version 2.4  
  generated with the following command:
  /home/lorenzo/usr/local/bin/gengetopt --input cmdline.ggo --unamed-opts --no-handle-help --no-handle-version 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
"Purpose:\n"
"  Highlight the syntax of a source file (e.g. Java) \n"
"  into a specific format (e.g. HTML)\n"
"\n"
"Usage: %s [OPTIONS]... [FILES]...\n\
   -h         --help              Print help and exit\n\
   -V         --version           Print version and exit\n\
   -v         --verbose           verbose mode on\n\
   -d         --doc               create html with title and header\n\
   -cSTRING   --css=STRING        use a css for formatting. Implies --doc\n\
   -TSTRING   --title=STRING      give a title to the html. Implies --doc\n\
   -iSTRING   --input=STRING      input file. default std input\n\
   -oSTRING   --output=STRING     output file. default std output\n\
   -tINT      --tab=INT           specify tab length. default 8\n\
   -HSTRING   --header=STRING     file to insert as header\n\
   -FSTRING   --footer=STRING     file to insert as footer\n\
              --tags-file=STRING  specify format options (def. tags.j2h)\n\
", PACKAGE);
}


static char *
gengetopt_strdup (char * s)
{
  char * n, * pn, * ps = s;
  while (*ps) ps++;
  n = (char *) malloc (1 + ps - s);
  if (n != NULL)
    {
      for (ps=s,pn=n; *ps; ps++,pn++)
        *pn = *ps;
      *pn = 0;
    }
  return n;
}


int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->doc_given = 0 ;
  args_info->css_given = 0 ;
  args_info->title_given = 0 ;
  args_info->input_given = 0 ;
  args_info->output_given = 0 ;
  args_info->tab_given = 0 ;
  args_info->header_given = 0 ;
  args_info->footer_given = 0 ;
  args_info->tags_file_given = 0 ;
#define clear_args() { \
  args_info->css_arg = NULL; \
  args_info->title_arg = NULL; \
  args_info->input_arg = NULL; \
  args_info->output_arg = NULL; \
  args_info->header_arg = NULL; \
  args_info->footer_arg = NULL; \
  args_info->tags_file_arg = NULL; \
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "doc",	0, NULL, 'd' },
        { "css",	1, NULL, 'c' },
        { "title",	1, NULL, 'T' },
        { "input",	1, NULL, 'i' },
        { "output",	1, NULL, 'o' },
        { "tab",	1, NULL, 't' },
        { "header",	1, NULL, 'H' },
        { "footer",	1, NULL, 'F' },
        { "tags-file",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVvdc:T:i:o:t:H:F:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (args_info->help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          if (args_info->version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->version_given = 1;
          return 0;

        case 'v':	/* verbose mode on.  */
          if (args_info->verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->verbose_given = 1;
          break;

        case 'd':	/* create html with title and header.  */
          if (args_info->doc_given)
            {
              fprintf (stderr, "%s: `--doc' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->doc_given = 1;
          break;

        case 'c':	/* use a css for formatting. Implies --doc.  */
          if (args_info->css_given)
            {
              fprintf (stderr, "%s: `--css' (`-c') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->css_given = 1;
          args_info->css_arg = gengetopt_strdup (optarg);
          break;

        case 'T':	/* give a title to the html. Implies --doc.  */
          if (args_info->title_given)
            {
              fprintf (stderr, "%s: `--title' (`-T') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->title_given = 1;
          args_info->title_arg = gengetopt_strdup (optarg);
          break;

        case 'i':	/* input file. default std input.  */
          if (args_info->input_given)
            {
              fprintf (stderr, "%s: `--input' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->input_given = 1;
          args_info->input_arg = gengetopt_strdup (optarg);
          break;

        case 'o':	/* output file. default std output.  */
          if (args_info->output_given)
            {
              fprintf (stderr, "%s: `--output' (`-o') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->output_given = 1;
          args_info->output_arg = gengetopt_strdup (optarg);
          break;

        case 't':	/* specify tab length. default 8.  */
          if (args_info->tab_given)
            {
              fprintf (stderr, "%s: `--tab' (`-t') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->tab_given = 1;
          args_info->tab_arg = atoi (optarg);
          break;

        case 'H':	/* file to insert as header.  */
          if (args_info->header_given)
            {
              fprintf (stderr, "%s: `--header' (`-H') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->header_given = 1;
          args_info->header_arg = gengetopt_strdup (optarg);
          break;

        case 'F':	/* file to insert as footer.  */
          if (args_info->footer_given)
            {
              fprintf (stderr, "%s: `--footer' (`-F') option given more than once\n", PACKAGE);
              clear_args ();
              exit (1);
            }
          args_info->footer_given = 1;
          args_info->footer_arg = gengetopt_strdup (optarg);
          break;

        
        case 0:	/* Long option with no short option */
          /* specify format options (def. tags.j2h).  */
          if (strcmp (long_options[option_index].name, "tags-file") == 0)
          {
            if (args_info->tags_file_given)
              {
                fprintf (stderr, "%s: `--tags-file' option given more than once\n", PACKAGE);
                clear_args ();
                exit (1);
              }
            args_info->tags_file_given = 1;
            args_info->tags_file_arg = gengetopt_strdup (optarg);
            break;
          }

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (1);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if ( missing_required_options )
    exit (1);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }

  return 0;
}
