/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.generic;

import java.util.Collections;
import java.util.List;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassGenericType
implements IGenericType {
    public static final IGenericType OBJECT_CLASS = new ClassGenericType(Object.class, null, null);
    public static final IGenericType STRING_CLASS = new ClassGenericType(String.class, null, null);
    public static final IGenericType INT_CLASS = new ClassGenericType(Integer.TYPE, null, null);
    public static final IGenericType LIST_CLASS = new ClassGenericType(List.class, "java.util.List<java.lang.Object>", null);
    public static final IGenericType WILDCARD = new ClassGenericType(null, "?", "?");
    private final Class<?> m_rawType;
    private final String m_fullName;
    private final String m_simpleName;

    public ClassGenericType(Class<?> rawType, String fullName, String simpleName) {
        this.m_rawType = rawType;
        this.m_fullName = fullName == null ? GenericUtils.convertPrimitiveType(ReflectionUtils.getFullyQualifiedName(this.m_rawType, (boolean)false)) : fullName;
        this.m_simpleName = simpleName == null ? this.m_rawType.getSimpleName() : simpleName;
    }

    @Override
    public Class<?> getRawType() {
        return this.m_rawType;
    }

    @Override
    public String getFullTypeName() {
        return this.m_fullName;
    }

    @Override
    public String getSimpleTypeName() {
        return this.m_simpleName;
    }

    @Override
    public List<IGenericType> getSubTypes() {
        return Collections.emptyList();
    }

    @Override
    public IGenericType getSubType(int index) {
        return OBJECT_CLASS;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }
}

