/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.events.IMouseListener;
import org.eclipse.wb.draw2d.events.IMouseMoveListener;
import org.eclipse.wb.draw2d.events.IMouseTrackListener;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.draw2d.CustomTooltipManager;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.RootFigure;
import org.eclipse.wb.internal.draw2d.TargetFigureFindVisitor;
import org.eclipse.wb.internal.gef.core.CancelOperationError;

public class EventManager
implements MouseListener,
MouseMoveListener,
MouseTrackListener {
    public static final int ANY_BUTTON = 0x380000;
    private final FigureCanvas m_canvas;
    private final RootFigure m_root;
    private Figure m_cursorFigure;
    private Figure m_captureFigure;
    private Cursor m_cursor;
    private boolean m_eventConsumed;
    private static final IListenerInvoker MOUSE_DOWN_INVOKER = new IListenerInvoker(){

        @Override
        public void invokeListener(Object listener, org.eclipse.wb.draw2d.events.MouseEvent event) {
            IMouseListener mouseListener = (IMouseListener)listener;
            mouseListener.mouseDown(event);
        }
    };
    private static final IListenerInvoker MOUSE_UP_INVOKER = new IListenerInvoker(){

        @Override
        public void invokeListener(Object listener, org.eclipse.wb.draw2d.events.MouseEvent event) {
            IMouseListener mouseListener = (IMouseListener)listener;
            mouseListener.mouseUp(event);
        }
    };
    private static final IListenerInvoker MOUSE_DOUBLE_CLICK_INVOKER = new IListenerInvoker(){

        @Override
        public void invokeListener(Object listener, org.eclipse.wb.draw2d.events.MouseEvent event) {
            IMouseListener mouseListener = (IMouseListener)listener;
            mouseListener.mouseDoubleClick(event);
        }
    };
    private static final IListenerInvoker MOUSE_MOVE_INVOKER = new IListenerInvoker(){

        @Override
        public void invokeListener(Object listener, org.eclipse.wb.draw2d.events.MouseEvent event) {
            IMouseMoveListener mouseListener = (IMouseMoveListener)listener;
            mouseListener.mouseMove(event);
        }
    };
    private static final IListenerInvoker MOUSE_ENTER_INVOKER = new IListenerInvoker(){

        @Override
        public void invokeListener(Object listener, org.eclipse.wb.draw2d.events.MouseEvent event) {
            IMouseTrackListener mouseListener = (IMouseTrackListener)listener;
            mouseListener.mouseEnter(event);
        }
    };
    private static final IListenerInvoker MOUSE_EXIT_INVOKER = new IListenerInvoker(){

        @Override
        public void invokeListener(Object listener, org.eclipse.wb.draw2d.events.MouseEvent event) {
            IMouseTrackListener mouseListener = (IMouseTrackListener)listener;
            mouseListener.mouseExit(event);
        }
    };
    private static final IListenerInvoker MOUSE_HOVER_INVOKER = new IListenerInvoker(){

        @Override
        public void invokeListener(Object listener, org.eclipse.wb.draw2d.events.MouseEvent event) {
            IMouseTrackListener mouseListener = (IMouseTrackListener)listener;
            mouseListener.mouseHover(event);
        }
    };
    private static String FLAG_DELAY_EVENTS = "Flag that events to this Control should be delayed";
    private static String KEY_DELAYED_EVENTS = "List of delayed events";

    public EventManager(FigureCanvas canvas) {
        this.m_canvas = canvas;
        this.m_root = this.m_canvas.getRootFigure();
        new CustomTooltipManager(canvas, this);
        Object listener = EventManager.createListenerProxy(this, new Class[]{MouseListener.class, MouseMoveListener.class, MouseTrackListener.class});
        this.m_canvas.addMouseListener((MouseListener)listener);
        this.m_canvas.addMouseMoveListener((MouseMoveListener)listener);
        this.m_canvas.addMouseTrackListener((MouseTrackListener)listener);
    }

    public void updateCursor() {
        if (this.m_cursorFigure == null) {
            this.setCursor(null);
        } else {
            this.setCursor(this.m_cursorFigure.getCursor());
        }
    }

    public void setCursor(Cursor cursor) {
        if (this.m_cursor == null ? cursor == null : this.m_cursor == cursor || this.m_cursor.equals((Object)cursor)) {
            return;
        }
        this.m_cursor = cursor;
        this.m_canvas.setCursor(this.m_cursor);
    }

    protected void updateFigureToolTipText() {
        if (this.m_cursorFigure == null) {
            this.m_canvas.setToolTipText(null);
        } else {
            this.m_canvas.setToolTipText(this.m_cursorFigure.getToolTipText());
        }
    }

    private void setFigureUnderCursor(Figure figure, MouseEvent event) {
        if (this.m_cursorFigure != figure) {
            this.sendEvent(MOUSE_EXIT_INVOKER, IMouseTrackListener.class, event);
            this.m_cursorFigure = figure;
            this.sendEvent(MOUSE_ENTER_INVOKER, IMouseTrackListener.class, event);
            this.updateCursor();
            this.updateFigureToolTipText();
        }
    }

    public final Figure getCursorFigure() {
        return this.m_cursorFigure;
    }

    protected final void updateFigureUnderCursor(MouseEvent event) {
        TargetFigureFindVisitor visitor = new TargetFigureFindVisitor(this.m_canvas, event.x, event.y);
        this.m_root.accept(visitor, false);
        this.setFigureUnderCursor(visitor.getTargetFigure(), event);
    }

    public void setCapture(Figure captureFigure) {
        this.m_captureFigure = captureFigure;
    }

    protected boolean isEventConsumed() {
        return this.m_eventConsumed;
    }

    public void mouseDoubleClick(MouseEvent event) {
        this.handleMouseEvent(MOUSE_DOUBLE_CLICK_INVOKER, IMouseListener.class, event);
    }

    public void mouseDown(MouseEvent event) {
        if (this.m_canvas.getToolTipText() != null) {
            this.m_canvas.setToolTipText(null);
        }
        this.handleMouseEvent(MOUSE_DOWN_INVOKER, IMouseListener.class, event);
    }

    public void mouseUp(MouseEvent event) {
        this.handleMouseEvent(MOUSE_UP_INVOKER, IMouseListener.class, event);
    }

    public void mouseMove(MouseEvent event) {
        this.handleMouseEvent(MOUSE_MOVE_INVOKER, IMouseMoveListener.class, event);
    }

    private void handleMouseEvent(IListenerInvoker invoker, Class<?> listenerClass, MouseEvent event) {
        this.updateFigureUnderCursor(event);
        this.sendEvent(invoker, listenerClass, event);
    }

    private <T> void sendEvent(IListenerInvoker invoker, Class<T> listenerClass, MouseEvent e) {
        List<T> listeners;
        Figure figure;
        this.m_eventConsumed = false;
        Figure figure2 = figure = this.m_captureFigure == null ? this.m_cursorFigure : this.m_captureFigure;
        if (figure != null && (listeners = figure.getListeners(listenerClass)) != null && !listeners.isEmpty()) {
            org.eclipse.wb.draw2d.events.MouseEvent event = new org.eclipse.wb.draw2d.events.MouseEvent(this.m_canvas, e, figure);
            Iterator<T> I = listeners.iterator();
            while (!event.isConsumed() && I.hasNext()) {
                invoker.invokeListener(I.next(), event);
            }
            this.m_eventConsumed = event.isConsumed();
        }
    }

    public void mouseEnter(MouseEvent event) {
        this.handleMouseEvent(MOUSE_ENTER_INVOKER, IMouseTrackListener.class, event);
    }

    public void mouseExit(MouseEvent event) {
        this.handleMouseEvent(MOUSE_EXIT_INVOKER, IMouseTrackListener.class, event);
    }

    public void mouseHover(MouseEvent event) {
        this.handleMouseEvent(MOUSE_HOVER_INVOKER, IMouseTrackListener.class, event);
    }

    public static final Object createListenerProxy(final Object owner, Class<?>[] interfaces) {
        return Proxy.newProxyInstance(owner.getClass().getClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (EventManager.delayEvent(this, proxy, method, args)) {
                    return null;
                }
                try {
                    return method.invoke(owner, args);
                }
                catch (InvocationTargetException e) {
                    if (!(e.getCause() instanceof CancelOperationError)) {
                        throw e;
                    }
                    return null;
                }
            }
        });
    }

    public static void delayEvents(Control control, boolean delay) {
        if (delay) {
            control.setData(FLAG_DELAY_EVENTS, (Object)Boolean.TRUE);
        } else {
            control.setData(FLAG_DELAY_EVENTS, null);
        }
    }

    private static boolean delayEvent(InvocationHandler handler, Object proxy, Method method, Object[] args) {
        if (args[0] instanceof TypedEvent) {
            Control control;
            TypedEvent event = (TypedEvent)args[0];
            if (event.widget instanceof Control && (control = (Control)event.widget).getData(FLAG_DELAY_EVENTS) != null) {
                ArrayList<DelayedEvent> eventQueue = (ArrayList<DelayedEvent>)control.getData(KEY_DELAYED_EVENTS);
                if (eventQueue == null) {
                    eventQueue = new ArrayList<DelayedEvent>();
                    control.setData(KEY_DELAYED_EVENTS, eventQueue);
                }
                eventQueue.add(new DelayedEvent(handler, proxy, method, args));
                return true;
            }
        }
        return false;
    }

    public static void runDelayedEvents(Control control) {
        List eventQueue = (List)control.getData(KEY_DELAYED_EVENTS);
        control.setData(KEY_DELAYED_EVENTS, null);
        if (eventQueue != null) {
            for (DelayedEvent event : eventQueue) {
                event.run();
            }
        }
    }

    private static final class DelayedEvent {
        private final InvocationHandler m_handler;
        private final Object m_proxy;
        private final Method m_method;
        private final Object[] m_args;

        DelayedEvent(InvocationHandler handler, Object proxy, Method method, Object[] args) {
            this.m_handler = handler;
            this.m_proxy = proxy;
            this.m_method = method;
            this.m_args = args;
        }

        void run() {
            try {
                this.m_handler.invoke(this.m_proxy, this.m_method, this.m_args);
            }
            catch (Throwable e) {
                throw ReflectionUtils.propagate(e);
            }
        }
    }

    private static interface IListenerInvoker {
        public void invokeListener(Object var1, org.eclipse.wb.draw2d.events.MouseEvent var2);
    }
}

