/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.java6.laf;

import java.awt.Container;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.java6.Messages;
import org.eclipse.wb.internal.swing.laf.ILayoutStyleSupport;

public final class LayoutStyleSupport
implements ILayoutStyleSupport {
    private LayoutStyle m_layoutStyle;

    public void setLayoutStyle(LookAndFeel laf) {
        Assert.isNotNull((Object)laf);
        this.m_layoutStyle = laf.getLayoutStyle();
    }

    public int getContainerGap(JComponent component, int position, Container parent) {
        return this.m_layoutStyle.getContainerGap(component, LayoutStyleSupport.convertPositionConstants(position), parent);
    }

    public int getPreferredGap(JComponent component1, JComponent component2, int componentPlacement, int position, Container parent) {
        return this.m_layoutStyle.getPreferredGap(component1, component2, this.convertPlacement(componentPlacement), LayoutStyleSupport.convertPositionConstants(position), parent);
    }

    private static int convertPositionConstants(int positionConstant) {
        switch (positionConstant) {
            case 8: {
                return 1;
            }
            case 32: {
                return 5;
            }
            case 1: {
                return 7;
            }
            case 4: {
                return 3;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.LayoutStyleSupport_unsupportedPosition, positionConstant));
    }

    private LayoutStyle.ComponentPlacement convertPlacement(int componentPlacement) {
        LayoutStyle.ComponentPlacement[] values;
        LayoutStyle.ComponentPlacement[] componentPlacementArray = values = LayoutStyle.ComponentPlacement.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutStyle.ComponentPlacement placement = componentPlacementArray[n2];
            if (placement.ordinal() == componentPlacement) {
                return placement;
            }
            ++n2;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.LayoutStyleSupport_unsupportedPlacement, componentPlacement));
    }
}

