/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.rcp.model.widgets.ISashFormInfo;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.xwt.support.ControlSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SashFormInfo
extends CompositeInfo
implements ISashFormInfo<ControlInfo> {
    public SashFormInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        this.addBroadcastListener(new ObjectEventListener(){

            public void childRemoveBefore(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (child instanceof ControlInfo && parent == SashFormInfo.this) {
                    SashFormInfo.this.removeWeight((ControlInfo)child);
                }
            }
        });
    }

    public boolean isHorizontal() {
        return ControlSupport.hasStyle((Widget)this.getControl(), 256);
    }

    public void command_CREATE(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.ensureWeights();
        XmlObjectUtils.add((XmlObjectInfo)control, (Association)Associations.direct(), (XmlObjectInfo)this, (XmlObjectInfo)nextControl);
        this.addWeight(control);
    }

    public void command_MOVE(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.ensureWeights();
        int oldIndex = this.getChildrenControls().indexOf((Object)control);
        XmlObjectUtils.move((XmlObjectInfo)control, (Association)Associations.direct(), (XmlObjectInfo)this, (XmlObjectInfo)nextControl);
        if (oldIndex == -1) {
            this.addWeight(control);
        } else {
            this.moveWeight(control, oldIndex);
        }
    }

    public void command_RESIZE(ControlInfo control, int size) throws Exception {
        this.ensureWeights();
        List<ControlInfo> children = this.getChildrenControls();
        int[] weights = new int[children.size()];
        int i = 0;
        while (i < children.size()) {
            ControlInfo child = children.get(i);
            Rectangle bounds = child.getModelBounds();
            weights[i] = this.isHorizontal() ? bounds.width : bounds.height;
            ++i;
        }
        int index = children.indexOf((Object)control);
        int sumWeight = weights[index] + weights[index + 1];
        weights[index + 1] = Math.max(0, sumWeight - size);
        weights[index] = sumWeight - weights[index + 1];
        this.setWeights(weights);
    }

    private void addWeight(ControlInfo newControl) throws Exception {
        int newWeight;
        int[] weights = this.getEnsureWeights();
        if (weights.length == 0) {
            newWeight = 1;
        } else {
            newWeight = 0;
            int i = 0;
            while (i < weights.length) {
                newWeight += weights[i];
                ++i;
            }
            newWeight /= weights.length;
        }
        int newControlIndex = this.getChildrenControls().indexOf((Object)newControl);
        weights = ArrayUtils.add((int[])weights, (int)newControlIndex, (int)newWeight);
        this.setWeights(weights);
    }

    private void moveWeight(ControlInfo newControl, int oldIndex) throws Exception {
        int[] weights = this.getEnsureWeights();
        int weight = weights[oldIndex];
        int newIndex = this.getChildrenControls().indexOf((Object)newControl);
        weights = ArrayUtils.remove((int[])weights, (int)oldIndex);
        weights = ArrayUtils.add((int[])weights, (int)newIndex, (int)weight);
        this.setWeights(weights);
    }

    private void removeWeight(ControlInfo control) throws Exception {
        String weightsString = this.getCreationSupport().getElement().getAttribute("weights");
        if (weightsString != null) {
            int index = this.getChildrenControls().indexOf((Object)control);
            int[] weights = SashFormInfo.getWeights(weightsString);
            weights = ArrayUtils.remove((int[])weights, (int)index);
            this.setWeights(weights);
        }
    }

    private int[] getEnsureWeights() throws Exception {
        String weightsString = this.ensureWeights();
        return SashFormInfo.getWeights(weightsString);
    }

    private String ensureWeights() throws Exception {
        DocumentElement element = this.getCreationSupport().getElement();
        String weightsString = element.getAttribute("weights");
        if (weightsString == null) {
            weightsString = StringUtils.repeat((String)"1, ", (int)this.getChildrenControls().size());
            weightsString = StringUtils.removeEnd((String)weightsString, (String)", ");
            element.setAttribute("weights", weightsString);
        }
        return weightsString;
    }

    private static int[] getWeights(String weightsString) throws Exception {
        String[] parts = StringUtils.split((String)weightsString, (String)", ");
        int[] weights = new int[parts.length];
        int i = 0;
        while (i < parts.length) {
            String weightString = parts[i];
            weights[i] = Integer.parseInt(weightString);
            ++i;
        }
        return weights;
    }

    private void setWeights(int[] weights) throws Exception {
        String weightsString = StringUtils.join((Object[])ArrayUtils.toObject((int[])weights), (String)", ");
        this.getCreationSupport().getElement().setAttribute("weights", weightsString);
    }
}

