/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.internal.xtend.type.baseimpl.TypesComparator;
import org.eclipse.sphinx.emf.mwe.resources.BasicWorkspaceResourceLoader;
import org.eclipse.xtend.typesystem.Callable;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.ParameterizedCallable;
import org.eclipse.xtend.typesystem.Type;

public final class XtendXpandUtil {
    public static final String XTEND_SHARED_UI_PLUGIN_ID = "org.eclipse.xtend.shared.ui";
    public static final String XTEND_XPAND_NATURE_ID = "org.eclipse.xtend.shared.ui.xtendXPandNature";
    public static final String PREFERENCE_KEY_PROJECT_SPECIFIC_METAMODEL = "project.specific.metamodel";
    public static final String PREFERENCE_KEY_METAMODEL_CONTRIBUTOR = "metamodelContributor";

    private XtendXpandUtil() {
    }

    public static String getQualifiedName(IFile underlyingFile, String definitionOrFeatureName) {
        Assert.isNotNull((Object)underlyingFile);
        if (underlyingFile.exists()) {
            StringBuilder qualifiedName = new StringBuilder();
            IPath path = underlyingFile.getProjectRelativePath().removeFileExtension();
            Iterator<String> iter = Arrays.asList(path.segments()).iterator();
            while (iter.hasNext()) {
                String segment = iter.next();
                qualifiedName.append(segment);
                if (!iter.hasNext()) continue;
                qualifiedName.append("::");
            }
            if (definitionOrFeatureName != null && definitionOrFeatureName.length() > 0) {
                qualifiedName.append("::");
                qualifiedName.append(definitionOrFeatureName);
            }
            return qualifiedName.toString();
        }
        return null;
    }

    public static IFile getUnderlyingFile(String qualifiedName, String extension) {
        return XtendXpandUtil.getUnderlyingFile(qualifiedName, extension, (ResourceLoader)new BasicWorkspaceResourceLoader());
    }

    public static IFile getUnderlyingFile(String qualifiedName, String extension, ResourceLoader resourceLoader) {
        Assert.isNotNull((Object)resourceLoader);
        if (qualifiedName != null) {
            IPath path = new Path(qualifiedName.replace("::", Character.toString('/'))).addFileExtension(extension);
            URL resourceURL = resourceLoader.getResource(path.toString());
            if (resourceURL == null && path.segmentCount() > 1) {
                resourceURL = resourceLoader.getResource(path.removeLastSegments(1).addFileExtension(extension).toString());
            }
            if (resourceURL != null && !"bundleresource".equals(resourceURL.getProtocol())) {
                try {
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile[] files = workspaceRoot.findFilesForLocationURI(resourceURL.toURI());
                    if (files != null && files.length > 0) {
                        return files[0];
                    }
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static List<Callable> getApplicableFeatures(List<? extends Callable> features, Class<?> featureType, String featureName, List<? extends Type> paramTypes) {
        ArrayList<Callable> applicableFeatures = new ArrayList<Callable>();
        TypesComparator typesComparator = new TypesComparator();
        for (Callable callable : features) {
            List<? extends Type> featureParamTypes;
            if (!featureType.isInstance(callable) || featureName != null && !callable.getName().equals(featureName) || (featureParamTypes = XtendXpandUtil.getParamTypes(callable)).size() != paramTypes.size() || typesComparator.compare(featureParamTypes, paramTypes) < 0) continue;
            applicableFeatures.add(callable);
        }
        return applicableFeatures;
    }

    private static List<? extends Type> getParamTypes(Callable feature) {
        ArrayList<Type> result = new ArrayList<Type>();
        if (feature instanceof Feature) {
            result.add(((Feature)feature).getOwner());
        }
        if (feature instanceof ParameterizedCallable && ((ParameterizedCallable)feature).getParameterTypes() != null) {
            result.addAll(((ParameterizedCallable)feature).getParameterTypes());
        }
        return result;
    }
}

