/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.ProxyHelper;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.ProxyHelperAdapterFactory;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.blacklist.ModelIndex;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.lookupresolver.EcoreIndex;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.scoping.IResourceScope;
import org.eclipse.sphinx.emf.scoping.IResourceScopeProvider;
import org.eclipse.sphinx.emf.scoping.ResourceScopeProviderRegistry;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.SchedulingRuleFactory;
import org.eclipse.sphinx.platform.operations.AbstractWorkspaceOperation;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractLoadOperation
extends AbstractWorkspaceOperation {
    protected static int DIFFERENT = 0;
    protected static int EQUAL = 1;
    protected static int GREATER_THAN = 2;
    protected static int SMALLER_THAN = 3;
    private IMetaModelDescriptor mmDescriptor;
    private SchedulingRuleFactory schedulingRuleFactory;

    public AbstractLoadOperation(String label, IMetaModelDescriptor mmDescriptor) {
        super(label);
        this.mmDescriptor = mmDescriptor;
    }

    public abstract boolean covers(Collection<IProject> var1, boolean var2, IMetaModelDescriptor var3);

    public abstract boolean covers(Collection<IFile> var1, IMetaModelDescriptor var2);

    public IMetaModelDescriptor getMetaModelDescriptor() {
        return this.mmDescriptor;
    }

    protected Collection<IProject> getProjectGroup(Object contextObject, boolean includeReferencingProjects) {
        if (contextObject instanceof IResource) {
            IResource contextResource = (IResource)contextObject;
            return ExtendedPlatform.getProjectGroup((IProject)contextResource.getProject(), (boolean)includeReferencingProjects);
        }
        IFile contextFile = EcorePlatformUtil.getFile((Object)contextObject);
        if (contextFile != null) {
            return ExtendedPlatform.getProjectGroup((IProject)contextFile.getProject(), (boolean)includeReferencingProjects);
        }
        return Collections.emptySet();
    }

    protected int getFilesToLoadCount(Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad) {
        Assert.isNotNull(filesToLoad);
        int count = 0;
        for (TransactionalEditingDomain editingDomain : filesToLoad.keySet()) {
            Collection<IFile> filesToLoadInEditingDomain = filesToLoad.get(editingDomain);
            count += filesToLoadInEditingDomain.size();
        }
        return count;
    }

    protected int getFilesToUnloadCount(Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload) {
        Assert.isNotNull(filesToUnload);
        int count = 0;
        for (TransactionalEditingDomain editingDomain : filesToUnload.keySet()) {
            count += filesToUnload.get(editingDomain).size();
        }
        return count;
    }

    protected void runDetectAndLoadModelFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_loadingModelFiles, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad = this.detectFilesToLoad(files, mmDescriptor, true, (IProgressMonitor)progress.newChild(10));
        if (filesToLoad.isEmpty()) {
            progress.done();
            return;
        }
        this.runLoadModelFiles(filesToLoad, (IProgressMonitor)progress.newChild(90));
    }

    protected Map<TransactionalEditingDomain, Collection<IFile>> detectFilesToLoad(Collection<IFile> files, IMetaModelDescriptor mmFilter, boolean ignoreIfAlreadyLoaded, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToLoad = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (IFile file : files) {
            try {
                if (file.isAccessible() && !ResourceScopeProviderRegistry.INSTANCE.isNotInAnyScope(file)) {
                    TransactionalEditingDomain editingDomain;
                    IResourceScope resourceScope;
                    IResourceScopeProvider resourceScopeProvider;
                    progress.subTask(NLS.bind((String)Messages.subtask_analyzingFile, (Object)file.getFullPath()));
                    IMetaModelDescriptor effectiveMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getEffectiveDescriptor(file);
                    if (!(mmFilter != null && !mmFilter.getClass().isInstance(effectiveMMDescriptor) || ignoreIfAlreadyLoaded && EcorePlatformUtil.isFileLoaded((IFile)file) || (resourceScopeProvider = ResourceScopeProviderRegistry.INSTANCE.getResourceScopeProvider(effectiveMMDescriptor)) == null || (resourceScope = resourceScopeProvider.getScope((IResource)file)) == null || (editingDomain = WorkspaceEditingDomainUtil.getMappedEditingDomain((IFile)file)) == null)) {
                        HashSet<IFile> filesToLoadInEditingDomain = (HashSet<IFile>)filesToLoad.get(editingDomain);
                        if (filesToLoadInEditingDomain == null) {
                            filesToLoadInEditingDomain = new HashSet<IFile>();
                            filesToLoad.put(editingDomain, filesToLoadInEditingDomain);
                        }
                        filesToLoadInEditingDomain.add(file);
                    }
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
            progress.worked(1);
            progress.subTask("");
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return filesToLoad;
    }

    protected void runLoadModelFiles(Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToLoad);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToLoad.keySet().size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (TransactionalEditingDomain editingDomain : filesToLoad.keySet()) {
            this.loadModelFilesInEditingDomain(editingDomain, filesToLoad.get(editingDomain), (IProgressMonitor)progress.newChild(1));
        }
        ExtendedPlatform.performGarbageCollection();
    }

    protected void loadModelFilesInEditingDomain(final TransactionalEditingDomain editingDomain, final Collection<IFile> filesToLoadInEditingDomain, final IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull((Object)editingDomain);
        Assert.isNotNull(filesToLoadInEditingDomain);
        try {
            editingDomain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ProxyHelper proxyHelper = ProxyHelperAdapterFactory.INSTANCE.adapt((Notifier)editingDomain.getResourceSet());
                    if (proxyHelper != null) {
                        proxyHelper.setIgnoreFragmentBasedProxies(true);
                    }
                    SubMonitor loadProgress = progress.newChild(80).setWorkRemaining(filesToLoadInEditingDomain.size());
                    HashSet<IFile> loadedFiles = new HashSet<IFile>();
                    for (IFile file : filesToLoadInEditingDomain) {
                        loadProgress.subTask(NLS.bind((String)Messages.subtask_loadingFile, (Object)file.getFullPath().toString()));
                        try {
                            try {
                                Map<String, SubMonitor> loadOptions = Collections.singletonMap("PROGRESS_MONITOR", loadProgress.newChild(1));
                                EcorePlatformUtil.loadResource((TransactionalEditingDomain)editingDomain, (IFile)file, loadOptions);
                                loadedFiles.add(file);
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception ex) {
                            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                        }
                        loadProgress.subTask("");
                        if (loadProgress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        editingDomain.yield();
                    }
                    if (proxyHelper != null) {
                        AbstractLoadOperation.this.updateUnresolvedProxyBlackList(loadedFiles, proxyHelper.getBlackList());
                        AbstractLoadOperation.this.forceProxyResolution(loadedFiles, proxyHelper.getLookupResolver(), (IProgressMonitor)progress.newChild(20));
                        proxyHelper.setIgnoreFragmentBasedProxies(false);
                    } else {
                        progress.worked(20);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
        }
        monitor.done();
    }

    protected void updateUnresolvedProxyBlackList(Collection<IFile> files, ModelIndex blackList) {
        Assert.isNotNull(files);
        Assert.isNotNull((Object)blackList);
        for (IFile file : files) {
            Resource resource = EcorePlatformUtil.getResource((IFile)file);
            blackList.updateIndexOnResourceLoaded(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceProxyResolution(Collection<IFile> files, EcoreIndex lookupResolver, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        Assert.isNotNull((Object)lookupResolver);
        HashSet<IModelDescriptor> modelDescriptors = new HashSet<IModelDescriptor>();
        for (IFile file : files) {
            IModelDescriptor modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(file);
            if (modelDescriptor == null) continue;
            modelDescriptors.add(modelDescriptor);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)modelDescriptors.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IModelDescriptor modelDescriptor : modelDescriptors) {
            EcoreIndex ecoreIndex = lookupResolver;
            synchronized (ecoreIndex) {
                SubMonitor resolveProxiesInModelProgress = progress.newChild(1).setWorkRemaining(100);
                resolveProxiesInModelProgress.subTask(NLS.bind((String)Messages.subtask_initializingProxyResolutionForModelInRoot, (Object)modelDescriptor.getMetaModelDescriptor().getName(), (Object)modelDescriptor.getRoot().getFullPath()));
                Collection resources = modelDescriptor.getLoadedResources(true);
                lookupResolver.init(resources);
                resolveProxiesInModelProgress.worked(50);
                if (resolveProxiesInModelProgress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SubMonitor resolveProxiesInResourcesProgress = resolveProxiesInModelProgress.newChild(50).setWorkRemaining(resources.size());
                for (Resource resource : resources) {
                    resolveProxiesInResourcesProgress.subTask(NLS.bind((String)Messages.subtask_resolvingProxiesInResource, (Object)resource.getURI().toPlatformString(true)));
                    EObjectUtil.resolveAll((Resource)resource);
                    resolveProxiesInResourcesProgress.worked(1);
                    if (!resolveProxiesInResourcesProgress.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
                lookupResolver.clear();
            }
        }
        progress.subTask("");
        ExtendedPlatform.performGarbageCollection();
    }

    protected void runDetectAndReloadModelFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_reloadingModelFiles, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload = this.detectFilesToUnload(files, mmDescriptor, (IProgressMonitor)progress.newChild(5));
        Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad = this.detectFilesToLoad(files, mmDescriptor, false, (IProgressMonitor)progress.newChild(10));
        if (filesToUnload.size() == 0 && filesToLoad.size() == 0) {
            progress.done();
            return;
        }
        this.runReloadModelFiles(filesToUnload, filesToLoad, memoryOptimized, (IProgressMonitor)progress.newChild(85));
    }

    protected void runReloadModelFiles(final Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload, final Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad, final boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToUnload);
        Assert.isNotNull(filesToLoad);
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.getFilesToUnloadCount(filesToUnload) + this.getFilesToLoadCount(filesToLoad)));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToUnloadOnly = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (TransactionalEditingDomain editingDomain : new HashSet<TransactionalEditingDomain>(filesToUnload.keySet())) {
            if (filesToLoad.containsKey(editingDomain)) continue;
            filesToUnloadOnly.put(editingDomain, filesToUnload.get(editingDomain));
            filesToUnload.remove(editingDomain);
        }
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToLoadOnly = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (final TransactionalEditingDomain editingDomain : new HashSet<TransactionalEditingDomain>(filesToLoad.keySet())) {
            if (filesToUnload.containsKey(editingDomain)) continue;
            filesToLoadOnly.put(editingDomain, filesToLoad.get(editingDomain));
            filesToLoad.remove(editingDomain);
        }
        if (filesToUnloadOnly.size() > 0) {
            this.runUnloadModelFiles(filesToUnloadOnly, memoryOptimized, (IProgressMonitor)progress.newChild(this.getFilesToUnloadCount(filesToUnloadOnly)));
        }
        for (final TransactionalEditingDomain editingDomain : filesToUnload.keySet()) {
            try {
                editingDomain.runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        Collection filesToUnloadInEditingDomain = (Collection)filesToUnload.get(editingDomain);
                        int totalWork = filesToUnloadInEditingDomain.size();
                        EcorePlatformUtil.unloadFiles((TransactionalEditingDomain)editingDomain, (Collection)filesToUnloadInEditingDomain, (boolean)memoryOptimized, (IProgressMonitor)progress.newChild(totalWork));
                        Collection filesToLoadInEditingDomain = (Collection)filesToLoad.get(editingDomain);
                        totalWork = filesToLoadInEditingDomain.size();
                        AbstractLoadOperation.this.loadModelFilesInEditingDomain(editingDomain, filesToLoadInEditingDomain, (IProgressMonitor)progress.newChild(totalWork));
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
            }
        }
        if (filesToLoadOnly.size() > 0) {
            this.runLoadModelFiles(filesToLoadOnly, (IProgressMonitor)progress.newChild(this.getFilesToLoadCount(filesToLoadOnly)));
        }
        ExtendedPlatform.performGarbageCollection();
    }

    protected void runUnloadModelFiles(Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload, boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToUnload);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getFilesToUnloadCount(filesToUnload));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (TransactionalEditingDomain editingDomain : filesToUnload.keySet()) {
            Collection<IFile> filesToUnloadInEditingDomain = filesToUnload.get(editingDomain);
            int totalWork = filesToUnloadInEditingDomain.size();
            EcorePlatformUtil.unloadFiles((TransactionalEditingDomain)editingDomain, filesToUnloadInEditingDomain, (boolean)memoryOptimized, (IProgressMonitor)progress.newChild(totalWork));
        }
        ExtendedPlatform.performGarbageCollection();
    }

    protected Map<TransactionalEditingDomain, Collection<IFile>> detectFilesToUnload(Collection<IFile> files, IMetaModelDescriptor mmFilter, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToUnload = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (IFile file : files) {
            try {
                if (ResourceScopeProviderRegistry.INSTANCE.hasApplicableFileExtension(file)) {
                    progress.subTask(NLS.bind((String)Messages.subtask_analyzingFile, (Object)file.getFullPath()));
                    IMetaModelDescriptor effectiveMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getEffectiveDescriptor(file);
                    if (mmFilter == null || mmFilter.getClass().isInstance(effectiveMMDescriptor)) {
                        for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainUtil.getAllEditingDomains()) {
                            if (!EcorePlatformUtil.isFileLoaded((TransactionalEditingDomain)editingDomain, (IFile)file)) continue;
                            HashSet<IFile> filesToUnloadInEditingDomain = (HashSet<IFile>)filesToUnload.get(editingDomain);
                            if (filesToUnloadInEditingDomain == null) {
                                filesToUnloadInEditingDomain = new HashSet<IFile>();
                                filesToUnload.put(editingDomain, filesToUnloadInEditingDomain);
                            }
                            filesToUnloadInEditingDomain.add(file);
                        }
                    }
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
            progress.worked(1);
            progress.subTask("");
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return filesToUnload;
    }

    protected SchedulingRuleFactory getSchedulingRuleFactory() {
        if (this.schedulingRuleFactory == null) {
            this.schedulingRuleFactory = this.createSchedulingRuleFactory();
        }
        return this.schedulingRuleFactory;
    }

    protected SchedulingRuleFactory createSchedulingRuleFactory() {
        return new SchedulingRuleFactory();
    }

    protected int compare(IMetaModelDescriptor mmd1, IMetaModelDescriptor mmd2) {
        if (mmd1 == null || MetaModelDescriptorRegistry.ANY_MM.equals(mmd1)) {
            if (mmd2 == null || MetaModelDescriptorRegistry.ANY_MM.equals(mmd2)) {
                return EQUAL;
            }
            return GREATER_THAN;
        }
        if (mmd2 == null || MetaModelDescriptorRegistry.ANY_MM.equals(mmd2)) {
            return SMALLER_THAN;
        }
        if (mmd1.getClass().isAssignableFrom(mmd2.getClass())) {
            return GREATER_THAN;
        }
        if (mmd2.getClass().isAssignableFrom(mmd1.getClass())) {
            return SMALLER_THAN;
        }
        return DIFFERENT;
    }

    protected <T> int compare(Collection<T> list1, Collection<T> list2) {
        int from1ContainedIn2 = 0;
        int from2ContainedIn1 = 0;
        for (T o : list1) {
            if (!list2.contains(o)) continue;
            ++from1ContainedIn2;
        }
        for (T o : list2) {
            if (!list1.contains(o)) continue;
            ++from2ContainedIn1;
        }
        if (from1ContainedIn2 == from2ContainedIn1 && from1ContainedIn2 == list1.size() && from2ContainedIn1 == list2.size()) {
            return EQUAL;
        }
        if (from1ContainedIn2 == list1.size()) {
            return SMALLER_THAN;
        }
        if (from2ContainedIn1 == list2.size()) {
            return GREATER_THAN;
        }
        return DIFFERENT;
    }
}

