/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.patternlanguage.emf.jvmmodel;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * {@link IPatternMatch} implementation inferer.
 * 
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class PatternMatchClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  private TypeReferences typeReference;
  
  @Extension
  private JvmTypeReferenceBuilder builder;
  
  @Extension
  private JvmAnnotationReferenceBuilder annBuilder;
  
  @Inject
  @Extension
  private IJvmModelAssociator associator;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  public boolean inferMatchClassElements(final JvmDeclaredType it, final Pattern pattern, final JvmType querySpecificationClass, final JvmTypeReferenceBuilder builder, final JvmAnnotationReferenceBuilder annBuilder) {
    boolean _xblockexpression = false;
    {
      this.builder = builder;
      this.annBuilder = annBuilder;
      CharSequence _javadocMatchClass = this._javadocInferrer.javadocMatchClass(pattern);
      String _string = _javadocMatchClass.toString();
      this._eMFJvmTypesBuilder.setDocumentation(it, _string);
      it.setAbstract(true);
      this.inferMatchClassFields(it, pattern);
      this.inferMatchClassConstructors(it, pattern);
      this.inferMatchClassGetters(it, pattern);
      this.inferMatchClassSetters(it, pattern);
      JvmTypeReference _typeRef = this.builder.typeRef(querySpecificationClass);
      this.inferMatchClassMethods(it, pattern, _typeRef);
      _xblockexpression = this.inferMatchInnerClasses(it, pattern);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers fields for Match class based on the input 'pattern'.
   */
  public boolean inferMatchClassFields(final JvmDeclaredType matchClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<Variable> _parameters = pattern.getParameters();
      for (final Variable variable : _parameters) {
        EList<JvmMember> _members = matchClass.getMembers();
        String _fieldName = this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
        JvmTypeReference _calculateType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
        JvmField _field = this._eMFJvmTypesBuilder.toField(variable, _fieldName, _calculateType);
        this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
      }
      EList<JvmMember> _members_1 = matchClass.getMembers();
      JvmTypeReference _typeRef = this.builder.typeRef(String.class);
      JvmTypeReference _typeRef_1 = this.builder.typeRef(List.class, _typeRef);
      final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
        @Override
        public void apply(final JvmField it) {
          it.setStatic(true);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("makeImmutableList(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable variable : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  _builder.append("\"");
                  String _name = variable.getName();
                  _builder.append(_name, "");
                  _builder.append("\"");
                }
              }
              _builder.append(")");
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _client);
        }
      };
      JvmField _field_1 = this._eMFJvmTypesBuilder.toField(pattern, "parameterNames", _typeRef_1, _function);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmField>operator_add(_members_1, _field_1);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers constructors for Match class based on the input 'pattern'.
   */
  public boolean inferMatchClassConstructors(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<JvmMember> _members = matchClass.getMembers();
    final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
      @Override
      public void apply(final JvmConstructor it) {
        String _matchClassName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
        it.setSimpleName(_matchClassName);
        it.setVisibility(JvmVisibility.PRIVATE);
        EList<Variable> _parameters = pattern.getParameters();
        for (final Variable variable : _parameters) {
          {
            final JvmTypeReference javaType = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
            JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _parameterName, javaType);
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
          }
        }
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            {
              EList<Variable> _parameters = pattern.getParameters();
              for(final Variable variable : _parameters) {
                _builder.append("this.");
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName, "");
                _builder.append(" = ");
                String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
                _builder.append(_parameterName, "");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        };
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
      }
    };
    JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
    return this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
  }
  
  /**
   * Infers getters for Match class based on the input 'pattern'.
   */
  public void inferMatchClassGetters(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<JvmMember> _members = matchClass.getMembers();
    JvmTypeReference _typeRef = this.builder.typeRef(Object.class);
    final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
      @Override
      public void apply(final JvmOperation it) {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmTypeReference _typeRef = PatternMatchClassInferrer.this.builder.typeRef(String.class);
        JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "parameterName", _typeRef);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            {
              EList<Variable> _parameters = pattern.getParameters();
              for(final Variable variable : _parameters) {
                _builder.append("if (\"");
                String _name = variable.getName();
                _builder.append(_name, "");
                _builder.append("\".equals(parameterName)) return this.");
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName, "");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("return null;");
            _builder.newLine();
          }
        };
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
      }
    };
    JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "get", _typeRef, _function);
    this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    EList<Variable> _parameters = pattern.getParameters();
    for (final Variable variable : _parameters) {
      {
        String _terMethodName = this._eMFPatternLanguageJvmModelInferrerUtil.getterMethodName(variable);
        JvmTypeReference _calculateType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
        final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return this.");
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName, "");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        final JvmOperation getter = this._eMFJvmTypesBuilder.toMethod(variable, _terMethodName, _calculateType, _function_1);
        EList<JvmMember> _members_1 = matchClass.getMembers();
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, getter);
        this.associator.associatePrimary(variable, getter);
      }
    }
  }
  
  /**
   * Infers setters for Match class based on the input 'pattern'.
   */
  public void inferMatchClassSetters(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<JvmMember> _members = matchClass.getMembers();
    JvmTypeReference _typeRef = this.builder.typeRef(boolean.class);
    final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
      @Override
      public void apply(final JvmOperation it) {
        JvmTypeReference _typeRef = PatternMatchClassInferrer.this.builder.typeRef(Boolean.TYPE);
        it.setReturnType(_typeRef);
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmTypeReference _typeRef_1 = PatternMatchClassInferrer.this.builder.typeRef(String.class);
        JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "parameterName", _typeRef_1);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        EList<JvmFormalParameter> _parameters_1 = it.getParameters();
        JvmTypeReference _typeRef_2 = PatternMatchClassInferrer.this.builder.typeRef(Object.class);
        JvmFormalParameter _parameter_1 = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "newValue", _typeRef_2);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("if (!isMutable()) throw new java.lang.UnsupportedOperationException();");
            _builder.newLine();
            {
              EList<Variable> _parameters = pattern.getParameters();
              for(final Variable variable : _parameters) {
                final JvmTypeReference type = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                _builder.newLineIfNotEmpty();
                _builder.append("if (\"");
                String _name = variable.getName();
                _builder.append(_name, "");
                _builder.append("\".equals(parameterName) ");
                {
                  boolean _is = PatternMatchClassInferrer.this.typeReference.is(type, Object.class);
                  if (_is) {
                    _builder.append("&& newValue instanceof ");
                    _builder.append(type, "");
                  }
                }
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("this.");
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName, "\t");
                _builder.append(" = (");
                _builder.append(type, "\t");
                _builder.append(") newValue;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("return true;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
              }
            }
            _builder.append("return false;");
            _builder.newLine();
          }
        };
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
      }
    };
    JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "set", _typeRef, _function);
    this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    EList<Variable> _parameters = pattern.getParameters();
    for (final Variable variable : _parameters) {
      EList<JvmMember> _members_1 = matchClass.getMembers();
      String _setterMethodName = this._eMFPatternLanguageJvmModelInferrerUtil.setterMethodName(variable);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          JvmTypeReference _typeRef = PatternMatchClassInferrer.this.builder.typeRef(Void.TYPE);
          it.setReturnType(_typeRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
          JvmTypeReference _calculateType = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
          JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _parameterName, _calculateType);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("if (!isMutable()) throw new java.lang.UnsupportedOperationException();");
              _builder.newLine();
              _builder.append("this.");
              String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
              _builder.append(_fieldName, "");
              _builder.append(" = ");
              String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
              _builder.append(_parameterName, "");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, _setterMethodName, null, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
    }
  }
  
  /**
   * Infers methods for Match class based on the input 'pattern'.
   */
  public boolean inferMatchClassMethods(final JvmDeclaredType matchClass, final Pattern pattern, final JvmTypeReference querySpecificationClassRef) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = matchClass.getMembers();
      JvmTypeReference _typeRef = this.builder.typeRef(String.class);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return \"");
              QualifiedName _fullyQualifiedName = PatternMatchClassInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(pattern);
              _builder.append(_fullyQualifiedName, "");
              _builder.append("\";");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "patternName", _typeRef, _function);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      EList<JvmMember> _members_1 = matchClass.getMembers();
      JvmTypeReference _typeRef_1 = this.builder.typeRef(String.class);
      JvmTypeReference _typeRef_2 = this.builder.typeRef(List.class, _typeRef_1);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return ");
              String _matchClassName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
              _builder.append(_matchClassName, "");
              _builder.append(".parameterNames;");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "parameterNames", _typeRef_2, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      EList<JvmMember> _members_2 = matchClass.getMembers();
      JvmTypeReference _typeRef_3 = this.builder.typeRef(Object.class);
      JvmTypeReference _addArrayTypeDimension = this._eMFJvmTypesBuilder.addArrayTypeDimension(_typeRef_3);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return new Object[]{");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable variable : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                  _builder.append(_fieldName, "");
                }
              }
              _builder.append("};");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(pattern, "toArray", _addArrayTypeDimension, _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
      EList<JvmMember> _members_3 = matchClass.getMembers();
      JvmTypeReference _typeRef_4 = this.builder.typeRef(matchClass);
      final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return isMutable() ? newMatch(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable variable : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                  _builder.append(_fieldName, "");
                }
              }
              _builder.append(") : this;");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(pattern, "toImmutable", _typeRef_4, _function_3);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_3);
      EList<JvmMember> _members_4 = matchClass.getMembers();
      JvmTypeReference _typeRef_5 = this.builder.typeRef(String.class);
      final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _isEmpty = _parameters.isEmpty();
                if (_isEmpty) {
                  _builder.append("return \"[]\";");
                  _builder.newLine();
                } else {
                  _builder.append(StringBuilder.class, "");
                  _builder.append(" result = new ");
                  _builder.append(StringBuilder.class, "");
                  _builder.append("();");
                  _builder.newLineIfNotEmpty();
                  {
                    EList<Variable> _parameters_1 = pattern.getParameters();
                    boolean _hasElements = false;
                    for(final Variable variable : _parameters_1) {
                      if (!_hasElements) {
                        _hasElements = true;
                      } else {
                        _builder.appendImmediate(" + \", \");\n", "");
                      }
                      _builder.append("result.append(\"\\\"");
                      String _name = variable.getName();
                      _builder.append(_name, "");
                      _builder.append("\\\"=\" + prettyPrintValue(");
                      String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                      _builder.append(_fieldName, "");
                      _builder.append(")");
                      _builder.newLineIfNotEmpty();
                    }
                    if (_hasElements) {
                      _builder.append(");\n", "");
                    }
                  }
                  _builder.append("return result.toString();");
                  _builder.newLine();
                }
              }
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_4 = this._eMFJvmTypesBuilder.toMethod(pattern, "prettyPrint", _typeRef_5, _function_4);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_4);
      EList<JvmMember> _members_5 = matchClass.getMembers();
      JvmTypeReference _typeRef_6 = this.builder.typeRef(int.class);
      final Procedure1<JvmOperation> _function_5 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("final int prime = 31;");
              _builder.newLine();
              _builder.append("int result = 1;");
              _builder.newLine();
              {
                EList<Variable> _parameters = pattern.getParameters();
                for(final Variable variable : _parameters) {
                  _builder.append("result = prime * result + ((");
                  String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                  _builder.append(_fieldName, "");
                  _builder.append(" == null) ? 0 : ");
                  String _fieldName_1 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                  _builder.append(_fieldName_1, "");
                  _builder.append(".hashCode());");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("return result;");
              _builder.newLine();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_5 = this._eMFJvmTypesBuilder.toMethod(pattern, "hashCode", _typeRef_6, _function_5);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_5, _method_5);
      EList<JvmMember> _members_6 = matchClass.getMembers();
      JvmTypeReference _typeRef_7 = this.builder.typeRef(boolean.class);
      final Procedure1<JvmOperation> _function_6 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternMatchClassInferrer.this.builder.typeRef(Object.class);
          JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "obj", _typeRef);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("if (this == obj)");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("return true;");
              _builder.newLine();
              _builder.append("if (!(obj instanceof ");
              String _matchClassName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
              _builder.append(_matchClassName, "");
              _builder.append(")) { // this should be infrequent");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("if (obj == null) {");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("return false;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("if (!(obj instanceof ");
              _builder.append(IPatternMatch.class, "\t");
              _builder.append(")) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("return false;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append(IPatternMatch.class, "\t");
              _builder.append(" otherSig  = (");
              _builder.append(IPatternMatch.class, "\t");
              _builder.append(") obj;");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("if (!specification().equals(otherSig.specification()))");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("return false;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("return ");
              _builder.append(Arrays.class, "\t");
              _builder.append(".deepEquals(toArray(), otherSig.toArray());");
              _builder.newLineIfNotEmpty();
              _builder.append("}");
              _builder.newLine();
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _isEmpty = _parameters.isEmpty();
                boolean _not = (!_isEmpty);
                if (_not) {
                  String _matchClassName_1 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
                  _builder.append(_matchClassName_1, "");
                  _builder.append(" other = (");
                  String _matchClassName_2 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
                  _builder.append(_matchClassName_2, "");
                  _builder.append(") obj;");
                  _builder.newLineIfNotEmpty();
                  {
                    EList<Variable> _parameters_1 = pattern.getParameters();
                    for(final Variable variable : _parameters_1) {
                      _builder.append("if (");
                      String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                      _builder.append(_fieldName, "");
                      _builder.append(" == null) {if (other.");
                      String _fieldName_1 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                      _builder.append(_fieldName_1, "");
                      _builder.append(" != null) return false;}");
                      _builder.newLineIfNotEmpty();
                      _builder.append("else if (!");
                      String _fieldName_2 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                      _builder.append(_fieldName_2, "");
                      _builder.append(".equals(other.");
                      String _fieldName_3 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                      _builder.append(_fieldName_3, "");
                      _builder.append(")) return false;");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                }
              }
              _builder.append("return true;");
              _builder.newLine();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_6 = this._eMFJvmTypesBuilder.toMethod(pattern, "equals", _typeRef_7, _function_6);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_6, _method_6);
      EList<JvmMember> _members_7 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_7 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("try {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("return ");
              JvmType _type = querySpecificationClassRef.getType();
              String _simpleName = _type.getSimpleName();
              _builder.append(_simpleName, "\t");
              _builder.append(".instance();");
              _builder.newLineIfNotEmpty();
              _builder.append("} catch (");
              _builder.append(IncQueryException.class, "");
              _builder.append(" ex) {");
              _builder.newLineIfNotEmpty();
              _builder.append(" \t");
              _builder.append("// This cannot happen, as the match object can only be instantiated if the query specification exists");
              _builder.newLine();
              _builder.append(" \t");
              _builder.append("throw new ");
              _builder.append(IllegalStateException.class, " \t");
              _builder.append(" (ex);");
              _builder.newLineIfNotEmpty();
              _builder.append("}");
              _builder.newLine();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_7 = this._eMFJvmTypesBuilder.toMethod(pattern, "specification", querySpecificationClassRef, _function_7);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_7, _method_7);
      EList<JvmMember> _members_8 = matchClass.getMembers();
      JvmTypeReference _typeRef_8 = this.builder.typeRef(matchClass);
      final Procedure1<JvmOperation> _function_8 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setStatic(true);
          CharSequence _javadocNewEmptyMatchMethod = PatternMatchClassInferrer.this._javadocInferrer.javadocNewEmptyMatchMethod(pattern);
          String _string = _javadocNewEmptyMatchMethod.toString();
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return new Mutable(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable p : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  _builder.append("null");
                }
              }
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_8 = this._eMFJvmTypesBuilder.toMethod(pattern, "newEmptyMatch", _typeRef_8, _function_8);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_8, _method_8);
      EList<JvmMember> _members_9 = matchClass.getMembers();
      JvmTypeReference _typeRef_9 = this.builder.typeRef(matchClass);
      final Procedure1<JvmOperation> _function_9 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setStatic(true);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          EList<Variable> _parameters_1 = pattern.getParameters();
          final Function1<Variable, JvmFormalParameter> _function = new Function1<Variable, JvmFormalParameter>() {
            @Override
            public JvmFormalParameter apply(final Variable it) {
              String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(it);
              JvmTypeReference _calculateType = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(it);
              return PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(it, _parameterName, _calculateType);
            }
          };
          List<JvmFormalParameter> _map = ListExtensions.<Variable, JvmFormalParameter>map(_parameters_1, _function);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _map);
          CharSequence _javadocNewMutableMatchMethod = PatternMatchClassInferrer.this._javadocInferrer.javadocNewMutableMatchMethod(pattern);
          String _string = _javadocNewMutableMatchMethod.toString();
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return new Mutable(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable p : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                  _builder.append(_parameterName, "");
                }
              }
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_9 = this._eMFJvmTypesBuilder.toMethod(pattern, "newMutableMatch", _typeRef_9, _function_9);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_9, _method_9);
      EList<JvmMember> _members_10 = matchClass.getMembers();
      JvmTypeReference _typeRef_10 = this.builder.typeRef(matchClass);
      final Procedure1<JvmOperation> _function_10 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setStatic(true);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          EList<Variable> _parameters_1 = pattern.getParameters();
          final Function1<Variable, JvmFormalParameter> _function = new Function1<Variable, JvmFormalParameter>() {
            @Override
            public JvmFormalParameter apply(final Variable it) {
              String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(it);
              JvmTypeReference _calculateType = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(it);
              return PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(it, _parameterName, _calculateType);
            }
          };
          List<JvmFormalParameter> _map = ListExtensions.<Variable, JvmFormalParameter>map(_parameters_1, _function);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _map);
          CharSequence _javadocNewMatchMethod = PatternMatchClassInferrer.this._javadocInferrer.javadocNewMatchMethod(pattern);
          String _string = _javadocNewMatchMethod.toString();
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return new Immutable(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable p : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                  _builder.append(_parameterName, "");
                }
              }
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_10 = this._eMFJvmTypesBuilder.toMethod(pattern, "newMatch", _typeRef_10, _function_10);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_10, _method_10);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers inner classes for Match class based on the input 'pattern'.
   */
  public boolean inferMatchInnerClasses(final JvmDeclaredType matchClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = matchClass.getMembers();
      String _matchMutableInnerClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchMutableInnerClassName(pattern);
      JvmGenericType _makeMatchInnerClass = this.makeMatchInnerClass(matchClass, pattern, _matchMutableInnerClassName, true);
      this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members, _makeMatchInnerClass);
      EList<JvmMember> _members_1 = matchClass.getMembers();
      String _matchImmutableInnerClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchImmutableInnerClassName(pattern);
      JvmGenericType _makeMatchInnerClass_1 = this.makeMatchInnerClass(matchClass, pattern, _matchImmutableInnerClassName, false);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members_1, _makeMatchInnerClass_1);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers a single inner class for Match class
   */
  public JvmGenericType makeMatchInnerClass(final JvmDeclaredType matchClass, final Pattern pattern, final String innerClassName, final boolean isMutable) {
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        it.setVisibility(JvmVisibility.PRIVATE);
        it.setStatic(true);
        it.setFinal(true);
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _typeRef = PatternMatchClassInferrer.this.builder.typeRef(matchClass);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
        EList<JvmMember> _members = it.getMembers();
        final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
          @Override
          public void apply(final JvmConstructor it) {
            it.setSimpleName(innerClassName);
            it.setVisibility(JvmVisibility.DEFAULT);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable variable : _parameters) {
              {
                final JvmTypeReference javaType = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                EList<JvmFormalParameter> _parameters_1 = it.getParameters();
                String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
                JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _parameterName, javaType);
                PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
              }
            }
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("super(");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable variable : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmConstructor _constructor = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
        EList<JvmMember> _members_1 = it.getMembers();
        JvmTypeReference _typeRef_1 = PatternMatchClassInferrer.this.builder.typeRef(boolean.class);
        final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PUBLIC);
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotationRef = PatternMatchClassInferrer.this.annBuilder.annotationRef(Override.class);
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return ");
                _builder.append(isMutable, "");
                _builder.append(";");
              }
            };
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toMethod(pattern, "isMutable", _typeRef_1, _function_1);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
      }
    };
    return this._eMFJvmTypesBuilder.toClass(pattern, innerClassName, _function);
  }
}
