/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.logging.Formatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.formatters.FormatStep;

public class CompoundFormatStep
implements FormatStep {
    private final FormatStep[] steps;

    protected CompoundFormatStep(FormatStep[] clonedSteps) {
        this.steps = clonedSteps;
    }

    @Override
    public void render(Formatter formatter, StringBuilder builder, ExtLogRecord record) {
        for (FormatStep step : this.steps) {
            step.render(formatter, builder, record);
        }
    }

    @Override
    public void render(StringBuilder builder, ExtLogRecord record) {
        this.render(null, builder, record);
    }

    @Override
    public int estimateLength() {
        int est = 0;
        for (FormatStep step : this.steps) {
            est += step.estimateLength();
        }
        return est;
    }

    @Override
    public boolean isCallerInformationRequired() {
        for (FormatStep step : this.steps) {
            if (!step.isCallerInformationRequired()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FormatStep.ItemType getItemType() {
        return FormatStep.ItemType.COMPOUND;
    }

    @Override
    public int childStepCount() {
        return this.steps.length;
    }

    @Override
    public FormatStep getChildStep(int idx) {
        return this.steps[idx];
    }

    @Override
    public FormatStep[] childSteps() {
        return (FormatStep[])this.steps.clone();
    }
}

