/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.Commands;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CommandConstants;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;

public final class ProtonBasedCommand
implements Command {
    private final Optional<String> validationError;
    private final Message message;
    private final String tenantId;
    private final String deviceId;
    private final String correlationId;
    private final String replyToId;
    private final String requestId;
    private String gatewayId;

    private ProtonBasedCommand(Optional<String> validationError, Message message, String tenantId, String deviceId, String correlationId, String replyToId) {
        this.validationError = validationError;
        this.message = message;
        this.tenantId = Objects.requireNonNull(tenantId);
        this.deviceId = Objects.requireNonNull(deviceId);
        this.correlationId = correlationId;
        this.replyToId = replyToId;
        this.requestId = Commands.encodeRequestIdParameters(correlationId, replyToId, deviceId, MessagingType.amqp);
    }

    public static ProtonBasedCommand from(Message message) {
        Objects.requireNonNull(message);
        if (!ResourceIdentifier.isValid(message.getAddress())) {
            throw new IllegalArgumentException("address is empty or invalid");
        }
        ResourceIdentifier addressIdentifier = ResourceIdentifier.fromString(message.getAddress());
        if (Strings.isNullOrEmpty(addressIdentifier.getTenantId())) {
            throw new IllegalArgumentException("address is missing tenant-id part");
        }
        if (Strings.isNullOrEmpty(addressIdentifier.getResourceId())) {
            throw new IllegalArgumentException("address is missing device-id part");
        }
        String tenantId = addressIdentifier.getTenantId();
        String deviceId = addressIdentifier.getResourceId();
        StringJoiner validationErrorJoiner = new StringJoiner(", ");
        if (message.getSubject() == null) {
            validationErrorJoiner.add("subject not set");
        }
        ProtonBasedCommand.getUnsupportedPayloadReason(message).ifPresent(validationErrorJoiner::add);
        String correlationId = null;
        Object correlationIdObj = Optional.ofNullable(message.getCorrelationId()).orElse(message.getMessageId());
        if (correlationIdObj != null) {
            if (correlationIdObj instanceof String) {
                correlationId = (String)correlationIdObj;
            } else {
                validationErrorJoiner.add("message/correlation-id is not of type string, actual type: " + correlationIdObj.getClass().getName());
            }
        } else if (message.getReplyTo() != null) {
            validationErrorJoiner.add("neither message-id nor correlation-id is set");
        }
        String replyToId = null;
        if (message.getReplyTo() != null) {
            try {
                ResourceIdentifier replyTo = ResourceIdentifier.fromString(message.getReplyTo());
                if (!CommandConstants.isNorthboundCommandResponseEndpoint(replyTo.getEndpoint())) {
                    validationErrorJoiner.add("reply-to not a command address: " + message.getReplyTo());
                } else if (tenantId != null && !tenantId.equals(replyTo.getTenantId())) {
                    validationErrorJoiner.add("reply-to not targeted at tenant " + tenantId + ": " + message.getReplyTo());
                } else {
                    replyToId = replyTo.getPathWithoutBase();
                    if (replyToId.isEmpty()) {
                        validationErrorJoiner.add("reply-to part after tenant not set: " + message.getReplyTo());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                validationErrorJoiner.add("reply-to cannot be parsed: " + message.getReplyTo());
            }
        }
        return new ProtonBasedCommand(validationErrorJoiner.length() > 0 ? Optional.of(validationErrorJoiner.toString()) : Optional.empty(), message, tenantId, deviceId, correlationId, replyToId);
    }

    public static ProtonBasedCommand fromRoutedCommandMessage(Message message) {
        ProtonBasedCommand command = ProtonBasedCommand.from(message);
        Optional.ofNullable(AmqpUtils.getApplicationProperty(message, "via", String.class)).filter(s -> !s.isEmpty()).ifPresent(command::setGatewayId);
        return command;
    }

    Message getMessage() {
        return this.message;
    }

    @Override
    public MessagingType getMessagingType() {
        return MessagingType.amqp;
    }

    @Override
    public boolean isOneWay() {
        return this.replyToId == null;
    }

    @Override
    public boolean isValid() {
        return !this.validationError.isPresent();
    }

    @Override
    public String getInvalidCommandReason() {
        if (!this.validationError.isPresent()) {
            throw new IllegalStateException("command is valid");
        }
        return this.validationError.get();
    }

    @Override
    public String getTenant() {
        return this.tenantId;
    }

    @Override
    public String getGatewayOrDeviceId() {
        return Optional.ofNullable(this.gatewayId).orElse(this.deviceId);
    }

    @Override
    public boolean isTargetedAtGateway() {
        return this.gatewayId != null;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getGatewayId() {
        return this.gatewayId;
    }

    @Override
    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    @Override
    public String getName() {
        this.requireValid();
        return this.message.getSubject();
    }

    @Override
    public String getRequestId() {
        this.requireValid();
        return this.requestId;
    }

    @Override
    public Buffer getPayload() {
        this.requireValid();
        return AmqpUtils.getPayload(this.message);
    }

    @Override
    public int getPayloadSize() {
        return AmqpUtils.getPayloadSize(this.message);
    }

    @Override
    public String getContentType() {
        this.requireValid();
        return this.message.getContentType();
    }

    @Override
    public String getReplyToId() {
        this.requireValid();
        return this.replyToId;
    }

    @Override
    public String getCorrelationId() {
        this.requireValid();
        return this.correlationId;
    }

    private void requireValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("command is invalid");
        }
    }

    public String toString() {
        if (this.isValid()) {
            if (this.isTargetedAtGateway()) {
                return String.format("Command [name: %s, tenant-id: %s, gateway-id: %s, device-id: %s, request-id: %s]", this.getName(), this.tenantId, this.gatewayId, this.deviceId, this.requestId);
            }
            return String.format("Command [name: %s, tenant-id: %s, device-id: %s, request-id: %s]", this.getName(), this.tenantId, this.deviceId, this.requestId);
        }
        return String.format("Invalid Command [tenant-id: %s, device-id: %s. error: %s]", this.tenantId, this.deviceId, this.validationError.get());
    }

    @Override
    public void logToSpan(Span span) {
        Objects.requireNonNull(span);
        if (this.isValid()) {
            TracingHelper.TAG_CORRELATION_ID.set(span, this.getCorrelationId());
            HashMap<String, String> items = new HashMap<String, String>(5);
            items.put("event", "received command message via AMQP");
            items.put("to", this.message.getAddress());
            items.put("reply-to", this.message.getReplyTo());
            items.put("name", this.getName());
            items.put("content-type", this.getContentType());
            span.log(items);
        } else {
            TracingHelper.logError(span, "received invalid command message [" + this + "]");
        }
    }

    @Override
    public Map<String, String> getDeliveryFailureNotificationProperties() {
        return null;
    }

    private static Optional<String> getUnsupportedPayloadReason(Message msg) {
        Objects.requireNonNull(msg);
        String reason = null;
        if (msg.getBody() instanceof AmqpValue) {
            Object value = ((AmqpValue)msg.getBody()).getValue();
            if (value == null) {
                reason = "message has body with empty amqp-value section";
            } else if (!(value instanceof byte[]) && !(value instanceof String)) {
                reason = String.format("message has amqp-value section body with unsupported value type [%s], supported is byte[] or String", value.getClass().getName());
            }
        } else if (msg.getBody() != null && !(msg.getBody() instanceof Data)) {
            reason = String.format("message has unsupported body section [%s], supported section types are 'data' and 'amqp-value'", msg.getBody().getClass().getName());
        }
        return Optional.ofNullable(reason);
    }
}

