/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.eventbus;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.mutiny.core.eventbus.DeliveryContext;
import io.vertx.mutiny.core.eventbus.Message;
import io.vertx.mutiny.core.eventbus.MessageConsumer;
import io.vertx.mutiny.core.eventbus.MessageProducer;
import io.vertx.mutiny.core.metrics.Measured;
import java.util.function.Consumer;
import java.util.function.Function;

@MutinyGen(value=io.vertx.core.eventbus.EventBus.class)
public class EventBus
implements Measured {
    public static final TypeArg<EventBus> __TYPE_ARG = new TypeArg<EventBus>(obj -> new EventBus((io.vertx.core.eventbus.EventBus)obj), EventBus::getDelegate);
    private final io.vertx.core.eventbus.EventBus delegate;

    public EventBus(io.vertx.core.eventbus.EventBus delegate) {
        this.delegate = delegate;
    }

    public EventBus(Object delegate) {
        this.delegate = (io.vertx.core.eventbus.EventBus)delegate;
    }

    EventBus() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.eventbus.EventBus getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventBus that = (EventBus)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @Fluent
    public EventBus send(String address, Object message) {
        this.delegate.send(address, message);
        return this;
    }

    @Fluent
    public EventBus send(String address, Object message, DeliveryOptions options) {
        this.delegate.send(address, message, options);
        return this;
    }

    @CheckReturnValue
    public <T> Uni<Message<T>> request(String address, Object message) {
        return AsyncResultUni.toUni(replyHandler -> this.delegate.request(address, message, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)replyHandler, ar -> ar.map(event -> Message.newInstance(event, TypeArg.unknown())))));
    }

    public <T> Message<T> requestAndAwait(String address, Object message) {
        return this.request(address, message).await().indefinitely();
    }

    @Fluent
    public <T> EventBus requestAndForget(String address, Object message) {
        this.request(address, message).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public <T> Uni<Message<T>> request(String address, Object message, DeliveryOptions options) {
        return AsyncResultUni.toUni(replyHandler -> this.delegate.request(address, message, options, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)replyHandler, ar -> ar.map(event -> Message.newInstance(event, TypeArg.unknown())))));
    }

    public <T> Message<T> requestAndAwait(String address, Object message, DeliveryOptions options) {
        return this.request(address, message, options).await().indefinitely();
    }

    @Fluent
    public <T> EventBus requestAndForget(String address, Object message, DeliveryOptions options) {
        this.request(address, message, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public EventBus publish(String address, Object message) {
        this.delegate.publish(address, message);
        return this;
    }

    @Fluent
    public EventBus publish(String address, Object message, DeliveryOptions options) {
        this.delegate.publish(address, message, options);
        return this;
    }

    public <T> MessageConsumer<T> consumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address), TypeArg.unknown());
        return ret;
    }

    private <T> MessageConsumer<T> __consumer(String address, Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address, new DelegatingHandler<io.vertx.core.eventbus.Message, Message>(handler, event -> Message.newInstance(event, TypeArg.unknown()))), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> consumer(String address, Consumer<Message<T>> handler) {
        return this.__consumer(address, handler != null ? new DelegatingConsumerHandler<Message<T>>(handler) : null);
    }

    public <T> MessageConsumer<T> localConsumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address), TypeArg.unknown());
        return ret;
    }

    private <T> MessageConsumer<T> __localConsumer(String address, Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address, new DelegatingHandler<io.vertx.core.eventbus.Message, Message>(handler, event -> Message.newInstance(event, TypeArg.unknown()))), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> localConsumer(String address, Consumer<Message<T>> handler) {
        return this.__localConsumer(address, handler != null ? new DelegatingConsumerHandler<Message<T>>(handler) : null);
    }

    public <T> MessageProducer<T> sender(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> sender(String address, DeliveryOptions options) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address, options), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address, options), TypeArg.unknown());
        return ret;
    }

    @Fluent
    public EventBus codecSelector(Function<Object, String> selector) {
        this.delegate.codecSelector(selector);
        return this;
    }

    @Fluent
    private <T> EventBus __addOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.delegate.addOutboundInterceptor(new DelegatingHandler<io.vertx.core.eventbus.DeliveryContext, DeliveryContext>(interceptor, event -> DeliveryContext.newInstance(event, TypeArg.unknown())));
        return this;
    }

    public <T> EventBus addOutboundInterceptor(Consumer<DeliveryContext<T>> interceptor) {
        return this.__addOutboundInterceptor(interceptor != null ? new DelegatingConsumerHandler<DeliveryContext<T>>(interceptor) : null);
    }

    @Fluent
    private <T> EventBus __removeOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.delegate.removeOutboundInterceptor(new DelegatingHandler<io.vertx.core.eventbus.DeliveryContext, DeliveryContext>(interceptor, event -> DeliveryContext.newInstance(event, TypeArg.unknown())));
        return this;
    }

    public <T> EventBus removeOutboundInterceptor(Consumer<DeliveryContext<T>> interceptor) {
        return this.__removeOutboundInterceptor(interceptor != null ? new DelegatingConsumerHandler<DeliveryContext<T>>(interceptor) : null);
    }

    @Fluent
    private <T> EventBus __addInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.delegate.addInboundInterceptor(new DelegatingHandler<io.vertx.core.eventbus.DeliveryContext, DeliveryContext>(interceptor, event -> DeliveryContext.newInstance(event, TypeArg.unknown())));
        return this;
    }

    public <T> EventBus addInboundInterceptor(Consumer<DeliveryContext<T>> interceptor) {
        return this.__addInboundInterceptor(interceptor != null ? new DelegatingConsumerHandler<DeliveryContext<T>>(interceptor) : null);
    }

    @Fluent
    private <T> EventBus __removeInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.delegate.removeInboundInterceptor(new DelegatingHandler<io.vertx.core.eventbus.DeliveryContext, DeliveryContext>(interceptor, event -> DeliveryContext.newInstance(event, TypeArg.unknown())));
        return this;
    }

    public <T> EventBus removeInboundInterceptor(Consumer<DeliveryContext<T>> interceptor) {
        return this.__removeInboundInterceptor(interceptor != null ? new DelegatingConsumerHandler<DeliveryContext<T>>(interceptor) : null);
    }

    @Fluent
    public EventBus clusterSerializableChecker(Function<String, Boolean> classNamePredicate) {
        this.delegate.clusterSerializableChecker(classNamePredicate);
        return this;
    }

    @Fluent
    public EventBus serializableChecker(Function<String, Boolean> classNamePredicate) {
        this.delegate.serializableChecker(classNamePredicate);
        return this;
    }

    @Fluent
    public EventBus registerCodec(MessageCodec codec) {
        this.delegate.registerCodec(codec);
        return this;
    }

    @Fluent
    public EventBus unregisterCodec(String name) {
        this.delegate.unregisterCodec(name);
        return this;
    }

    public static EventBus newInstance(io.vertx.core.eventbus.EventBus arg) {
        return arg != null ? new EventBus(arg) : null;
    }
}

