/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.admin.OffsetSpecConverter;

@DataObject(generateConverter=true)
public class OffsetSpec {
    public static final OffsetSpec EARLIEST = new OffsetSpec(-2L);
    public static final OffsetSpec LATEST = new OffsetSpec(-1L);
    private long spec;

    public static final OffsetSpec TIMESTAMP(long timestamp) {
        return new OffsetSpec(timestamp);
    }

    public OffsetSpec(long spec) {
        this.spec = spec;
    }

    public OffsetSpec(JsonObject json) {
        OffsetSpecConverter.fromJson(json, this);
    }

    public long getSpec() {
        return this.spec;
    }

    public OffsetSpec setSpec(long spec) {
        this.spec = spec;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OffsetSpecConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        String value = EARLIEST == this ? "EARLIEST" : (LATEST == this ? "LATEST" : String.format("TIMESTAMP(%d)", this.spec));
        return "OffsetSpec{spec=" + value + "}";
    }
}

