/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.lang;

import io.smallrye.mutiny.vertx.codegen.lang.ConditionalCodeWriter;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;

public class IterableMethodCodeWriter
implements ConditionalCodeWriter {
    @Override
    public void generate(ClassModel model, PrintWriter writer) {
        TypeInfo iterableArg = model.getIterableArg();
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "iterator".equals(it.getName()))) {
            writer.println("  @Override");
            writer.printf("  public java.util.Iterator<%s> iterator() {%n", this.genTypeName(iterableArg));
            if (iterableArg.getKind() == ClassKind.API) {
                writer.format("    java.util.function.Function<%s, %s> conv = %s::newInstance;%n", iterableArg.getName(), this.genTypeName(iterableArg.getRaw()), this.genTypeName(iterableArg));
                writer.println("    return new io.smallrye.mutiny.vertx.impl.MappingIterator<>(delegate.iterator(), conv);");
            } else if (iterableArg.isVariable()) {
                String typeVar = iterableArg.getSimpleName();
                writer.format("    java.util.function.Function<%s, %s> conv = (java.util.function.Function<%s, %s>) __typeArg_0.wrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer.println("    return new io.smallrye.mutiny.vertx.impl.MappingIterator<>(delegate.iterator(), conv);");
            } else {
                writer.println("    return delegate.iterator();");
            }
            writer.println("  }");
            writer.println();
        }
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "toMulti".equals(it.getName()))) {
            writer.print("  @CheckReturnValue\n");
            writer.printf("  public Multi<%s> toMulti() {%n", this.genTypeName(iterableArg));
            writer.println("    return Multi.createFrom().iterable(this);");
            writer.println("  }");
            writer.println();
        }
    }

    @Override
    public boolean test(ClassModel model) {
        return model.isConcrete() && model.isIterable();
    }
}

