/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayAddress;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayAddressBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayAddressFluentImpl;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayStatusFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ListenerStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ListenerStatusBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ListenerStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GatewayStatusFluentImpl<A extends GatewayStatusFluent<A>>
extends BaseFluent<A>
implements GatewayStatusFluent<A> {
    private ArrayList<GatewayAddressBuilder> addresses = new ArrayList();
    private List<Condition> conditions = new ArrayList<Condition>();
    private ArrayList<ListenerStatusBuilder> listeners = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GatewayStatusFluentImpl() {
    }

    public GatewayStatusFluentImpl(GatewayStatus instance) {
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withConditions(instance.getConditions());
            this.withListeners(instance.getListeners());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToAddresses(int index, GatewayAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, GatewayAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(GatewayAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<GatewayAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(GatewayAddress ... items) {
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<GatewayAddress> items) {
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddresses(Predicate<GatewayAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<GatewayAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            GatewayAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GatewayAddress> getAddresses() {
        return this.addresses != null ? GatewayStatusFluentImpl.build(this.addresses) : null;
    }

    @Override
    public List<GatewayAddress> buildAddresses() {
        return this.addresses != null ? GatewayStatusFluentImpl.build(this.addresses) : null;
    }

    @Override
    public GatewayAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    @Override
    public GatewayAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public GatewayAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public GatewayAddress buildMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        for (GatewayAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        for (GatewayAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<GatewayAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (GatewayAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(GatewayAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove("addresses");
        }
        if (addresses != null) {
            for (GatewayAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addNewAddress(String type, String value) {
        return this.addToAddresses(new GatewayAddress(type, value));
    }

    @Override
    public GatewayStatusFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public GatewayStatusFluent.AddressesNested<A> addNewAddressLike(GatewayAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public GatewayStatusFluent.AddressesNested<A> setNewAddressLike(int index, GatewayAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public GatewayStatusFluent.AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public GatewayStatusFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public GatewayStatusFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public GatewayStatusFluent.AddressesNested<A> editMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addToListeners(int index, ListenerStatus item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get("listeners").add(index, builder);
            this.listeners.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToListeners(int index, ListenerStatus item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get("listeners").set(index, builder);
            this.listeners.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToListeners(ListenerStatus ... items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToListeners(Collection<ListenerStatus> items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromListeners(ListenerStatus ... items) {
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get("listeners").remove(builder);
            if (this.listeners == null) continue;
            this.listeners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromListeners(Collection<ListenerStatus> items) {
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get("listeners").remove(builder);
            if (this.listeners == null) continue;
            this.listeners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromListeners(Predicate<ListenerStatusBuilder> predicate) {
        if (this.listeners == null) {
            return (A)this;
        }
        Iterator<ListenerStatusBuilder> each = this.listeners.iterator();
        Object visitables = this._visitables.get("listeners");
        while (each.hasNext()) {
            ListenerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ListenerStatus> getListeners() {
        return this.listeners != null ? GatewayStatusFluentImpl.build(this.listeners) : null;
    }

    @Override
    public List<ListenerStatus> buildListeners() {
        return this.listeners != null ? GatewayStatusFluentImpl.build(this.listeners) : null;
    }

    @Override
    public ListenerStatus buildListener(int index) {
        return this.listeners.get(index).build();
    }

    @Override
    public ListenerStatus buildFirstListener() {
        return this.listeners.get(0).build();
    }

    @Override
    public ListenerStatus buildLastListener() {
        return this.listeners.get(this.listeners.size() - 1).build();
    }

    @Override
    public ListenerStatus buildMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withListeners(List<ListenerStatus> listeners) {
        if (this.listeners != null) {
            this._visitables.get("listeners").clear();
        }
        if (listeners != null) {
            this.listeners = new ArrayList();
            for (ListenerStatus item : listeners) {
                this.addToListeners(item);
            }
        } else {
            this.listeners = null;
        }
        return (A)this;
    }

    @Override
    public A withListeners(ListenerStatus ... listeners) {
        if (this.listeners != null) {
            this.listeners.clear();
            this._visitables.remove("listeners");
        }
        if (listeners != null) {
            for (ListenerStatus item : listeners) {
                this.addToListeners(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    @Override
    public GatewayStatusFluent.ListenersNested<A> addNewListener() {
        return new ListenersNestedImpl();
    }

    @Override
    public GatewayStatusFluent.ListenersNested<A> addNewListenerLike(ListenerStatus item) {
        return new ListenersNestedImpl(-1, item);
    }

    @Override
    public GatewayStatusFluent.ListenersNested<A> setNewListenerLike(int index, ListenerStatus item) {
        return new ListenersNestedImpl(index, item);
    }

    @Override
    public GatewayStatusFluent.ListenersNested<A> editListener(int index) {
        if (this.listeners.size() <= index) {
            throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    @Override
    public GatewayStatusFluent.ListenersNested<A> editFirstListener() {
        if (this.listeners.size() == 0) {
            throw new RuntimeException("Can't edit first listeners. The list is empty.");
        }
        return this.setNewListenerLike(0, this.buildListener(0));
    }

    @Override
    public GatewayStatusFluent.ListenersNested<A> editLastListener() {
        int index = this.listeners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last listeners. The list is empty.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    @Override
    public GatewayStatusFluent.ListenersNested<A> editMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!predicate.test(this.listeners.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching listeners. No match found.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewayStatusFluentImpl that = (GatewayStatusFluentImpl)o;
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.listeners, that.listeners)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.listeners, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.listeners != null) {
            sb.append("listeners:");
            sb.append(this.listeners + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ListenersNestedImpl<N>
    extends ListenerStatusFluentImpl<GatewayStatusFluent.ListenersNested<N>>
    implements GatewayStatusFluent.ListenersNested<N>,
    Nested<N> {
        ListenerStatusBuilder builder;
        int index;

        ListenersNestedImpl(int index, ListenerStatus item) {
            this.index = index;
            this.builder = new ListenerStatusBuilder(this, item);
        }

        ListenersNestedImpl() {
            this.index = -1;
            this.builder = new ListenerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)GatewayStatusFluentImpl.this.setToListeners(this.index, this.builder.build());
        }

        @Override
        public N endListener() {
            return this.and();
        }
    }

    class AddressesNestedImpl<N>
    extends GatewayAddressFluentImpl<GatewayStatusFluent.AddressesNested<N>>
    implements GatewayStatusFluent.AddressesNested<N>,
    Nested<N> {
        GatewayAddressBuilder builder;
        int index;

        AddressesNestedImpl(int index, GatewayAddress item) {
            this.index = index;
            this.builder = new GatewayAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new GatewayAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)GatewayStatusFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

