/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.hono.util.RequestResponseApiConstants;

public final class CredentialsConstants
extends RequestResponseApiConstants {
    public static final String AUDIENCE_HONO_ADAPTER = "hono-adapter";
    public static final String CLAIM_TENANT_ID = "tid";
    public static final String FIELD_USERNAME = "username";
    public static final String FIELD_PASSWORD = "password";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_AUTH_ID = "auth-id";
    public static final String FIELD_SECRETS = "secrets";
    public static final String FIELD_CREDENTIALS_TOTAL = "total";
    public static final String FIELD_SECRETS_ALGORITHM = "algorithm";
    public static final String FIELD_SECRETS_PWD_HASH = "pwd-hash";
    public static final String FIELD_SECRETS_PWD_PLAIN = "pwd-plain";
    public static final String FIELD_SECRETS_SALT = "salt";
    public static final String FIELD_SECRETS_HASH_FUNCTION = "hash-function";
    public static final String FIELD_SECRETS_KEY = "key";
    public static final String FIELD_SECRETS_NOT_BEFORE = "not-before";
    public static final String FIELD_SECRETS_NOT_AFTER = "not-after";
    public static final String FIELD_CLIENT_CERT = "client-certificate";
    public static final String CREDENTIALS_ENDPOINT = "credentials";
    public static final String SECRETS_TYPE_X509_CERT = "x509-cert";
    public static final String SECRETS_TYPE_HASHED_PASSWORD = "hashed-password";
    public static final String SECRETS_TYPE_PRESHARED_KEY = "psk";
    public static final String SECRETS_TYPE_RAW_PUBLIC_KEY = "rpk";
    public static final String SPECIFIER_WILDCARD = "*";
    public static final String HASH_FUNCTION_BCRYPT = "bcrypt";
    public static final String HASH_FUNCTION_SHA256 = "sha-256";
    public static final String HASH_FUNCTION_SHA512 = "sha-512";
    public static final String DEFAULT_HASH_FUNCTION = "sha-256";
    public static final String RSA_ALG = "RSA";
    public static final String EC_ALG = "EC";
    public static final String EVENT_BUS_ADDRESS_CREDENTIALS_IN = "credentials.in";
    public static final Pattern PATTERN_TYPE_VALUE = Pattern.compile("^[a-z0-9-]+$");

    private CredentialsConstants() {
    }

    public static JsonObject getSearchCriteria(String type, String authId) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(authId);
        return new JsonObject().put(FIELD_TYPE, type).put(FIELD_AUTH_ID, authId);
    }

    public static String getHashFunction(JsonObject secret) {
        Objects.requireNonNull(secret);
        return Optional.ofNullable(secret.getValue(FIELD_SECRETS_HASH_FUNCTION)).map(o -> {
            if (o instanceof String) {
                return (String)o;
            }
            throw new IllegalArgumentException("secret contains invalid hash function value");
        }).orElse("sha-256");
    }

    public static String getPasswordHash(JsonObject secret) {
        Objects.requireNonNull(secret);
        return Optional.ofNullable(secret.getValue(FIELD_SECRETS_PWD_HASH)).map(o -> {
            if (o instanceof String) {
                return (String)o;
            }
            throw new IllegalArgumentException("secret contains invalid hash function value");
        }).orElseThrow(() -> new IllegalArgumentException("secret does not contain password hash"));
    }

    public static String getPasswordSalt(JsonObject secret) {
        Objects.requireNonNull(secret);
        return Optional.ofNullable(secret.getValue(FIELD_SECRETS_SALT)).map(o -> {
            if (o instanceof String) {
                return (String)o;
            }
            throw new IllegalArgumentException("secret contains invalid salt value");
        }).orElse(null);
    }

    public static enum CredentialsAction {
        get,
        add,
        update,
        unknown;


        public static CredentialsAction from(String subject) {
            if (subject != null) {
                try {
                    return CredentialsAction.valueOf(subject);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return unknown;
        }

        public static boolean isValid(String subject) {
            return CredentialsAction.from(subject) != unknown;
        }
    }
}

