/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.serialization;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.serialization.BufferDeserializer;
import io.vertx.kafka.client.serialization.BufferSerializer;
import io.vertx.kafka.client.serialization.JsonArrayDeserializer;
import io.vertx.kafka.client.serialization.JsonArraySerializer;
import io.vertx.kafka.client.serialization.JsonObjectDeserializer;
import io.vertx.kafka.client.serialization.JsonObjectSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;

public class VertxSerdes
extends Serdes {
    public static Serde<Buffer> Buffer() {
        return new BufferSerde();
    }

    public static Serde<JsonArray> JsonArray() {
        return new JsonArraySerde();
    }

    public static Serde<JsonObject> JsonObject() {
        return new JsonObjectSerde();
    }

    public static <T> Serde<T> serdeFrom(Class<T> type) {
        if (Buffer.class.isAssignableFrom(type)) {
            return VertxSerdes.Buffer();
        }
        if (JsonArray.class.isAssignableFrom(type)) {
            return VertxSerdes.JsonArray();
        }
        if (JsonObject.class.isAssignableFrom(type)) {
            return VertxSerdes.JsonObject();
        }
        return Serdes.serdeFrom(type);
    }

    public static final class JsonObjectSerde
    extends Serdes.WrapperSerde<JsonObject> {
        public JsonObjectSerde() {
            super(new JsonObjectSerializer(), new JsonObjectDeserializer());
        }
    }

    public static final class JsonArraySerde
    extends Serdes.WrapperSerde<JsonArray> {
        public JsonArraySerde() {
            super(new JsonArraySerializer(), new JsonArrayDeserializer());
        }
    }

    public static final class BufferSerde
    extends Serdes.WrapperSerde<Buffer> {
        public BufferSerde() {
            super(new BufferSerializer(), new BufferDeserializer());
        }
    }
}

