/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.ChainAuth;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import java.util.ArrayList;
import java.util.List;

public class ChainAuthImpl
implements ChainAuth {
    private final List<AuthenticationProvider> providers = new ArrayList<AuthenticationProvider>();
    private final boolean all;

    public ChainAuthImpl(boolean all) {
        this.all = all;
    }

    @Override
    public ChainAuth add(AuthenticationProvider other) {
        this.providers.add(other);
        return this;
    }

    @Override
    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate(credentials).onComplete(resultHandler);
    }

    @Override
    public Future<User> authenticate(Credentials credentials) {
        try {
            credentials.checkValid(null);
        }
        catch (CredentialValidationException e) {
            return Future.failedFuture(e);
        }
        return this.authenticate(credentials.toJson());
    }

    @Override
    public Future<User> authenticate(JsonObject authInfo) {
        if (this.providers.size() == 0) {
            return Future.failedFuture("No providers in the auth chain.");
        }
        return this.iterate(0, authInfo, null);
    }

    private Future<User> iterate(int idx, JsonObject authInfo, User previousUser) {
        if (idx >= this.providers.size()) {
            if (!this.all) {
                return Future.failedFuture("No more providers in the auth chain.");
            }
            return Future.succeededFuture(previousUser);
        }
        return this.providers.get(idx).authenticate(authInfo).compose(user -> {
            if (!this.all) {
                return Future.succeededFuture(user);
            }
            return this.iterate(idx + 1, authInfo, previousUser == null ? user : previousUser.merge((User)user));
        }).recover(err -> {
            if (!this.all) {
                return this.iterate(idx + 1, authInfo, null);
            }
            return Future.failedFuture(err);
        });
    }
}

