/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.ItemWithContext;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiBroadcast;
import io.smallrye.mutiny.groups.MultiCollect;
import io.smallrye.mutiny.groups.MultiConvert;
import io.smallrye.mutiny.groups.MultiCreate;
import io.smallrye.mutiny.groups.MultiCreateBy;
import io.smallrye.mutiny.groups.MultiDemandPacing;
import io.smallrye.mutiny.groups.MultiGroup;
import io.smallrye.mutiny.groups.MultiIfNoItem;
import io.smallrye.mutiny.groups.MultiOnCancel;
import io.smallrye.mutiny.groups.MultiOnCompletion;
import io.smallrye.mutiny.groups.MultiOnFailure;
import io.smallrye.mutiny.groups.MultiOnItem;
import io.smallrye.mutiny.groups.MultiOnRequest;
import io.smallrye.mutiny.groups.MultiOnSubscribe;
import io.smallrye.mutiny.groups.MultiOnTerminate;
import io.smallrye.mutiny.groups.MultiOverflow;
import io.smallrye.mutiny.groups.MultiSelect;
import io.smallrye.mutiny.groups.MultiSkip;
import io.smallrye.mutiny.groups.MultiSubscribe;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public interface Multi<T>
extends Publisher<T> {
    @CheckReturnValue
    public static MultiCreate createFrom() {
        return MultiCreate.INSTANCE;
    }

    @CheckReturnValue
    public static MultiCreateBy createBy() {
        return MultiCreateBy.INSTANCE;
    }

    @CheckReturnValue
    public MultiSubscribe<T> subscribe();

    @CheckReturnValue
    public MultiOnItem<T> onItem();

    @CheckReturnValue
    default public <O> O stage(Function<Multi<T>, O> stage) {
        return ParameterValidation.nonNull(stage, "stage").apply(this);
    }

    @CheckReturnValue
    public Uni<T> toUni();

    @CheckReturnValue
    public MultiOnFailure<T> onFailure();

    @CheckReturnValue
    public MultiOnFailure<T> onFailure(Predicate<? super Throwable> var1);

    @Deprecated
    @CheckReturnValue
    public MultiOnSubscribe<T> onSubscribe();

    @CheckReturnValue
    public MultiOnSubscribe<T> onSubscription();

    @CheckReturnValue
    public MultiOnFailure<T> onFailure(Class<? extends Throwable> var1);

    @Experimental(value="Multi timeouts are an experimental feature.")
    @CheckReturnValue
    public MultiIfNoItem<T> ifNoItem();

    @CheckReturnValue
    public Multi<T> cache();

    @CheckReturnValue
    public MultiCollect<T> collect();

    @CheckReturnValue
    public MultiGroup<T> group();

    @CheckReturnValue
    public Multi<T> emitOn(Executor var1);

    @CheckReturnValue
    public Multi<T> runSubscriptionOn(Executor var1);

    @CheckReturnValue
    public MultiOnCompletion<T> onCompletion();

    @CheckReturnValue
    public MultiSelect<T> select();

    @CheckReturnValue
    public MultiSkip<T> skip();

    @CheckReturnValue
    public MultiOverflow<T> onOverflow();

    @CheckReturnValue
    public MultiBroadcast<T> broadcast();

    @CheckReturnValue
    public MultiConvert<T> convert();

    @CheckReturnValue
    default public Multi<T> filter(Predicate<? super T> predicate) {
        return this.select().where(predicate);
    }

    @CheckReturnValue
    default public <O> Multi<O> map(Function<? super T, ? extends O> mapper) {
        return this.onItem().transform(mapper);
    }

    @CheckReturnValue
    default public <O> Multi<O> flatMap(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.onItem().transformToMultiAndMerge(mapper);
    }

    @CheckReturnValue
    default public Multi<T> call(Function<? super T, Uni<?>> action) {
        return this.onItem().call(action);
    }

    @CheckReturnValue
    default public Multi<T> call(Supplier<Uni<?>> action) {
        return this.onItem().call(action);
    }

    @CheckReturnValue
    default public Multi<T> invoke(Consumer<? super T> callback) {
        return this.onItem().invoke(ParameterValidation.nonNull(callback, "callback"));
    }

    @CheckReturnValue
    default public Multi<T> invoke(Runnable callback) {
        return this.onItem().invoke(callback);
    }

    @CheckReturnValue
    default public <O> Multi<O> concatMap(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.onItem().transformToMultiAndConcatenate(mapper);
    }

    @CheckReturnValue
    public MultiOnTerminate<T> onTermination();

    @CheckReturnValue
    public MultiOnCancel<T> onCancellation();

    @CheckReturnValue
    public MultiOnRequest<T> onRequest();

    @CheckReturnValue
    default public <R> Multi<R> plug(Function<Multi<T>, Multi<R>> operatorProvider) {
        Function<Multi<Multi>, Multi<R>> provider = ParameterValidation.nonNull(operatorProvider, "operatorProvider");
        return Infrastructure.onMultiCreation(ParameterValidation.nonNull(provider.apply(this), "multi"));
    }

    @CheckReturnValue
    public Multi<T> toHotStream();

    @CheckReturnValue
    public Multi<T> log(String var1);

    @CheckReturnValue
    public Multi<T> log();

    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    @CheckReturnValue
    default public <R> Multi<R> withContext(BiFunction<Multi<T>, Context, Multi<R>> builder) {
        throw new UnsupportedOperationException("Default method added to limit binary incompatibility");
    }

    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    @CheckReturnValue
    default public Multi<ItemWithContext<T>> attachContext() {
        return this.withContext((multi, ctx) -> multi.onItem().transform(item -> new ItemWithContext<Object>((Context)ctx, item)));
    }

    @Experimental(value="Demand pacing is a new experimental API introduced in Mutiny 1.5.0")
    @CheckReturnValue
    public MultiDemandPacing<T> paceDemand();

    @Experimental(value="Demand capping is a new experimental API introduced in Mutiny 1.5.0")
    @CheckReturnValue
    default public Multi<T> capDemandsTo(long max) {
        long actual = ParameterValidation.positive(max, "max");
        return this.capDemandsUsing(outstanding -> Math.min(outstanding, actual));
    }

    @Experimental(value="Demand capping is a new experimental API introduced in Mutiny 1.5.0")
    @CheckReturnValue
    public Multi<T> capDemandsUsing(LongFunction<Long> var1);
}

