/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;

public class ServiceBuilder
extends ServiceFluentImpl<ServiceBuilder>
implements VisitableBuilder<Service, ServiceBuilder> {
    ServiceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceBuilder() {
        this(false);
    }

    public ServiceBuilder(Boolean validationEnabled) {
        this(new Service(), validationEnabled);
    }

    public ServiceBuilder(ServiceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Service(), validationEnabled);
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Service instance) {
        this(fluent, instance, false);
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Service instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBuilder(Service instance) {
        this(instance, (Boolean)false);
    }

    public ServiceBuilder(Service instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Service build() {
        Service buildable = new Service(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

