/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.CredentialException;

public final class AuthenticationConstants {
    public static final String APPLICATION_PROPERTY_TYPE = "type";
    public static final String ENDPOINT_NAME_AUTHENTICATION = "cbs";
    public static final String EVENT_BUS_ADDRESS_AUTHENTICATION_IN = "authentication.in";
    public static final String FIELD_AUTHORIZATION_ID = "authorization-id";
    public static final String FIELD_MECHANISM = "mechanism";
    public static final String FIELD_SASL_RESPONSE = "sasl-response";
    public static final String FIELD_SUBJECT_DN = "subject-dn";
    public static final String FIELD_TOKEN = "token";
    public static final String MECHANISM_PLAIN = "PLAIN";
    public static final String MECHANISM_EXTERNAL = "EXTERNAL";
    public static final String QUALIFIER_AUTHENTICATION = "authentication";
    public static final String TYPE_AMQP_JWT = "amqp:jwt";
    private static final Pattern PATTERN_CN = Pattern.compile("^CN=(.+?)(?:,\\s*[A-Z]{1,2}=.+|$)");

    private AuthenticationConstants() {
    }

    public static JsonObject getAuthenticationRequest(String mechanism, byte[] saslResponse) {
        return new JsonObject().put(FIELD_MECHANISM, Objects.requireNonNull(mechanism)).put(FIELD_SASL_RESPONSE, Objects.requireNonNull(saslResponse));
    }

    public static JsonObject getAuthenticationReply(String token) {
        return new JsonObject().put(FIELD_TOKEN, Objects.requireNonNull(token));
    }

    public static String getCommonName(String subject) {
        Matcher matcher = PATTERN_CN.matcher(subject);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String[] parseSaslResponse(byte[] saslResponse) throws CredentialException {
        ArrayList<String> fields = new ArrayList<String>();
        Buffer b = Buffer.buffer();
        for (int pos = 0; pos < saslResponse.length; ++pos) {
            byte val = saslResponse[pos];
            if (val == 0) {
                fields.add(b.toString(StandardCharsets.UTF_8));
                b = Buffer.buffer();
                continue;
            }
            b.appendByte(val);
        }
        fields.add(b.toString(StandardCharsets.UTF_8));
        if (fields.size() != 3) {
            throw new CredentialException("client provided malformed PLAIN response");
        }
        if (fields.get(1) == null || ((String)fields.get(1)).length() == 0) {
            throw new CredentialException("PLAIN response must contain an authentication ID");
        }
        if (fields.get(2) == null || ((String)fields.get(2)).length() == 0) {
            throw new CredentialException("PLAIN response must contain a password");
        }
        return fields.toArray(new String[fields.size()]);
    }
}

