/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.tracing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.opentracing.Span;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.TenantObject;
import org.eclipse.hono.util.TracingSamplingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TenantTraceSamplingHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TenantTraceSamplingHelper.class);

    private TenantTraceSamplingHelper() {
    }

    public static OptionalInt getTraceSamplingPriority(TenantObject tenantObject, String authId) {
        Objects.requireNonNull(tenantObject);
        return Optional.ofNullable(TenantTraceSamplingHelper.getSamplingMode(tenantObject, authId)).map(mode -> TenantTraceSamplingHelper.getSamplingPriority(mode)).orElse(OptionalInt.empty());
    }

    public static OptionalInt applyTraceSamplingPriority(TenantObject tenantObject, String authId, Span span) {
        Objects.requireNonNull(tenantObject);
        Objects.requireNonNull(span);
        return Optional.ofNullable(TenantTraceSamplingHelper.getSamplingMode(tenantObject, authId)).map(mode -> TenantTraceSamplingHelper.getSamplingPriority(mode)).map(samplingPriority -> {
            samplingPriority.ifPresent(prio -> {
                LOG.trace("setting trace sampling prio to {} for tenant [{}], auth-id [{}]", prio, tenantObject.getTenantId(), authId);
                TracingHelper.setTraceSamplingPriority(span, prio);
            });
            return samplingPriority;
        }).orElse(OptionalInt.empty());
    }

    @JsonIgnore
    private static TracingSamplingMode getSamplingMode(TenantObject tenantObject, String authId) {
        return Optional.ofNullable(tenantObject.getTracingConfig()).map(config -> config.getSamplingMode(authId)).orElse(null);
    }

    private static OptionalInt getSamplingPriority(TracingSamplingMode mode) {
        switch (mode) {
            case ALL: {
                return OptionalInt.of(1);
            }
            case NONE: {
                return OptionalInt.of(0);
            }
        }
        return OptionalInt.empty();
    }
}

