/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.util.CommandConstants;
import org.eclipse.hono.util.EventConstants;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.ResourceLimits;
import org.eclipse.hono.util.TelemetryConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DownstreamMessageProperties {
    private static final Logger LOG = LoggerFactory.getLogger(DownstreamMessageProperties.class);
    private final Map<String, Object> props = new HashMap<String, Object>();
    private final ResourceLimits resourceLimits;
    private final String endpointName;

    public DownstreamMessageProperties(String endpointName, Map<String, Object> tenantLevelDefaults, Map<String, Object> deviceLevelDefaults, Map<String, Object> messageProperties, ResourceLimits resourceLimits) {
        this.endpointName = Objects.requireNonNull(endpointName);
        this.resourceLimits = resourceLimits;
        Optional.ofNullable(tenantLevelDefaults).ifPresent(this.props::putAll);
        Optional.ofNullable(deviceLevelDefaults).ifPresent(this.props::putAll);
        Optional.ofNullable(messageProperties).ifPresent(this.props::putAll);
        this.applyLimits();
    }

    private void applyLimits() {
        if (TelemetryConstants.isTelemetryEndpoint(this.endpointName)) {
            this.applyTelemetryLimits();
        } else if (EventConstants.isEventEndpoint(this.endpointName)) {
            this.applyEventLimits();
        } else if (CommandConstants.isNorthboundCommandResponseEndpoint(this.endpointName)) {
            this.applyCommandResponseLimits();
        }
    }

    private void applyEventLimits() {
        long deviceSpecificTtl = Optional.ofNullable(this.props.remove("ttl")).filter(Number.class::isInstance).map(Number.class::cast).map(Number::longValue).filter(v -> v > -1L).orElse(-1L);
        long configuredMaxTtl = Optional.ofNullable(this.resourceLimits).map(ResourceLimits::getMaxTtl).filter(v -> v > -1L).orElse(-1L);
        this.setTtl(deviceSpecificTtl, configuredMaxTtl);
    }

    private void applyTelemetryLimits() {
        long configuredDefaultTtl;
        QoS qos = Optional.ofNullable(this.props.get("qos")).filter(Integer.class::isInstance).map(Integer.class::cast).map(QoS::from).orElse(QoS.AT_MOST_ONCE);
        long configuredDefaultTtlQoS0 = this.getNormalizedTtlPropertyValue("ttl-telemetry-qos0");
        long configuredDefaultTtlQoS1 = this.getNormalizedTtlPropertyValue("ttl-telemetry-qos1");
        long configuredMaxTtl = switch (qos) {
            case QoS.AT_MOST_ONCE -> {
                configuredDefaultTtl = configuredDefaultTtlQoS0;
                yield Optional.ofNullable(this.resourceLimits).map(ResourceLimits::getMaxTtlTelemetryQoS0).filter(v -> v > -1L).orElse(-1L);
            }
            default -> {
                configuredDefaultTtl = configuredDefaultTtlQoS1;
                yield Optional.ofNullable(this.resourceLimits).map(ResourceLimits::getMaxTtlTelemetryQoS1).filter(v -> v > -1L).orElse(-1L);
            }
        };
        long deviceProvidedTtl = this.getNormalizedTtlPropertyValue("ttl");
        if (deviceProvidedTtl > -1L) {
            this.setTtl(deviceProvidedTtl, configuredMaxTtl);
        } else {
            this.setTtl(configuredDefaultTtl, configuredMaxTtl);
        }
    }

    private void applyCommandResponseLimits() {
        long configuredDefaultTtl = this.getNormalizedTtlPropertyValue("ttl-command-response");
        long configuredMaxTtl = Optional.ofNullable(this.resourceLimits).map(ResourceLimits::getMaxTtlCommandResponse).filter(v -> v > -1L).orElse(-1L);
        long deviceProvidedTtl = this.getNormalizedTtlPropertyValue("ttl");
        if (deviceProvidedTtl > -1L) {
            this.setTtl(deviceProvidedTtl, configuredMaxTtl);
        } else {
            this.setTtl(configuredDefaultTtl, configuredMaxTtl);
        }
    }

    private long getNormalizedTtlPropertyValue(String propertyName) {
        return Optional.ofNullable(this.props.remove(propertyName)).filter(Number.class::isInstance).map(Number.class::cast).map(Number::longValue).filter(v -> v > -1L).orElse(-1L);
    }

    private void setTtl(long deviceSpecificTtl, long configuredMaxTtl) {
        long effectiveTtl = -1L;
        if (configuredMaxTtl > effectiveTtl) {
            effectiveTtl = configuredMaxTtl;
        }
        if (effectiveTtl == -1L || deviceSpecificTtl > -1L && deviceSpecificTtl < effectiveTtl) {
            effectiveTtl = deviceSpecificTtl;
        }
        if (effectiveTtl > -1L) {
            long ttlMillis = effectiveTtl * 1000L;
            LOG.trace("setting message's TTL [{}ms]", (Object)ttlMillis);
            this.props.put("ttl", ttlMillis);
        }
    }

    public Map<String, Object> asMap() {
        return this.props;
    }
}

