/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class BeanContainerImpl
implements BeanContainer {
    private static final Logger LOGGER = Logger.getLogger(BeanContainerImpl.class.getName());
    private final ArcContainer container;

    public BeanContainerImpl(ArcContainer container) {
        this.container = container;
    }

    @Override
    public <T> BeanContainer.Factory<T> instanceFactory(Class<T> type, Annotation ... qualifiers) {
        final Supplier<InstanceHandle<T>> handleSupplier = this.container.instanceSupplier(type, qualifiers);
        if (handleSupplier == null) {
            LOGGER.debugf("No matching bean found for type %s and qualifiers %s. The bean might have been marked as unused and removed during build.", (Object)type, (Object)Arrays.toString(qualifiers));
            return new DefaultInstanceFactory<T>(type);
        }
        return new BeanContainer.Factory<T>(){

            @Override
            public BeanContainer.Instance<T> create() {
                final InstanceHandle handle = (InstanceHandle)handleSupplier.get();
                return new BeanContainer.Instance<T>(){

                    @Override
                    public T get() {
                        return handle.get();
                    }

                    @Override
                    public void close() {
                        handle.close();
                    }
                };
            }
        };
    }

    @Override
    public ManagedContext requestContext() {
        return this.container.requestContext();
    }

    static final class DefaultInstanceFactory<T>
    implements BeanContainer.Factory<T> {
        final Class<T> type;

        DefaultInstanceFactory(Class<T> type) {
            this.type = type;
        }

        @Override
        public BeanContainer.Instance<T> create() {
            try {
                final T instance = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return new BeanContainer.Instance<T>(){

                    @Override
                    public T get() {
                        return instance;
                    }
                };
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

