/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.jboss.logmanager.LogContext;

public abstract class InheritableLevel {
    InheritableLevel() {
    }

    public static InheritableLevel of(String str) {
        if (str.equalsIgnoreCase("inherit")) {
            return Inherited.INSTANCE;
        }
        return new ActualLevel(LogContext.getLogContext().getLevelForName(str.toUpperCase(Locale.ROOT)));
    }

    public abstract boolean isInherited();

    public abstract Level getLevel();

    public abstract String toString();

    public final boolean equals(Object obj) {
        return obj instanceof InheritableLevel && this.equals((InheritableLevel)obj);
    }

    public abstract boolean equals(InheritableLevel var1);

    public abstract int hashCode();

    static final class Inherited
    extends InheritableLevel {
        static final Inherited INSTANCE = new Inherited();

        private Inherited() {
        }

        @Override
        public boolean isInherited() {
            return true;
        }

        @Override
        public Level getLevel() {
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "inherited";
        }

        @Override
        public boolean equals(InheritableLevel other) {
            return other instanceof Inherited;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    static final class ActualLevel
    extends InheritableLevel {
        final Level level;

        ActualLevel(Level level) {
            this.level = level;
        }

        @Override
        public boolean isInherited() {
            return false;
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public String toString() {
            return this.level.toString();
        }

        @Override
        public boolean equals(InheritableLevel other) {
            return other instanceof ActualLevel && this.level.equals(((ActualLevel)other).level);
        }

        @Override
        public int hashCode() {
            return this.level.hashCode();
        }
    }
}

