/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.sqlite.AbstractSQLiteDatabase;
import org.eclipse.hawk.sqlite.SQLiteEdge;
import org.eclipse.hawk.sqlite.iteration.EndNodeEdgeIterable;
import org.eclipse.hawk.sqlite.iteration.StatementIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteNode
implements IGraphNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLiteNode.class);
    private final AbstractSQLiteDatabase db;
    private final int id;

    public SQLiteNode(AbstractSQLiteDatabase db, int nodeId) {
        this.db = db;
        this.id = nodeId;
    }

    public Integer getId() {
        return this.id;
    }

    public Set<String> getPropertyKeys() {
        try {
            PreparedStatement stmt = this.db.getConnection().getQueries().getNodePropKeysStatement(this.id);
            stmt.execute();
            return this.db.getConnection().getStrings(stmt);
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return Collections.emptySet();
        }
    }

    public Object getProperty(String name) {
        try {
            AbstractSQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            PreparedStatement stmt = conn.getQueries().getNodePropValueStatement(this.id, name);
            stmt.execute();
            return conn.getPropertyValue(stmt);
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.removeProperty(name);
        } else {
            try {
                AbstractSQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
                value = conn.preprocessPropertyValue(value);
                PreparedStatement stmt = conn.getQueries().getUpsertNodePropStatement(this.id, name, value);
                int rows = stmt.executeUpdate();
                assert (rows == 1) : "One row should have been inserted or updated";
            }
            catch (IOException | SQLException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public Iterable<IGraphEdge> getEdges() {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getQueries().getEdgesStatement(this.id), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            int endId = rs.getInt(3);
            String type = rs.getString(4);
            return new SQLiteEdge(this.db, edgeId, startId, endId, type);
        });
    }

    public Iterable<IGraphEdge> getEdgesWithType(String type) {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getQueries().getEdgesWithTypeStatement(type, this.id), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            int endId = rs.getInt(3);
            return new SQLiteEdge(this.db, edgeId, startId, endId, type);
        });
    }

    public Iterable<IGraphEdge> getOutgoingWithType(String type) {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getQueries().getOutgoingEdgesWithTypeStatement(type, this.id), rs -> {
            int edgeId = rs.getInt(1);
            int endId = rs.getInt(2);
            return new SQLiteEdge(this.db, edgeId, this.id, endId, type);
        });
    }

    public Iterable<IGraphEdge> getOutgoingWithType(String type, Iterable<IGraphNode> endNodes) {
        Function<IGraphNode, IGraphEdge> endNodeToEdge = node -> {
            try {
                PreparedStatement stmt = this.db.getConnection().getQueries().getOutgoingEdgesWithTypeAndNodeStatement(type, this.id, (Integer)node.getId());
                stmt.execute();
                Throwable throwable = null;
                Object var5_7 = null;
                try (ResultSet rs = stmt.getResultSet();){
                    if (rs.next()) {
                        int edgeId = rs.getInt(1);
                        int endId = rs.getInt(2);
                        return new SQLiteEdge(this.db, edgeId, this.id, endId, type);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return null;
        };
        return new EndNodeEdgeIterable(endNodes, endNodeToEdge);
    }

    public Iterable<IGraphEdge> getIncomingWithType(String type) {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getQueries().getIncomingEdgesWithTypeStatement(type, this.id), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            return new SQLiteEdge(this.db, edgeId, startId, this.id, type);
        });
    }

    public Iterable<IGraphEdge> getIncoming() {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getQueries().getIncomingEdgesStatement(this.id), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            String type = rs.getString(3);
            return new SQLiteEdge(this.db, edgeId, startId, this.id, type);
        });
    }

    public Iterable<IGraphEdge> getOutgoing() {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getQueries().getOutgoingEdgesStatement(this.id), rs -> {
            int edgeId = rs.getInt(1);
            int endId = rs.getInt(2);
            String type = rs.getString(3);
            return new SQLiteEdge(this.db, edgeId, this.id, endId, type);
        });
    }

    public void delete() {
        try {
            AbstractSQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            conn.getQueries().getDeleteNodePropsStatement(this.id).executeUpdate();
            conn.getQueries().getDeleteEdgePropsForNodeStatement(this.id).executeUpdate();
            conn.getQueries().getDeleteEdgesForNodeStatement(this.id).executeUpdate();
            conn.getQueries().getDeleteNodeStatement(this.id).executeUpdate();
            for (String idxName : this.db.getNodeIndexNames()) {
                this.db.getOrCreateNodeIndex(idxName).remove((IGraphNode)this);
            }
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public IGraphDatabase getGraph() {
        return this.db;
    }

    public void removeProperty(String name) {
        try {
            PreparedStatement stmt = this.db.getConnection().getQueries().getDeleteNodePropStatement(this.id, name);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLiteNode other = (SQLiteNode)obj;
        return this.id == other.id;
    }

    public String toString() {
        return String.format("SQLiteNode [id=%s]", this.id);
    }
}

