/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.iteration;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.hawk.sqlite.iteration.ResultSetFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetIterator<T>
implements Iterator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetIterator.class);
    private final ResultSet rs;
    private ResultSetFunction<T> resultToEdge;
    private Boolean hasNext = null;

    public ResultSetIterator(ResultSet rs, ResultSetFunction<T> resultToEdge) {
        this.rs = rs;
        this.resultToEdge = resultToEdge;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext == null) {
            try {
                this.hasNext = this.rs.next();
                if (!this.hasNext.booleanValue()) {
                    this.rs.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.hasNext = false;
            }
        }
        return this.hasNext;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            try {
                T mapped = this.resultToEdge.apply(this.rs);
                this.hasNext = null;
                return mapped;
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        throw new NoSuchElementException();
    }
}

