/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java.model;

import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.core.nd.java.model.ITypeAnnotationBuilder;
import org.eclipse.jdt.internal.core.nd.java.model.IndexBinaryTypeAnnotation;

public class TypeAnnotationBuilder
implements ITypeAnnotationBuilder {
    TypeAnnotationBuilder parent;
    int kind;
    int index;
    int length;
    int target;
    int targetParameter;
    int targetParameter2;

    private TypeAnnotationBuilder(TypeAnnotationBuilder parent, int kind, int index, int length, int nextTarget, int nextTargetParameter, int nextTargetParameter2) {
        this.parent = parent;
        this.kind = kind;
        this.index = index;
        this.length = length;
        this.target = nextTarget;
        this.targetParameter = nextTargetParameter;
        this.targetParameter2 = nextTargetParameter2;
    }

    public static TypeAnnotationBuilder create() {
        return new TypeAnnotationBuilder(null, 0, 0, 0, -1, -1, -1);
    }

    private TypeAnnotationBuilder walk(int nextKind, int nextIndex) {
        return new TypeAnnotationBuilder(this, nextKind, nextIndex, this.length + 1, this.target, this.targetParameter, this.targetParameter2);
    }

    private TypeAnnotationBuilder toTarget(int newTarget) {
        return new TypeAnnotationBuilder(this.parent, this.kind, this.index, this.length, newTarget, this.targetParameter, this.targetParameter2);
    }

    private TypeAnnotationBuilder toTarget(int newTarget, int parameter) {
        return new TypeAnnotationBuilder(this.parent, this.kind, this.index, this.length, newTarget, parameter, this.targetParameter2);
    }

    private TypeAnnotationBuilder toTarget2(int parameter) {
        return new TypeAnnotationBuilder(this.parent, this.kind, this.index, this.length, this.target, this.targetParameter, parameter);
    }

    @Override
    public ITypeAnnotationBuilder toField() {
        return this.toTarget(19);
    }

    @Override
    public ITypeAnnotationBuilder toMethodReturn() {
        return this.toTarget(20);
    }

    @Override
    public ITypeAnnotationBuilder toReceiver() {
        return this.toTarget(21);
    }

    @Override
    public ITypeAnnotationBuilder toTypeParameter(boolean isClassTypeParameter, int rank) {
        int targetType = isClassTypeParameter ? 0 : 1;
        return this.toTarget(targetType, rank);
    }

    @Override
    public ITypeAnnotationBuilder toTypeParameterBounds(boolean isClassTypeParameter, int parameterRank) {
        int targetType = isClassTypeParameter ? 17 : 18;
        return this.toTarget(targetType, parameterRank);
    }

    @Override
    public ITypeAnnotationBuilder toTypeBound(short boundIndex) {
        return this.toTarget2(boundIndex);
    }

    @Override
    public ITypeAnnotationBuilder toSupertype(short superTypeIndex) {
        return this.toTarget(16, superTypeIndex);
    }

    @Override
    public ITypeAnnotationBuilder toMethodParameter(short parameterIndex) {
        return this.toTarget(22, parameterIndex);
    }

    @Override
    public ITypeAnnotationBuilder toThrows(int rank) {
        return this.toTarget(23, rank);
    }

    @Override
    public ITypeAnnotationBuilder toTypeArgument(int rank) {
        return this.walk(3, rank);
    }

    @Override
    public ITypeAnnotationBuilder toWildcardBound() {
        return this.walk(2, 0);
    }

    @Override
    public ITypeAnnotationBuilder toNextArrayDimension() {
        return this.walk(0, 0);
    }

    @Override
    public ITypeAnnotationBuilder toNextNestedType() {
        return this.walk(1, 0);
    }

    @Override
    public IBinaryTypeAnnotation build(IBinaryAnnotation annotation) {
        return new IndexBinaryTypeAnnotation(this.target, this.targetParameter, this.targetParameter2, this.getTypePath(), annotation);
    }

    private int[] getTypePath() {
        if (this.length == 0) {
            return IBinaryTypeAnnotation.NO_TYPE_PATH;
        }
        int[] result = new int[this.length * 2];
        TypeAnnotationBuilder next = this;
        while (next != null && next.length > 0) {
            int writeIdx = (next.length - 1) * 2;
            result[writeIdx] = next.kind;
            result[writeIdx + 1] = next.index;
            next = next.parent;
        }
        return result;
    }
}

