/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.page;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import org.eclipse.fx.ui.preferences.page.FieldEditor;

public class RadioGroupFieldEditor
extends FieldEditor<String> {
    public static final String RADIO_GRID_STYLE = "radio-field-grid";
    private final StringProperty currentValue = new SimpleStringProperty((Object)this, "currentValue");
    private Map<String, RadioButton> valueToRadio = new HashMap<String, RadioButton>();
    private ToggleGroup radioGroup;

    public RadioGroupFieldEditor(String name, String label, int numColumns, String[][] labelAndValues) {
        super(name, label);
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)RADIO_GRID_STYLE);
        int column = 0;
        int row = 0;
        this.radioGroup = new ToggleGroup();
        String[][] stringArray = labelAndValues;
        int n = labelAndValues.length;
        int n2 = 0;
        while (n2 < n) {
            String[] labelAndValue = stringArray[n2];
            String radioLabel = labelAndValue[0];
            String value = labelAndValue[1];
            RadioButton radio = new RadioButton(radioLabel);
            this.valueToRadio.put(value, radio);
            radio.setToggleGroup(this.radioGroup);
            radio.selectedProperty().addListener((obs, old, newSelected) -> {
                if (newSelected.booleanValue()) {
                    this.currentValue.set((Object)value);
                }
            });
            grid.add((Node)radio, column, row);
            if (++column == numColumns) {
                column = 0;
                ++row;
            }
            ++n2;
        }
        this.getChildren().add((Object)grid);
    }

    @Override
    protected void doLoad() {
        String value = this.getMemento().get(this.getName(), "");
        RadioButton radio = this.valueToRadio.get(value);
        if (radio != null) {
            radio.setSelected(true);
        }
    }

    @Override
    protected void doRestoreDefaults() {
        String value = this.getMemento().getDefaultString(this.getName());
        RadioButton radio = this.valueToRadio.get(value);
        if (radio != null) {
            radio.setSelected(true);
        } else {
            this.radioGroup.selectToggle(null);
        }
    }

    @Override
    protected void doPersist() {
        if (this.currentValue.getValue() == null) {
            this.getMemento().remove(this.getName());
        } else {
            this.getMemento().put(this.getName(), this.currentValue.getValue());
        }
    }

    @Override
    public ObservableValue<String> getValue() {
        return this.currentValue;
    }
}

